/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUNoOverclockDescriber
extends OverclockDescriber {
    protected final int amperage;

    public EUNoOverclockDescriber(byte tier, int amperage) {
        super(tier);
        if (amperage < 1) {
            throw new IllegalArgumentException("Amperage cannot be lower than 1");
        }
        this.amperage = amperage;
    }

    @Override
    public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
        return OverclockCalculator.ofNoOverclock(recipe);
    }

    @Override
    public String getTierString() {
        return GTUtility.getColoredTierNameFromTier(this.tier);
    }

    @Override
    public final void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getDuration() > 0 && recipeInfo.calculator.getConsumption() > 0L) {
            recipeInfo.drawText(this.getTotalPowerString(recipeInfo.calculator));
        }
        this.drawEnergyInfoImpl(recipeInfo);
    }

    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(this.getVoltageString(recipeInfo.calculator));
            recipeInfo.drawText(this.getAmperageString(recipeInfo.calculator));
        }
    }

    protected String getTotalPowerString(OverclockCalculator calculator) {
        return StatCollector.func_74837_a((String)"GT5U.nei.display.total", (Object[])new Object[]{GTUtility.formatNumbers(calculator.getConsumption() * (long)calculator.getDuration())});
    }

    protected boolean shouldShowAmperage(OverclockCalculator calculator) {
        return this.amperage != 1;
    }

    protected String getEUtDisplay(OverclockCalculator calculator) {
        String tier_displayed = this.shouldShowAmperage(calculator) ? "" : GTUtility.getTierNameWithParentheses(calculator.getConsumption());
        return StatCollector.func_74837_a((String)"GT5U.nei.display.usage", (Object[])new Object[]{GTUtility.formatNumbers(calculator.getConsumption()), tier_displayed});
    }

    protected String getVoltageString(OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return StatCollector.func_74837_a((String)"GT5U.nei.display.voltage", (Object[])new Object[]{GTUtility.formatNumbers(voltage), GTUtility.getTierNameWithParentheses(voltage)});
    }

    protected String getAmperageString(OverclockCalculator calculator) {
        return StatCollector.func_74837_a((String)"GT5U.nei.display.amperage", (Object[])new Object[]{GTUtility.formatNumbers(this.amperage)});
    }

    protected long computeVoltageForEURate(long euPerTick) {
        return euPerTick / (long)this.amperage;
    }
}

