/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidCannerBackend
extends RecipeMapBackend {
    public FluidCannerBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    @Override
    protected GTRecipe findFallback(ItemStack[] items, FluidStack[] fluids, @Nullable ItemStack specialSlot) {
        for (ItemStack item : items) {
            if (item == null) continue;
            for (FluidStack fluid : fluids) {
                if (fluid == null) continue;
                ItemStack filledItem = GTUtility.fillFluidContainer(fluid, item, false, true);
                FluidStack fluidToTake = GTUtility.getFluidForFilledItem(filledItem, true);
                if (fluidToTake != null) {
                    return GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, item)).itemOutputs(filledItem).fluidInputs(fluidToTake).duration(Math.max(fluidToTake.amount / 64, 16)).eut(1).noBuffer().build().orElse(null);
                }
                FluidStack drainedFluid = GTUtility.getFluidForFilledItem(item, true);
                if (drainedFluid == null) continue;
                return GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, item)).itemOutputs(GTUtility.getContainerItem(item, true)).fluidOutputs(drainedFluid).duration(Math.max(drainedFluid.amount / 64, 16)).eut(1).noBuffer().build().orElse(null);
            }
        }
        return null;
    }

    @Override
    public boolean containsInput(ItemStack item) {
        return super.containsInput(item) || item.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)item.func_77973_b()).getCapacity(item) > 0;
    }

    @Override
    public boolean containsInput(Fluid fluid) {
        return true;
    }
}

