/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.data;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;

public class FileUtils {
    private static final Charset utf8 = StandardCharsets.UTF_8;

    public static boolean doesFileExist(File f) {
        return f != null && f.exists() && !f.isDirectory();
    }

    public static File createFile(String path, String filename, String extension) {
        File file = new File(Utils.getMcDir(), path + filename + extension);
        return FileUtils.createFile(file);
    }

    public static File createFile(File aFile) {
        boolean blnCreated = false;
        Logger.INFO("Trying to use path " + aFile.getPath());
        try {
            Logger.INFO("Trying to use path " + aFile.getCanonicalPath());
            Logger.INFO("Trying to use absolute path " + aFile.getAbsolutePath());
            blnCreated = aFile.createNewFile();
        }
        catch (IOException ioe) {
            Logger.INFO("Error while creating a new empty file :" + ioe);
            return null;
        }
        return blnCreated ? aFile : null;
    }

    public static File getFile(String filename, String extension) {
        return FileUtils.getFile("", filename, extension);
    }

    public static File getFile(String path, String filename, String extension) {
        path = path == null || path.length() == 0 ? "" : path + "/";
        if (filename == null || filename.length() == 0) {
            return null;
        }
        extension = extension == null || extension.length() == 0 ? ".txt" : "." + extension;
        File file = new File(Utils.getMcDir(), path + filename + extension);
        boolean doesExist = FileUtils.doesFileExist(file);
        if (doesExist) {
            Logger.INFO("Found File: " + file.getAbsolutePath());
            return file;
        }
        Logger.INFO("Creating file, as it was not found.");
        return FileUtils.createFile(path, filename, extension);
    }

    public static void appendListToFile(File file, List<String> content) {
        block4: {
            try {
                Path p;
                if (!FileUtils.doesFileExist(file) || !Files.isWritable(p = Paths.get(file.getPath(), new String[0]))) break block4;
                long oldSize = Files.size(p);
                try {
                    Files.write(p, content, utf8, StandardOpenOption.APPEND);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                long l = Files.size(p);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static List<String> readLines(File file) {
        try {
            return org.apache.commons.io.FileUtils.readLines((File)file, (Charset)utf8);
        }
        catch (IOException e) {
            return new ArrayList<String>();
        }
    }
}

