/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.material.MaterialMisc;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.material.nuclear.MaterialsFluorides;
import gtPlusPlus.core.material.nuclear.MaterialsNuclides;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoaderLFTR;
import gtPlusPlus.xmod.gregtech.loaders.recipe.RecipeLoaderNuclearFuelProcessing;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeLoaderNuclear {
    public static void generate() {
        RecipeLoaderNuclear.createRecipes();
        RecipeLoaderLFTR.generate();
        RecipeLoaderNuclearFuelProcessing.generate();
    }

    private static void createRecipes() {
        RecipeLoaderNuclear.autoclave();
        RecipeLoaderNuclear.blastFurnace();
        RecipeLoaderNuclear.chemicalBathRecipes();
        RecipeLoaderNuclear.chemicalReactorRecipes();
        RecipeLoaderNuclear.dehydratorRecipes();
        RecipeLoaderNuclear.electroMagneticSeperator();
        RecipeLoaderNuclear.fluidExtractorRecipes();
        RecipeLoaderNuclear.fluidHeater();
        RecipeLoaderNuclear.fusionChainRecipes();
        RecipeLoaderNuclear.macerator();
        RecipeLoaderNuclear.mixerRecipes();
        RecipeLoaderNuclear.sifter();
    }

    private static void autoclave() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("pelletZirconium", 1)).fluidInputs(FluidUtils.getFluidStack("chlorine", 4000)).duration(300).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.autoclaveRecipes);
    }

    private static void blastFurnace() {
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.LITHIUM_FLUORIDE.getDust(4), MaterialsFluorides.BERYLLIUM_FLUORIDE.getDust(3)).itemOutputs(MaterialsNuclides.Li2BeF4.getDust(7)).duration(2800).eut(TierEU.RECIPE_EV).metadata(GTRecipeConstants.COIL_HEAT, 3000).addTo(RecipeMaps.blastFurnaceRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustZrCl4", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 1)).duration(1200).eut(340).metadata(GTRecipeConstants.COIL_HEAT, 300).addTo(RecipeMaps.blastFurnaceRecipes);
    }

    private static void chemicalBathRecipes() {
        int[] chances = new int[]{9000, 6000, 3000};
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 12)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 4), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 5)).outputChances(chances).fluidInputs(FluidUtils.getFluidStack("chlorine", 2400)).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.chemicalBathRecipes);
        chances = new int[]{9000, 3000, 1000};
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustRutile", 5)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustTitanium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1)).outputChances(chances).fluidInputs(FluidUtils.getFluidStack("chlorine", 4000)).duration(600).eut(1024).addTo(RecipeMaps.chemicalBathRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 2)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid", 500)).duration(180).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.chemicalBathRecipes);
    }

    private static void chemicalReactorRecipes() {
        ItemStack aGtHydrofluoricAcid = ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellHydrofluoricAcid_GT5U", 2);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumHydroxide", 5)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLi2CO3CaOH2", 11)).duration(12000).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 3)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 2)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid", 500)).fluidOutputs(Materials.Water.getFluid(1000L)).duration(2400).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("cellOxygen", 8), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium7", 16)).itemOutputs(ItemList.Cell_Empty.get(8L, new Object[0])).fluidInputs(Materials.Water.getFluid(8000L)).fluidOutputs(FluidUtils.getFluidStack("lithiumhydroxide", 6912)).duration(6000).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), MaterialsElements.getInstance().OXYGEN.getCell(1)).itemOutputs(ItemList.Cell_Empty.get(1L, new Object[0])).fluidInputs(MaterialsElements.getInstance().HYDROGEN.getFluidStack(1000)).fluidOutputs(MaterialMisc.HYDROXIDE.getFluidStack(1000)).duration(160).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), MaterialsElements.getInstance().BERYLLIUM.getDust(1)).fluidInputs(MaterialMisc.HYDROXIDE.getFluidStack(2000)).fluidOutputs(MaterialsFluorides.BERYLLIUM_HYDROXIDE.getFluidStack(432)).duration(80).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrofluoricAcid", 1)).itemOutputs(ItemList.Cell_Empty.get(1L, new Object[0])).fluidInputs(MaterialMisc.AMMONIA.getFluidStack(1000)).fluidOutputs(MaterialsFluorides.AMMONIUM_BIFLUORIDE.getFluidStack(576)).duration(400).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), aGtHydrofluoricAcid).itemOutputs(ItemList.Cell_Empty.get(2L, new Object[0])).fluidInputs(MaterialMisc.AMMONIA.getFluidStack(1000)).fluidOutputs(MaterialsFluorides.AMMONIUM_BIFLUORIDE.getFluidStack(576)).duration(800).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3), MaterialsElements.getInstance().HYDROGEN.getCell(1)).itemOutputs(ItemList.Cell_Empty.get(1L, new Object[0])).fluidInputs(MaterialMisc.AMMONIA.getFluidStack(1000)).fluidOutputs(MaterialMisc.AMMONIUM.getFluidStack(2000)).duration(400).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(15), Materials.SodiumHydroxide.getDust(3)).itemOutputs(MaterialsFluorides.SODIUM_FLUORIDE.getDust(2)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid", 500)).fluidOutputs(Materials.Water.getFluid(1000L)).duration(1200).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(15), Materials.SodiumHydroxide.getDust(3)).itemOutputs(MaterialsFluorides.SODIUM_FLUORIDE.getDust(2)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 1000)).fluidOutputs(Materials.Water.getFluid(1000L)).duration(1200).eut(TierEU.RECIPE_LV).addTo(GTRecipeConstants.UniversalChemical);
    }

    private static void dehydratorRecipes() {
        GTValues.RA.stdBuilder().fluidInputs(FluidUtils.getFluidStack("sulfuriclithium", 1440)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustSulfur", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustCopper", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSodium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustCarbon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium7", 4)).duration(600).eut(30).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Cell_Empty.get(12L, new Object[0]), ItemUtils.getItemStackOfAmountFromOreDict("dustLepidolite", 20)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustPotassium", 1), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Aluminium, 4L), ItemUtils.getItemStackOfAmountFromOreDict("cellOxygen", 10), ItemUtils.getItemStackOfAmountFromOreDict("cellFluorine", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumCarbonate", 3)).fluidInputs(Materials.SulfuricAcid.getFluid(10000L)).fluidOutputs(FluidUtils.getFluidStack("sulfuriclithium", 10000)).eut(1000).duration(1500).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        if (ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 1) != null) {
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 2)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumHydroxide", 5)).fluidInputs(Materials.Water.getFluid(1000L)).eut(TierEU.RECIPE_MV).duration(240).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        } else {
            Logger.INFO("[dustCalciumHydroxide] FAILED TO LOAD RECIPE");
            if (ItemUtils.getItemStackOfAmountFromOreDict("dustQuicklime", 1) == null) {
                Logger.INFO("Could not find dustQuicklime, cannot make dustCalciumHydroxide.");
            }
        }
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLi2CO3CaOH2", 11)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 6), ItemUtils.getItemStackOfAmountFromOreDict("dustCalciumCarbonate", 5)).eut(1000).duration(7200).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumHydroxide", 1)).fluidInputs(FluidUtils.getFluidStack("lithiumhydroxide", 144)).eut(64).duration(20).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        FluidStack aHydrogenChloride = Materials.HydrochloricAcid.getFluid(800L);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(11), ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 1)).itemOutputs(MaterialsFluorides.ZIRCONIUM_TETRAFLUORIDE.getDust(1)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid", 400)).fluidOutputs(aHydrogenChloride).eut(TierEU.RECIPE_HV).duration(300).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(10), ItemUtils.getItemStackOfAmountFromOreDict("dustCookedZrCl4", 1)).itemOutputs(MaterialsFluorides.ZIRCONIUM_TETRAFLUORIDE.getDust(1)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid_gt5u", 800)).fluidOutputs(aHydrogenChloride).eut(TierEU.RECIPE_HV).duration(600).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.BERYLLIUM_HYDROXIDE.getDust(3), ItemList.Cell_Empty.get(2L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("cellWater", 2)).fluidInputs(MaterialsFluorides.AMMONIUM_BIFLUORIDE.getFluidStack(1152)).fluidOutputs(MaterialsFluorides.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(1000)).eut(64).duration(120).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.BERYLLIUM_HYDROXIDE.getDust(3)).fluidInputs(MaterialsFluorides.AMMONIUM_BIFLUORIDE.getFluidStack(1152)).fluidOutputs(Materials.Water.getFluid(2000L), MaterialsFluorides.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(1000)).eut(TierEU.RECIPE_MV).duration(6000).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17), ItemList.Cell_Empty.get(3L, new Object[0])).itemOutputs(MaterialMisc.AMMONIA.getCell(2), ItemUtils.getItemStackOfAmountFromOreDict("cellHydrofluoricAcid", 1), MaterialsFluorides.BERYLLIUM_FLUORIDE.getDust(3)).fluidInputs(MaterialsFluorides.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(1000)).eut(TierEU.RECIPE_MV).duration(6000).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(17)).itemOutputs(MaterialsFluorides.BERYLLIUM_FLUORIDE.getDust(3)).fluidInputs(MaterialsFluorides.AMMONIUM_TETRAFLUOROBERYLLATE.getFluidStack(1000)).fluidOutputs(MaterialMisc.AMMONIA.getFluidStack(2000), FluidUtils.getFluidStack("hydrofluoricacid", 1000)).eut(TierEU.RECIPE_MV).duration(6000).addTo(RecipeMaps.multiblockChemicalReactorRecipes);
    }

    private static void electroMagneticSeperator() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedBauxite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustBauxite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallRutile", 1), ItemUtils.getItemStackOfAmountFromOreDict("nuggetZirconium", 1)).outputChances(10000, 2500, 4000).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedMagnetite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustMagnetite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallZircon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyZircon", 1)).outputChances(10000, 1250, 2500).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedCassiterite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCassiterite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallZircon", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyZircon", 1)).outputChances(10000, 1250, 2500).duration(400).eut(24).addTo(RecipeMaps.electroMagneticSeparatorRecipes);
    }

    private static void fluidExtractorRecipes() {
        GTValues.RA.stdBuilder().itemInputs(MaterialsNuclides.Li2BeF4.getDust(1)).fluidOutputs(MaterialsNuclides.Li2BeF4.getFluidStack(144)).duration(100).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustLithiumFluoride", 1)).fluidOutputs(MaterialsFluorides.LITHIUM_FLUORIDE.getFluidStack(144)).duration(100).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustBerylliumFluoride", 1)).fluidOutputs(MaterialsFluorides.BERYLLIUM_FLUORIDE.getFluidStack(144)).duration(100).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsNuclides.LiFBeF2ZrF4U235.getDust(1)).fluidOutputs(MaterialsNuclides.LiFBeF2ZrF4U235.getFluidStack(144)).duration(250).eut(1000).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsNuclides.LiFBeF2ZrF4UF4.getDust(1)).fluidOutputs(MaterialsNuclides.LiFBeF2ZrF4UF4.getFluidStack(144)).duration(150).eut(1500).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsNuclides.LiFBeF2ThF4UF4.getDust(1)).fluidOutputs(MaterialsNuclides.LiFBeF2ThF4UF4.getFluidStack(144)).duration(150).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.fluidExtractionRecipes);
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.ZIRCONIUM_TETRAFLUORIDE.getDust(1)).fluidOutputs(MaterialsFluorides.ZIRCONIUM_TETRAFLUORIDE.getFluidStack(144)).duration(200).eut(768).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    private static void fusionChainRecipes() {
        GTValues.RA.stdBuilder().fluidInputs(Materials.Boron.getPlasma(144L), Materials.Calcium.getPlasma(16L)).fluidOutputs(new FluidStack(MaterialsElements.getInstance().NEON.getPlasma(), 1000)).duration(64).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.FUSION_THRESHOLD, 100000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(MaterialsElements.getInstance().NEON.getPlasma(), 144), new FluidStack(MaterialsAlloy.ARCANITE.getFluid(), 2)).fluidOutputs(new FluidStack(MaterialsElements.STANDALONE.FORCE.getPlasma(), 1000)).duration(32).eut(TierEU.RECIPE_LuV).metadata(GTRecipeConstants.FUSION_THRESHOLD, 100000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(Materials.Niobium.getPlasma(144L), Materials.Zinc.getPlasma(144L)).fluidOutputs(new FluidStack(MaterialsElements.getInstance().KRYPTON.getPlasma(), 144)).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.FUSION_THRESHOLD, 300000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(MaterialsElements.getInstance().KRYPTON.getPlasma(), 144), new FluidStack(MaterialsElements.STANDALONE.FORCE.getPlasma(), 1000)).fluidOutputs(new FluidStack(MaterialsElements.STANDALONE.ASTRAL_TITANIUM.getPlasma(), 1000)).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.FUSION_THRESHOLD, 300000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(MaterialsElements.STANDALONE.ASTRAL_TITANIUM.getPlasma(), 144), new FluidStack(MaterialsAlloy.TITANSTEEL.getFluid(), 2)).fluidOutputs(new FluidStack(MaterialsElements.STANDALONE.RUNITE.getPlasma(), 1000)).duration(32).eut(TierEU.RECIPE_ZPM).metadata(GTRecipeConstants.FUSION_THRESHOLD, 300000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(MaterialsElements.getInstance().CURIUM.getFluidStack(144), Materials.Americium.getPlasma(144L)).fluidOutputs(new FluidStack(MaterialsElements.getInstance().XENON.getPlasma(), 144)).duration(16).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.FUSION_THRESHOLD, 500000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(MaterialsElements.getInstance().XENON.getPlasma(), 144), new FluidStack(MaterialsElements.STANDALONE.RUNITE.getPlasma(), 1000)).fluidOutputs(new FluidStack(MaterialsElements.STANDALONE.ADVANCED_NITINOL.getPlasma(), 1000)).duration(16).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.FUSION_THRESHOLD, 500000000L).addTo(RecipeMaps.fusionRecipes);
        GTValues.RA.stdBuilder().fluidInputs(new FluidStack(MaterialsElements.STANDALONE.ADVANCED_NITINOL.getPlasma(), 72), Materials.Tartarite.getMolten(2L)).fluidOutputs(new FluidStack(MaterialsElements.STANDALONE.CELESTIAL_TUNGSTEN.getPlasma(), 1000)).duration(8).eut(TierEU.RECIPE_UV).metadata(GTRecipeConstants.FUSION_THRESHOLD, 500000000L).addTo(RecipeMaps.fusionRecipes);
    }

    private static void macerator() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("pelletZirconium", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustZrCl4", 5)).eut(2).duration(400).addTo(RecipeMaps.maceratorRecipes);
    }

    private static void mixerRecipes() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("dustUranium233", 4), ItemUtils.getItemStackOfAmountFromOreDict("dustUranium235", 1)).fluidInputs(FluidUtils.getFluidStack("hydrofluoricacid", 10000)).fluidOutputs(MaterialsFluorides.URANIUM_TETRAFLUORIDE.getFluidStack(3600)).duration(3000).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.mixerRecipes);
    }

    private static void sifter() {
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedIlmenite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustWroughtIron", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustHafnium", 1)).outputChances(5000, 278, 1000, 1000, 300, 300).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedTin", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZinc", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1)).outputChances(10000, 556, 1500, 1000, 500, 500).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedCassiterite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustCassiterite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustTin", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustZirconium", 1)).outputChances(10000, 556, 1500, 1000, 500, 500).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedThorium", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustThorium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)).outputChances(10000, 500, 300, 200, 100, 100).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedUranium", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustUranium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)).outputChances(10000, 556, 1000, 500, 500, 500).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedUraninite", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustUraninite", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustUranium", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)).outputChances(10000, 556, 500, 250, 250, 250).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemUtils.getItemStackOfAmountFromOreDict("crushedPurifiedPitchblende", 1)).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("dustPitchblende", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustLead", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1), ItemUtils.getItemStackOfAmountFromOreDict("dustRadium226", 1)).outputChances(10000, 556, 500, 250, 250, 250).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.sifterRecipes);
    }

    private static void fluidHeater() {
        GTValues.RA.stdBuilder().itemInputs(MaterialsFluorides.SODIUM_FLUORIDE.getDust(1)).fluidOutputs(MaterialsFluorides.SODIUM_FLUORIDE.getFluidStack(144)).duration(600).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidHeaterRecipes);
    }
}

