/*
 * Decompiled with CFR 0.152.
 */
package kubatech.commands;

import gregtech.GTMod;
import java.math.BigInteger;
import java.util.UUID;
import kubatech.api.tea.TeaNetwork;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandTea
extends CommandBase {
    public String func_71517_b() {
        return "tea";
    }

    public String func_71518_a(ICommandSender sender) {
        return "tea " + Translations.USAGE.get();
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
            return;
        }
        UUID player = GTMod.proxy.getPlayersUUID(args[0]);
        if (player == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.PLAYER_NOT_FOUND.get()));
            return;
        }
        TeaNetwork teaNetwork = TeaNetwork.getNetwork(player);
        if (!args[1].equalsIgnoreCase("get") && args.length < 3) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
            return;
        }
        switch (args[1].toLowerCase()) {
            case "get": {
                sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_GET.get(args[0], teaNetwork.teaAmount)));
                break;
            }
            case "set": {
                BigInteger tea;
                try {
                    tea = new BigInteger(args[2]);
                }
                catch (NumberFormatException ex) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
                    return;
                }
                teaNetwork.teaAmount = tea;
                teaNetwork.markDirty();
                sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_SET.get(args[0], teaNetwork.teaAmount)));
                break;
            }
            case "add": {
                BigInteger tea;
                try {
                    tea = new BigInteger(args[2]);
                }
                catch (NumberFormatException ex) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.INVALID_OPTION.get()));
                    return;
                }
                teaNetwork.addTea(tea);
                sender.func_145747_a((IChatComponent)new ChatComponentText(Translations.SUCCESS_ADD.get(args[0], teaNetwork.teaAmount)));
                break;
            }
        }
    }

    static enum Translations {
        INVALID_OPTION,
        PLAYER_NOT_FOUND,
        SUCCESS_GET,
        SUCCESS_SET,
        SUCCESS_ADD,
        USAGE;

        final String key = "kubatech.command.tea." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public String get(Object ... args) {
            return StatCollector.func_74837_a((String)this.key, (Object[])args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

