/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.factory.test;

import gregtech.api.factory.test.TestFactoryElement;
import gregtech.api.factory.test.TestFactoryGrid;
import gregtech.api.factory.test.TestFactoryNetwork;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.hatch.MTEBaseFactoryHatch;
import tectech.util.CommonValues;

public class TestFactoryHatch
extends MTEBaseFactoryHatch
implements TestFactoryElement {
    private TestFactoryNetwork network;

    public TestFactoryHatch(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datain.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datain.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datain.desc.2")});
    }

    protected TestFactoryHatch(TestFactoryHatch prototype) {
        super(prototype);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TestFactoryHatch(this);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74778_a("network", this.network == null ? "null" : this.network.toString());
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        currenttip.add("Network: " + accessor.getNBTData().func_74779_i("network"));
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        if (this.network == null) {
            data.add(StatCollector.func_74838_a((String)"GT5U.infodata.no_network"));
        } else {
            for (TestFactoryHatch hatch : this.network.getComponents(TestFactoryHatch.class)) {
                IGregTechTileEntity base = hatch.getBaseMetaTileEntity();
                data.add(base.getXCoord() + ", " + base.getYCoord() + ", " + base.getZCoord() + ": " + hatch.toString());
            }
        }
        return data.toArray(new String[data.size()]);
    }

    @Override
    public List<Pair<Class<?>, Object>> getComponents() {
        return Collections.singletonList(Pair.of(TestFactoryHatch.class, (Object)this));
    }

    @Override
    public boolean canConnectOnSide(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public void getNeighbours(Collection<TestFactoryElement> neighbours) {
        IGregTechTileEntity igte;
        IGregTechTileEntity base = this.getBaseMetaTileEntity();
        Object object = base.getTileEntityAtSide(base.getFrontFacing());
        if (object instanceof IGregTechTileEntity && (igte = (IGregTechTileEntity)object).getColorization() == base.getColorization() && (object = igte.getMetaTileEntity()) instanceof TestFactoryElement) {
            TestFactoryElement element = (TestFactoryElement)object;
            neighbours.add(element);
        }
    }

    @Override
    public TestFactoryNetwork getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(TestFactoryNetwork network) {
        this.network = network;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        TestFactoryGrid.INSTANCE.addElement(this);
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        TestFactoryGrid.INSTANCE.removeElement(this);
    }

    @Override
    public void onFacingChange() {
        super.onFacingChange();
        TestFactoryGrid.INSTANCE.addElement(this);
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        TestFactoryGrid.INSTANCE.addElement(this);
    }
}

