/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.hazards;

import gregtech.api.hazards.Hazard;
import java.util.HashSet;
import java.util.Set;

public class HazardProtectionTooltip {
    public static String FULL_PROTECTION_TRANSLATION_KEY = "GT5U.providesfullhazmatprotection";
    public static String CBRN_TRANSLATION_KEY = "GT5U.providesCBRNprotection";
    public static String EXTREME_TEMP_TRANSLATION_KEY = "GT5U.providesextremetemperatureprotection";
    public static final Set<Hazard> CBRN_HAZARDS = HazardProtectionTooltip.cbrnHazards();
    public static final Set<Hazard> TEMPERATURE_HAZARDS = HazardProtectionTooltip.temperatureHazards();

    public static String singleHazardTranslationKey(Hazard hazard) {
        String string;
        switch (hazard) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BIOLOGICAL: {
                string = "GT5U.providesbiologicalhazmatprotection";
                break;
            }
            case FROST: {
                string = "GT5U.providesfrosthazmatprotection";
                break;
            }
            case HEAT: {
                string = "GT5U.providesheathazmatprotection";
                break;
            }
            case RADIOLOGICAL: {
                string = "GT5U.providesradiohazmatprotection";
                break;
            }
            case ELECTRICAL: {
                string = "GT5U.provideselectricalhazmatprotection";
                break;
            }
            case GAS: {
                string = "GT5U.providesgashazmatprotection";
            }
        }
        return string;
    }

    private static HashSet<Hazard> cbrnHazards() {
        HashSet<Hazard> set = new HashSet<Hazard>();
        set.add(Hazard.BIOLOGICAL);
        set.add(Hazard.GAS);
        set.add(Hazard.RADIOLOGICAL);
        return set;
    }

    private static HashSet<Hazard> temperatureHazards() {
        HashSet<Hazard> set = new HashSet<Hazard>();
        set.add(Hazard.FROST);
        set.add(Hazard.HEAT);
        return set;
    }
}

