/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.ChatMessage;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GTUtility;
import gregtech.api.util.Localized;
import java.util.ArrayList;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTTextBuilder {
    public static final EnumChatFormatting NAME = EnumChatFormatting.DARK_AQUA;
    public static final EnumChatFormatting NUMERIC = EnumChatFormatting.GOLD;
    public static final EnumChatFormatting VALUE = EnumChatFormatting.GREEN;
    public Object key;
    public ArrayList<Object> values = new ArrayList();
    public EnumChatFormatting base = EnumChatFormatting.WHITE;

    public GTTextBuilder(String langKey) {
        this.key = langKey;
    }

    public GTTextBuilder(ChatMessage message) {
        this.key = message;
    }

    public GTTextBuilder setBase(EnumChatFormatting base) {
        this.base = base;
        return this;
    }

    public GTTextBuilder add(@Nullable Object style, @NotNull Object data) {
        this.values.add((style == null ? "" : style.toString()) + data + this.base);
        return this;
    }

    public GTTextBuilder addText(String text) {
        this.add(this.base, text);
        return this;
    }

    public GTTextBuilder addLocalized(Localized l) {
        this.values.add(l);
        return this;
    }

    public GTTextBuilder addName(String name) {
        this.add(NAME, name);
        return this;
    }

    public GTTextBuilder addCoord(int x, int y, int z) {
        this.values.add("X=" + NUMERIC + GTUtility.formatNumbers(x) + this.base + " Y=" + NUMERIC + GTUtility.formatNumbers(y) + this.base + " Z=" + NUMERIC + GTUtility.formatNumbers(z) + this.base);
        return this;
    }

    public GTTextBuilder addCoord(IHasWorldObjectAndCoords machine) {
        this.addCoord(machine.getXCoord(), machine.getYCoord(), machine.getZCoord());
        return this;
    }

    public GTTextBuilder addValue(String value) {
        this.add(VALUE, value);
        return this;
    }

    public GTTextBuilder addNumber(int i) {
        this.add(NUMERIC, GTUtility.formatNumbers(i));
        return this;
    }

    public GTTextBuilder addNumber(long l) {
        this.add(NUMERIC, GTUtility.formatNumbers(l));
        return this;
    }

    public GTTextBuilder addNumber(float f) {
        this.add(NUMERIC, GTUtility.formatNumbers(f));
        return this;
    }

    public GTTextBuilder addNumber(double d) {
        this.add(NUMERIC, GTUtility.formatNumbers(d));
        return this;
    }

    public GTTextBuilder addNumber(String s) {
        this.add(NUMERIC, s);
        return this;
    }

    public Localized toLocalized() {
        return new Localized(this.key, this.values.toArray()).setBase(this.base);
    }

    public String toString() {
        return this.toLocalized().toString();
    }
}

