/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.item;

import com.cleanroommc.modularui.utils.item.IItemHandlerModifiable;
import gregtech.api.interfaces.IConfigurationCircuitSupport;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.util.GTUtility;
import gregtech.common.items.ItemIntegratedCircuit;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class GhostCircuitItemStackHandler
implements IItemHandlerModifiable {
    public static final int NO_CONFIG = -1;
    private final ItemStack[] inventory;
    private final int circuitSlot;

    public GhostCircuitItemStackHandler(IMetaTileEntity mte) {
        if (!(mte instanceof CommonMetaTileEntity)) {
            throw new IllegalArgumentException("Unknown MetaTileEntity: " + mte);
        }
        CommonMetaTileEntity cmte = (CommonMetaTileEntity)mte;
        this.inventory = cmte.mInventory;
        if (!(mte instanceof IConfigurationCircuitSupport)) {
            throw new IllegalArgumentException(mte + " does not implement IConfigurationCircuitSupport");
        }
        IConfigurationCircuitSupport ccs = (IConfigurationCircuitSupport)((Object)mte);
        this.circuitSlot = ccs.getCircuitSlot();
    }

    public boolean hasCircuit() {
        return this.inventory[this.circuitSlot] != null;
    }

    public int getCircuitConfig() {
        if (this.hasCircuit()) {
            return this.inventory[this.circuitSlot].func_77960_j();
        }
        return -1;
    }

    public void setCircuitConfig(int config) {
        if (config == -1) {
            this.inventory[this.circuitSlot] = null;
        } else if (config >= 1 && config <= 24) {
            this.inventory[this.circuitSlot] = GTUtility.getIntegratedCircuit(config);
        } else {
            throw new IllegalArgumentException("Invalid circuit config: " + config);
        }
    }

    public void setStackInSlot(int slot, @Nullable ItemStack stack) {
        this.validateSlot(slot);
        if (this.isItemValid(slot, stack)) {
            if (stack != null) {
                stack.field_77994_a = 0;
            }
            this.inventory[this.circuitSlot] = stack;
        }
    }

    public int getSlots() {
        return 1;
    }

    @Nullable
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        return this.inventory[this.circuitSlot];
    }

    @Nullable
    public ItemStack insertItem(int slot, @Nullable ItemStack stack, boolean simulate) {
        this.validateSlot(slot);
        return stack;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        this.validateSlot(slot);
        return null;
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        return 0;
    }

    public boolean isItemValid(int slot, @Nullable ItemStack stack) {
        this.validateSlot(slot);
        return stack == null || stack.func_77973_b() instanceof ItemIntegratedCircuit;
    }

    private void validateSlot(int slot) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Slot index out of bounds: " + slot);
        }
    }
}

