/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.gui;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IStringValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MathUtils;
import com.cleanroommc.modularui.value.sync.EnumSyncValue;
import com.cleanroommc.modularui.value.sync.IntSyncValue;
import com.cleanroommc.modularui.value.sync.PanelSyncManager;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.ParentWidget;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import gregtech.api.modularui2.GTGuiTextures;
import gregtech.common.covers.CoverFluidRegulator;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.modes.MachineProcessingCondition;
import gregtech.common.covers.modes.TransferMode;
import gregtech.common.modularui2.widget.builder.EnumRowBuilder;
import org.jetbrains.annotations.NotNull;

public class CoverFluidRegulatorGui
extends CoverGui<CoverFluidRegulator> {
    private static final NumberFormatMUI numberFormat = new NumberFormatMUI();

    public CoverFluidRegulatorGui(CoverFluidRegulator cover) {
        super(cover);
    }

    @Override
    public void addUIWidgets(PanelSyncManager syncManager, Flow column) {
        EnumSyncValue ioModeSyncValue = new EnumSyncValue(TransferMode.class, ((CoverFluidRegulator)this.cover)::getIOMode, ((CoverFluidRegulator)this.cover)::setIOMode);
        syncManager.syncValue("io_mode", (SyncHandler)ioModeSyncValue);
        EnumSyncValue conditionModeSyncValue = new EnumSyncValue(MachineProcessingCondition.class, ((CoverFluidRegulator)this.cover)::getMachineProcessingCondition, ((CoverFluidRegulator)this.cover)::setMachineProcessingCondition);
        syncManager.syncValue("condition_mode", (SyncHandler)conditionModeSyncValue);
        column.child((IWidget)((Flow)((Flow)((Flow)this.makeRowLayout().child((IWidget)this.positionRow(CoverFluidRegulatorGui.makeTransferModeRow((EnumSyncValue<TransferMode>)ioModeSyncValue)))).child((IWidget)this.positionRow(CoverFluidRegulatorGui.makeMachineConditionModeRow((EnumSyncValue<MachineProcessingCondition>)conditionModeSyncValue)))).child((IWidget)this.positionRow(this.makeSpeedConfigRow()))).child((IWidget)this.positionRow(this.makeAverageSpeedRow()).marginTop(3)));
    }

    private static Flow makeTransferModeRow(EnumSyncValue<TransferMode> ioModeSyncValue) {
        return (Flow)((Flow)Flow.row().child((IWidget)((ParentWidget)new ParentWidget().child((IWidget)new EnumRowBuilder<TransferMode>(TransferMode.class).value(ioModeSyncValue).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_EXPORT, GTGuiTextures.OVERLAY_BUTTON_IMPORT}).build())).width(80))).child((IWidget)IKey.lang((String)"gt.interact.desc.fluid_regulator.ExpImp").asWidget());
    }

    private static Flow makeMachineConditionModeRow(EnumSyncValue<MachineProcessingCondition> conditionModeSyncValue) {
        return (Flow)((Flow)Flow.row().child((IWidget)((ParentWidget)new ParentWidget().child((IWidget)new EnumRowBuilder<MachineProcessingCondition>(MachineProcessingCondition.class).value(conditionModeSyncValue).overlay(new IDrawable[]{GTGuiTextures.OVERLAY_BUTTON_CHECKMARK, GTGuiTextures.OVERLAY_BUTTON_USE_PROCESSING_STATE, GTGuiTextures.OVERLAY_BUTTON_USE_INVERTED_PROCESSING_STATE}).build())).width(80))).child((IWidget)IKey.lang((String)"gt.interact.desc.fluid_regulator.Conditional").asWidget());
    }

    private Flow makeSpeedConfigRow() {
        return (Flow)((Flow)((Flow)((Flow)Flow.row().child((IWidget)this.makeNumberField().value((IStringValue)new IntSyncValue(((CoverFluidRegulator)this.cover)::getSpeed, ((CoverFluidRegulator)this.cover)::setSpeed)).setNumbers(((CoverFluidRegulator)this.cover)::getMinSpeed, ((CoverFluidRegulator)this.cover)::getMaxSpeed).setFocusOnGuiOpen(true))).child((IWidget)IKey.lang((String)"gt.interact.desc.fluid_regulator.L").asWidget())).child((IWidget)this.makeNumberField(36).value((IStringValue)new IntSyncValue(((CoverFluidRegulator)this.cover)::getTickRateForUi, ((CoverFluidRegulator)this.cover)::setTickRateForUi)).setValidator(this::validateTickRateText))).child((IWidget)IKey.lang((String)"gt.interact.desc.fluid_regulator.Ticks").asWidget());
    }

    @NotNull
    private String validateTickRateText(String tickRateText) {
        return Long.toString((long)this.valiateTickRate(MathUtils.parseExpression((String)tickRateText, (double)((CoverFluidRegulator)this.cover).getTickRateForUi(), (boolean)true).getResult()));
    }

    private double valiateTickRate(double val) {
        int speed = ((CoverFluidRegulator)this.cover).getSpeed();
        long transferRate = ((CoverFluidRegulator)this.cover).getTransferRate();
        if (val > 2048.0) {
            val = 2048.0;
        } else if ((double)Math.abs(speed) > (double)transferRate * val) {
            val = Math.min(2048L, ((long)Math.abs(speed) + transferRate - 1L) / transferRate);
        } else if (val < 1.0) {
            val = 1.0;
        }
        return val;
    }

    private Flow makeAverageSpeedRow() {
        return (Flow)((Flow)Flow.row().collapseDisabledChild().child((IWidget)IKey.dynamic(this::getAverageSpeedText).color(Integer.valueOf(Color.RED.main)).asWidget().setEnabledIf(w -> this.isAtSpeedLimit()))).child((IWidget)IKey.dynamic(this::getAverageSpeedText).asWidget().setEnabledIf(w1 -> !this.isAtSpeedLimit()));
    }

    private boolean isAtSpeedLimit() {
        return Math.abs(((CoverFluidRegulator)this.cover).getSpeed()) == ((CoverFluidRegulator)this.cover).getMaxSpeed();
    }

    @NotNull
    private String getAverageSpeedText() {
        return IKey.lang((String)"gt.interact.desc.fluid_regulator.Average") + " " + numberFormat.format(((CoverFluidRegulator)this.cover).getTickRateForUi() == 0 ? 0.0 : (double)((CoverFluidRegulator)this.cover).getSpeed() * 20.0 / (double)((CoverFluidRegulator)this.cover).getTickRateForUi()) + " " + IKey.lang((String)"gt.interact.desc.fluid_regulator.L_Sec");
    }

    static {
        numberFormat.setMaximumFractionDigits(2);
    }
}

