/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.mui1.cover;

import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.common.covers.Cover;
import gregtech.common.covers.redstone.CoverWirelessFluidDetector;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerNumericWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollowerToggleButtonWidget;
import gregtech.common.gui.mui1.cover.AdvancedRedstoneTransmitterBaseUIFactory;
import java.util.Arrays;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class WirelessFluidDetectorUIFactory
extends AdvancedRedstoneTransmitterBaseUIFactory<CoverWirelessFluidDetector> {
    private int maxCapacity;

    public WirelessFluidDetectorUIFactory(CoverUIBuildContext buildContext) {
        super(buildContext);
    }

    @Override
    protected int getGUIHeight() {
        return 123;
    }

    @Override
    protected CoverWirelessFluidDetector adaptCover(Cover cover) {
        if (cover instanceof CoverWirelessFluidDetector) {
            CoverWirelessFluidDetector adaptedCover = (CoverWirelessFluidDetector)cover;
            return adaptedCover;
        }
        return null;
    }

    @Override
    @NotNull
    protected CoverDataControllerWidget<CoverWirelessFluidDetector> getDataController() {
        return new CoverDataControllerWidget<CoverWirelessFluidDetector>(this::getCover, this.getUIBuildContext());
    }

    @Override
    protected void addUIWidgets(ModularWindow.Builder builder) {
        this.setMaxCapacity();
        super.addUIWidgets(builder);
        ((ModularWindow.Builder)builder.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.interact.desc.Wireless_Fluid_Detector.FluidThreshold")).setPos(100, 65))).widget(TextWidget.dynamicString(this.getCoverString(c -> c.isPhysical() ? StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.1") : StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.0"))).setSynced(false).setTextAlignment(Alignment.CenterLeft).setPos(28, 83).setSize(180, 12));
    }

    @Override
    protected void addUIForDataController(CoverDataControllerWidget<CoverWirelessFluidDetector> controller) {
        super.addUIForDataController(controller);
        controller.addFollower(new CoverDataFollowerNumericWidget(), coverData -> coverData.getThreshold(), (coverData, state) -> coverData.setThreshold(state.intValue()), widget -> widget.setBounds(0.0, this.maxCapacity > 0 ? (double)this.maxCapacity : 2.147483647E9).setScrollValues(1000.0, 144.0, 100000.0).setFocusOnGuiOpen(true).setPos(1, 38).setSize(86, 12)).addFollower(CoverDataFollowerToggleButtonWidget.ofDisableable(), CoverWirelessFluidDetector::isPhysical, CoverWirelessFluidDetector::setPhysical, widget -> widget.addTooltip(StatCollector.func_74838_a((String)"gt.cover.wirelessdetector.redstone.tooltip")).setPos(0, 55));
    }

    private void setMaxCapacity() {
        ICoverable tile = this.getUIBuildContext().getTile();
        if (!tile.isDead() && tile instanceof IFluidHandler) {
            FluidTankInfo[] tanks = ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN);
            this.maxCapacity = Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
        } else {
            this.maxCapacity = -1;
        }
    }
}

