/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.modularui2.widget;

import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.ItemDrawable;
import com.cleanroommc.modularui.integration.nei.NEIIngredientProvider;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.GlStateManager;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SlotLikeButtonWidget
extends ButtonWidget<SlotLikeButtonWidget>
implements NEIIngredientProvider {
    private final Supplier<ItemStack> itemSupplier;
    private final IDrawable itemDrawable;

    public SlotLikeButtonWidget(ItemStack itemStack) {
        this.itemSupplier = () -> itemStack;
        this.itemDrawable = new ItemDrawable(itemStack).asIcon();
        this.disableHoverBackground();
    }

    public SlotLikeButtonWidget(Supplier<ItemStack> itemSupplier) {
        this.itemSupplier = itemSupplier;
        this.itemDrawable = new DynamicDrawable(() -> new ItemDrawable((ItemStack)itemSupplier.get()).asIcon());
        this.disableHoverBackground();
    }

    public WidgetTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getItemSlotTheme();
    }

    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        super.draw(context, widgetTheme);
        this.itemDrawable.drawAtZero((GuiContext)context, this.getArea(), widgetTheme);
        if (this.isHovering()) {
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect((float)1.0f, (float)1.0f, (float)16.0f, (float)16.0f, (int)this.getHoverColor(widgetTheme));
            GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.disableBlend();
        }
    }

    private int getHoverColor(WidgetTheme widgetTheme) {
        if (widgetTheme instanceof WidgetSlotTheme) {
            WidgetSlotTheme slotTheme = (WidgetSlotTheme)widgetTheme;
            return slotTheme.getSlotHoverColor();
        }
        return ITheme.getDefault().getItemSlotTheme().getSlotHoverColor();
    }

    @Nullable
    public ItemStack getStackForNEI() {
        return this.itemSupplier.get();
    }
}

