/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.powergoggles;

import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.common.powergoggles.PowerGogglesClient;
import gregtech.common.powergoggles.PowerGogglesMeasurement;
import gregtech.common.powergoggles.handlers.PowerGogglesEventHandler;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.WorldEvent;

public class PowerGogglesWorldSavedData
extends WorldSavedData {
    public static PowerGogglesWorldSavedData INSTANCE;
    private static final String DATA_NAME = "GregTech_PowerGogglesClientData";
    private int nbtTagCompoundType = 10;

    private static void loadInstance(World world) {
        MapStorage storage = world.field_72988_C;
        INSTANCE = (PowerGogglesWorldSavedData)storage.func_75742_a(PowerGogglesWorldSavedData.class, DATA_NAME);
        if (INSTANCE == null) {
            INSTANCE = new PowerGogglesWorldSavedData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)INSTANCE);
        }
        INSTANCE.func_76185_a();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            PowerGogglesWorldSavedData.loadInstance(event.world);
        }
    }

    public PowerGogglesWorldSavedData() {
        super(DATA_NAME);
    }

    public PowerGogglesWorldSavedData(String name) {
        super(name);
    }

    public void func_76187_b(NBTTagCompound nbtTagCompound) {
        NBTTagList clientList = new NBTTagList();
        for (Map.Entry<UUID, PowerGogglesClient> client : PowerGogglesEventHandler.getInstance().getClients().entrySet()) {
            clientList.field_74747_a.add(client.getValue().getNBT(client.getKey()));
        }
        nbtTagCompound.func_74782_a("clientList", (NBTBase)clientList);
    }

    public void func_76184_a(NBTTagCompound nbtTagCompound) {
        NBTTagList clientList = nbtTagCompound.func_150295_c("clientList", this.nbtTagCompoundType);
        this.processClientList(clientList);
    }

    private void processClientList(NBTTagList clientList) {
        Map<UUID, PowerGogglesClient> clientMap = PowerGogglesEventHandler.getInstance().getClients();
        for (Object tag : clientList.field_74747_a) {
            NBTTagCompound tagCompound = (NBTTagCompound)tag;
            UUID uuid = UUID.fromString(tagCompound.func_74779_i("uuid"));
            PowerGogglesClient client = this.processClient(tagCompound);
            clientMap.put(uuid, client);
        }
    }

    private PowerGogglesClient processClient(NBTTagCompound tagCompound) {
        DimensionalCoord coords = !tagCompound.func_74764_b("x") ? null : new DimensionalCoord(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("y"), tagCompound.func_74762_e("z"), tagCompound.func_74762_e("dim"));
        PowerGogglesClient client = new PowerGogglesClient(coords);
        client.setMeasurements(this.getMeasurementsFromTag(tagCompound));
        return client;
    }

    private LinkedList<PowerGogglesMeasurement> getMeasurementsFromTag(NBTTagCompound tagCompound) {
        LinkedList<PowerGogglesMeasurement> measurements = new LinkedList<PowerGogglesMeasurement>();
        NBTTagList measurementsTagList = tagCompound.func_150295_c("measurements", this.nbtTagCompoundType);
        for (Object tag : measurementsTagList.field_74747_a) {
            NBTTagCompound measurementTag = (NBTTagCompound)tag;
            BigInteger measurement = new BigInteger(measurementTag.func_74770_j("measurement"));
            if (measurementTag.func_74767_n("isWireless")) {
                measurements.add(new PowerGogglesMeasurement(true, measurement));
                continue;
            }
            long capacity = measurementTag.func_74763_f("capacity");
            measurements.add(new PowerGogglesMeasurement(false, measurement, capacity));
        }
        return measurements;
    }
}

