/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.powergoggles.gui;

import com.cleanroommc.modularui.api.IPanelHandler;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.value.IDoubleValue;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.drawable.DynamicDrawable;
import com.cleanroommc.modularui.drawable.GuiTextures;
import com.cleanroommc.modularui.drawable.Rectangle;
import com.cleanroommc.modularui.overlay.OverlayHandler;
import com.cleanroommc.modularui.overlay.OverlayManager;
import com.cleanroommc.modularui.screen.CustomModularScreen;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.value.DoubleValue;
import com.cleanroommc.modularui.widget.SingleChildWidget;
import com.cleanroommc.modularui.widgets.ButtonWidget;
import com.cleanroommc.modularui.widgets.ColorPickerDialog;
import com.cleanroommc.modularui.widgets.PagedWidget;
import com.cleanroommc.modularui.widgets.SliderWidget;
import com.cleanroommc.modularui.widgets.TextWidget;
import com.cleanroommc.modularui.widgets.layout.Column;
import com.cleanroommc.modularui.widgets.layout.Flow;
import com.cleanroommc.modularui.widgets.layout.Row;
import gregtech.common.powergoggles.gui.PowerGogglesGuiHudConfig;
import gregtech.common.powergoggles.handlers.PowerGogglesConfigHandler;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class PowerGogglesGuiOverlay {
    private static String[] settings = new String[]{"GT5U.power_goggles_config.settings_general", "GT5U.power_goggles_config.settings_color"};
    private static int settingsPage = 0;
    private static IDrawable background = new Rectangle().setColor(Color.argb((int)0, (int)0, (int)0, (int)100));

    public static void init() {
        OverlayManager.register((OverlayHandler)new OverlayHandler(screen -> screen instanceof PowerGogglesGuiHudConfig, PowerGogglesGuiOverlay::buildScreen));
        OverlayManager.register((OverlayHandler)new OverlayHandler(screen -> screen instanceof GuiMainMenu, screen -> new ModularScreen((ModularPanel)((ModularPanel)ModularPanel.defaultPanel((String)"overlay").size(0)).pos(-100, 0))));
    }

    private static CustomModularScreen buildScreen(GuiScreen screen) {
        PowerGogglesGuiHudConfig gui = (PowerGogglesGuiHudConfig)screen;
        final PagedWidget.Controller controller = new PagedWidget.Controller();
        final int height = 217;
        final ModularPanel overlayPanel = (ModularPanel)((ModularPanel)((ModularPanel)((ModularPanel)ModularPanel.defaultPanel((String)"power_goggles_overlay", (int)gui.displayWidth, (int)gui.displayHeight).size(232, height)).background(new IDrawable[]{IDrawable.EMPTY})).leftRel(0.5f)).top(10);
        final PagedWidget pagedWidget = new PagedWidget(){

            public void afterInit() {
                this.setPage(settingsPage);
            }
        }.controller(controller).addPage(PowerGogglesGuiOverlay.makeGeneralSettingsPage(gui)).addPage(PowerGogglesGuiOverlay.makeColorSchemePage(overlayPanel));
        return new CustomModularScreen(){

            @NotNull
            public ModularPanel buildUI(ModularGuiContext context) {
                return (ModularPanel)overlayPanel.child((IWidget)((Flow)((Flow)new Column().sizeRel(1.0f)).child((IWidget)((SingleChildWidget)((SingleChildWidget)((SingleChildWidget)((SingleChildWidget)new SingleChildWidget().size(230, 22)).background(new IDrawable[]{background})).height(22)).paddingBottom(4)).child(PowerGogglesGuiOverlay.makePagedWidgetButton(controller)))).child((IWidget)((SingleChildWidget)new SingleChildWidget().size(230, height - 22)).child((IWidget)pagedWidget.sizeRel(1.0f))));
            }
        };
    }

    private static IWidget makePagedWidgetButton(PagedWidget.Controller controller) {
        return (IWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{new DynamicDrawable(() -> IKey.lang((String)settings[settingsPage]))})).onMousePressed(mouseButton -> {
            ++settingsPage;
            controller.setPage(settingsPage %= settings.length);
            return true;
        }).sizeRel(1.0f)).align(Alignment.Center);
    }

    private static IWidget makeGeneralSettingsPage(PowerGogglesGuiHudConfig gui) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().coverChildren()).background(new IDrawable[]{background})).child(PowerGogglesGuiOverlay.makeNotationButton(gui))).child(PowerGogglesGuiOverlay.makeReadingButton(gui))).child(PowerGogglesGuiOverlay.makeChatHidesHudButton())).child(PowerGogglesGuiOverlay.makeSliderFlow(() -> PowerGogglesConfigHandler.mainTextScaling, val -> {
            PowerGogglesConfigHandler.mainTextScaling = val;
        }, "Storage Text Scale", "GT5U.power_goggles_config.main_text_scale"))).child(PowerGogglesGuiOverlay.makeSliderFlow(() -> PowerGogglesConfigHandler.subTextScaling, val -> {
            PowerGogglesConfigHandler.subTextScaling = val;
        }, "Timed Reading Text Scale", "GT5U.power_goggles_config.sub_text_scale"))).child(PowerGogglesGuiOverlay.makeSliderFlow(() -> PowerGogglesConfigHandler.hudScale, val -> {
            PowerGogglesConfigHandler.hudScale = val;
        }, "HUD Scale", "GT5U.power_goggles_config.hud_scale"));
    }

    private static IWidget makeNotationButton(PowerGogglesGuiHudConfig gui) {
        ButtonWidget notationButton = (ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_notation", (Object[])new Object[]{StatCollector.func_74838_a((String)gui.formatTypes[PowerGogglesConfigHandler.formatIndex])})});
        notationButton.onMousePressed(mouseButton -> {
            PowerGogglesConfigHandler.formatIndex = (PowerGogglesConfigHandler.formatIndex + 1) % gui.formatTypes.length;
            PowerGogglesConfigHandler.config.getCategory("general").get("Format Index").set(PowerGogglesConfigHandler.formatIndex);
            PowerGogglesConfigHandler.config.save();
            notationButton.overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_notation", (Object[])new Object[]{StatCollector.func_74838_a((String)gui.formatTypes[PowerGogglesConfigHandler.formatIndex])})});
            return true;
        });
        return (IWidget)((ButtonWidget)notationButton.size(230, 18)).marginBottom(4);
    }

    private static IWidget makeReadingButton(PowerGogglesGuiHudConfig gui) {
        ButtonWidget readingButton = (ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_reading", (Object[])new Object[]{StatCollector.func_74838_a((String)gui.readingTypes[PowerGogglesConfigHandler.readingIndex])})});
        readingButton.onMousePressed(mouseButton -> {
            PowerGogglesConfigHandler.readingIndex = (PowerGogglesConfigHandler.readingIndex + 1) % gui.readingTypes.length;
            PowerGogglesConfigHandler.config.getCategory("general").get("Reading Index").set(PowerGogglesConfigHandler.readingIndex);
            PowerGogglesConfigHandler.config.save();
            readingButton.overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_reading", (Object[])new Object[]{StatCollector.func_74838_a((String)gui.readingTypes[PowerGogglesConfigHandler.readingIndex])})});
            return true;
        });
        return (IWidget)((ButtonWidget)readingButton.size(230, 18)).marginBottom(4);
    }

    private static IWidget makeChatHidesHudButton() {
        ButtonWidget chatHidesHudButton = (ButtonWidget)new ButtonWidget().overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_hud_with_chat", (Object[])new Object[]{PowerGogglesConfigHandler.hideWhenChatOpen ? IKey.lang((String)"gui.yes") : IKey.lang((String)"gui.no")})});
        chatHidesHudButton.onMousePressed(mouseButton -> {
            PowerGogglesConfigHandler.hideWhenChatOpen = !PowerGogglesConfigHandler.hideWhenChatOpen;
            PowerGogglesConfigHandler.config.getCategory("general").get("Hide HUD").set(PowerGogglesConfigHandler.hideWhenChatOpen);
            PowerGogglesConfigHandler.config.save();
            chatHidesHudButton.overlay(new IDrawable[]{IKey.lang((String)"GT5U.power_goggles_config.toggle_hud_with_chat", (Object[])new Object[]{PowerGogglesConfigHandler.hideWhenChatOpen ? IKey.lang((String)"gui.yes") : IKey.lang((String)"gui.no")})});
            return true;
        });
        return (IWidget)((ButtonWidget)chatHidesHudButton.size(230, 18)).marginBottom(4);
    }

    private static IWidget makeSliderFlow(Supplier<Double> valSupplier, Consumer<Double> setter, String key, String textKey) {
        return (IWidget)((Flow)((Flow)((Flow)new Row().size(230, 18)).marginBottom(4)).child((IWidget)((TextWidget)((TextWidget)((TextWidget)IKey.lang((String)textKey).color(Integer.valueOf(Color.WHITE.main)).asWidget().paddingLeft(3)).width(106)).marginRight(14)).alignment(Alignment.CenterRight))).child((IWidget)((SliderWidget)((SliderWidget)new SliderWidget().size(110, 18)).background(new IDrawable[]{GuiTextures.MC_BUTTON})).bounds(0.0, 2.0).stopper(0.1).value((IDoubleValue)new DoubleValue.Dynamic(valSupplier::get, val -> {
            setter.accept(val);
            PowerGogglesConfigHandler.config.getCategory("general").get(key).set(val);
            PowerGogglesConfigHandler.config.save();
        })));
    }

    private static IWidget makeColorSchemePage(ModularPanel overlayPanel) {
        return (IWidget)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)((Flow)new Column().coverChildren()).background(new IDrawable[]{background})).align(Alignment.TopCenter)).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.textBadColor, val -> {
            PowerGogglesConfigHandler.textBadColor = val;
        }, "Bad Text", "GT5U.power_goggles_config.text_bad", "GT5U.power_goggles_config.text_bad_tooltip"))).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.textOkColor, val -> {
            PowerGogglesConfigHandler.textOkColor = val;
        }, "Ok Text", "GT5U.power_goggles_config.text_ok", "GT5U.power_goggles_config.text_ok_tooltip"))).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.textGoodColor, val -> {
            PowerGogglesConfigHandler.textGoodColor = val;
        }, "Good Text", "GT5U.power_goggles_config.text_good", "GT5U.power_goggles_config.text_good_tooltip"))).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.gradientBadColor, val -> {
            PowerGogglesConfigHandler.gradientBadColor = val;
        }, "Bad Gradient", "GT5U.power_goggles_config.gradient_bad", "GT5U.power_goggles_config.gradient_bad_tooltip"))).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.gradientOkColor, val -> {
            PowerGogglesConfigHandler.gradientOkColor = val;
        }, "Ok Gradient", "GT5U.power_goggles_config.gradient_ok", "GT5U.power_goggles_config.gradient_ok_tooltip"))).child(PowerGogglesGuiOverlay.makeColorConfigButton(overlayPanel, () -> PowerGogglesConfigHandler.gradientGoodColor, val -> {
            PowerGogglesConfigHandler.gradientGoodColor = val;
        }, "Good Gradient", "GT5U.power_goggles_config.gradient_good", "GT5U.power_goggles_config.gradient_good_tooltip"))).child((IWidget)((Flow)((Flow)((Flow)new Row().size(228, 18)).marginBottom(4)).child((IWidget)new DynamicDrawable(() -> new Rectangle().setHorizontalGradient(PowerGogglesConfigHandler.gradientBadColor, PowerGogglesConfigHandler.gradientOkColor)).asWidget().size(114, 18))).child((IWidget)new DynamicDrawable(() -> new Rectangle().setHorizontalGradient(PowerGogglesConfigHandler.gradientOkColor, PowerGogglesConfigHandler.gradientGoodColor)).asWidget().size(114, 18)));
    }

    private static IWidget makeColorConfigButton(ModularPanel overlayPanel, Supplier<Integer> colorSupplier, Consumer<Integer> setter, String key, String buttonKey, String tooltipKey) {
        IPanelHandler colorPicker = IPanelHandler.simple((ModularPanel)overlayPanel, (bla, blab) -> (ModularPanel)new ColorPickerDialog(key, val -> {
            setter.accept((Integer)val);
            PowerGogglesConfigHandler.config.getCategory("general").get(key).set(val.intValue());
            PowerGogglesConfigHandler.config.save();
        }, ((Integer)colorSupplier.get()).intValue(), true).size(200, 100), (boolean)true);
        return (IWidget)((Flow)((Flow)((Flow)new Row().size(230, 18)).marginBottom(4)).child((IWidget)((TextWidget)((TextWidget)IKey.lang((String)buttonKey).color(Integer.valueOf(Color.WHITE.main)).asWidget().size(106, 18)).marginRight(14)).alignment(Alignment.CenterRight))).child((IWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)((ButtonWidget)new ButtonWidget().size(18, 18)).overlay(new IDrawable[]{new DynamicDrawable(() -> new Rectangle().setColor(((Integer)colorSupplier.get()).intValue()))})).hoverOverlay(new IDrawable[]{new DynamicDrawable(() -> new Rectangle().setColor(((Integer)colorSupplier.get()).intValue()))})).tooltipBuilder(t -> t.addLine((IDrawable)IKey.lang((String)tooltipKey)))).onMousePressed(d -> {
            colorPicker.openPanel();
            return true;
        }));
    }
}

