/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem.item.algae;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTLog;
import gtPlusPlus.plugin.agrichem.AlgaeDefinition;
import gtPlusPlus.plugin.agrichem.IAlgalItem;
import gtPlusPlus.plugin.agrichem.logic.AlgaeGeneticData;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemAlgaeBase
extends Item
implements IAlgalItem {
    protected IIcon base;

    public ItemAlgaeBase() {
        this.func_77627_a(true);
        this.func_77656_e(127);
        this.setNoRepair();
        this.func_77625_d(32);
        this.func_77655_b("BasicAlgaeItem");
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean func_77629_n_() {
        return super.func_77629_n_();
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!p_77663_1_.func_77942_o() || p_77663_1_.func_77978_p().func_82582_d()) {
            p_77663_1_ = ItemAlgaeBase.initNBT(p_77663_1_);
        }
        super.func_77663_a(p_77663_1_, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
    }

    public String func_77653_i(ItemStack aStack) {
        return EnumChatFormatting.UNDERLINE + super.func_77653_i(aStack);
    }

    private String boolLoc(Boolean bool) {
        return StatCollector.func_74838_a((String)(bool != false ? "GT5U.generic.true" : "GT5U.generic.false"));
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
        int aDam = aStack.func_77960_j();
        try {
            aList.add(StatCollector.func_74838_a((String)("GTPP.algae." + AlgaeDefinition.getByIndex((int)aDam).mSimpleName.replace(" ", "_").toLowerCase() + ".name")));
            if (!aStack.func_77942_o() || aStack.func_77978_p().func_82582_d()) {
                aStack = ItemAlgaeBase.initNBT(aStack);
            } else {
                NBTTagCompound aNBT = aStack.func_77978_p();
                boolean mRequiresLight = aNBT.func_74767_n("mRequiresLight");
                boolean mSaltWater = aNBT.func_74767_n("mSaltWater");
                boolean mFreshWater = aNBT.func_74767_n("mFreshWater");
                byte mTempTolerance = aNBT.func_74771_c("mTempTolerance");
                float mFertility = aNBT.func_74760_g("mFertility");
                float mProductionSpeed = aNBT.func_74760_g("mProductionSpeed");
                byte mLifespan = aNBT.func_74771_c("mLifespan");
                int mGeneration = aNBT.func_74762_e("mGeneration");
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.requires_light", (Object[])new Object[]{this.boolLoc(mRequiresLight)}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.salt_water", (Object[])new Object[]{this.boolLoc(mSaltWater)}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.fresh_water", (Object[])new Object[]{this.boolLoc(mFreshWater)}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.temp_tolerance", (Object[])new Object[]{mTempTolerance}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.growth", (Object[])new Object[]{Float.valueOf(mFertility)}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.production", (Object[])new Object[]{Float.valueOf(mProductionSpeed)}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.lifespan", (Object[])new Object[]{mLifespan}));
                aList.add(StatCollector.func_74837_a((String)"GTPP.tooltip.generation", (Object[])new Object[]{mGeneration}));
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
        super.func_77624_a(aStack, p_77624_2_, aList, p_77624_4_);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.uncommon;
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        for (int i = 0; i < AlgaeDefinition.values().length; ++i) {
            aList.add(new ItemStack(aItem, 1, i));
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_82790_a(ItemStack aStack, int aMeta) {
        return AlgaeDefinition.getByIndex((int)aStack.func_77960_j()).mColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        return this.base;
    }

    public void func_94581_a(IIconRegister i) {
        this.base = i.func_94245_a(Mods.GTPlusPlus.ID + ":bioscience/BasicAlgae");
    }

    public static ItemStack initNBT(ItemStack aFreshAlgae) {
        NBTTagCompound aNewTag = new NBTTagCompound();
        if (aFreshAlgae.func_77973_b() instanceof ItemAlgaeBase) {
            ItemAlgaeBase aItem = (ItemAlgaeBase)aFreshAlgae.func_77973_b();
            if (!aFreshAlgae.func_77942_o()) {
                AlgaeGeneticData y = aItem.getSpeciesData(aFreshAlgae);
                aNewTag = y.writeToNBT();
                aFreshAlgae.func_77982_d(aNewTag);
            }
        }
        return aFreshAlgae;
    }

    @Override
    public AlgaeDefinition getAlgaeType(ItemStack aStack) {
        return AlgaeDefinition.getByIndex(aStack != null ? aStack.func_77960_j() : 3);
    }

    @Override
    public AlgaeGeneticData getSpeciesData(ItemStack aStack) {
        NBTTagCompound aTag;
        if (!aStack.func_77942_o() || aStack.func_77978_p().func_82582_d()) {
            AlgaeGeneticData aGenes;
            if (aStack.func_77960_j() < 3 || aStack.func_77960_j() > 5) {
                aGenes = new AlgaeGeneticData();
            } else {
                float aFert;
                int aDam = aStack.func_77960_j();
                byte aTemp = (byte)(aDam == 3 ? 0 : (aDam == 4 ? 2 : 1));
                byte aLifespan = (byte)(aDam == 3 ? 1.0f : (aDam == 4 ? 3.0f : 2.0f));
                float f = aDam == 3 ? 2.0f : (aFert = aDam == 4 ? 1.0f : 1.75f);
                float aSpeed = aDam == 3 ? 1.0f : (aDam == 4 ? 1.5f : 2.0f);
                aGenes = new AlgaeGeneticData(true, true, AlgaeDefinition.getByIndex((int)aDam).mSaltWater, AlgaeDefinition.getByIndex((int)aDam).mFreshWater, aTemp, aFert, aSpeed, aLifespan, 0);
            }
            aTag = aGenes.writeToNBT();
        } else {
            aTag = aStack.func_77978_p();
        }
        return new AlgaeGeneticData(aTag);
    }
}

