/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchInputBus;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStreamUtil;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchChiselBus;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import team.chisel.carving.Carving;

public class MTEIndustrialChisel
extends GTPPMultiBlockBase<MTEIndustrialChisel>
implements ISurvivalConstructable {
    private int mCasing;
    private ItemStack target;
    private static IStructureDefinition<MTEIndustrialChisel> STRUCTURE_DEFINITION = null;
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private GTRecipe mCachedRecipe;
    private static ResourceLocation sChiselSound = null;

    public MTEIndustrialChisel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialChisel(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialChisel(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chisel";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addBulkMachineInfo(16, 3.0f, 0.75f).addInfo("Factory Grade Auto Chisel").addInfo("Target block goes in Controller slot for common Input Buses").addInfo("You can also set a target block in each Chisel Input Bus and use them as an Input Bus").addInfo("If no target is provided for common buses, the result of the first chisel is used").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfoMin("Sturdy Printer Casing", 6, false).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addMufflerHatch("Any casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IStructureDefinition<MTEIndustrialChisel> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEIndustrialChisel.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler).casingIndex(90).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)5)))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 1, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 6 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialChiselActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialChiselActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCAIndustrialChisel;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCAIndustrialChiselGlow;
    }

    @Override
    protected int getCasingTextureId() {
        return 90;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && this.mCachedRecipe != null && GTUtility.areStacksEqual(aStack, this.mInputCache) && GTUtility.areStacksEqual(aSpecialSlot, this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
            this.mCachedRecipe = null;
        }
        return false;
    }

    private void cacheItem(ItemStack aInputItem, ItemStack aOutputItem, GTRecipe aRecipe) {
        this.mInputCache = aInputItem.func_77946_l();
        this.mOutputCache = aOutputItem.func_77946_l();
        this.mCachedRecipe = aRecipe;
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = MTEIndustrialChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = MTEIndustrialChisel.getItemsForChiseling(from);
        return !results.isEmpty();
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = aTarget != null && MTEIndustrialChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !MTEIndustrialChisel.canBeMadeFrom(aInput, aTarget) ? null : MTEIndustrialChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    private GTRecipe generateChiselRecipe(ItemStack aInput) {
        boolean tIsCached = this.hasValidCache(aInput, this.target, true);
        if (tIsCached || aInput != null && MTEIndustrialChisel.hasChiselResults(aInput)) {
            ItemStack tOutput;
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : MTEIndustrialChisel.getChiselOutput(aInput, this.target);
            if (tOutput != null) {
                if (this.mCachedRecipe != null && GTUtility.areStacksEqual(aInput, this.mInputCache) && GTUtility.areStacksEqual(tOutput, this.mOutputCache)) {
                    return this.mCachedRecipe;
                }
                GTRecipe aRecipe = new GTRecipe(false, new ItemStack[]{GTUtility.copyAmount(1, aInput)}, new ItemStack[]{GTUtility.copyAmount(1, tOutput)}, null, new int[]{10000}, GTValues.emptyFluidStackArray, GTValues.emptyFluidStackArray, 20, 16, 0);
                this.cacheItem(aInput, tOutput, aRecipe);
                return aRecipe;
            }
        }
        return null;
    }

    private GTRecipe getRecipe() {
        for (MTEHatchInputBus bus : this.mInputBusses) {
            GTRecipe tRecipe;
            ItemStack itemsInSlot;
            int i;
            if (bus instanceof MTEHatchChiselBus) {
                if (bus.mInventory[bus.func_70302_i_() - 1] == null) continue;
                this.target = bus.mInventory[bus.func_70302_i_() - 1];
                for (i = bus.func_70302_i_() - 2; i >= 0; --i) {
                    itemsInSlot = bus.mInventory[i];
                    if (itemsInSlot == null || (tRecipe = this.generateChiselRecipe(itemsInSlot)) == null) continue;
                    return tRecipe;
                }
                continue;
            }
            this.target = this.getControllerSlot();
            for (i = bus.func_70302_i_() - 1; i >= 0; --i) {
                itemsInSlot = bus.mInventory[i];
                if (itemsInSlot == null || (tRecipe = this.generateChiselRecipe(itemsInSlot)) == null) continue;
                return tRecipe;
            }
        }
        return null;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                return GTStreamUtil.ofNullable(MTEIndustrialChisel.this.getRecipe());
            }
        }.noRecipeCaching().setSpeedBonus(0.3333333432674408).setEuModifier(0.75).setMaxParallelSupplier(this::getTrueParallel);
    }

    @Override
    protected void sendStartMultiBlockSoundLoop() {
        this.sendLoopStart((byte)1);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16 * GTUtility.getTier(this.getMaxInputVoltage());
    }

    private static ResourceLocation getChiselSound() {
        if (sChiselSound == null) {
            sChiselSound = new ResourceLocation(Carving.chisel.getVariationSound(Blocks.field_150348_b, 0));
        }
        return sChiselSound;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        switch (aIndex) {
            case 1: {
                GTUtility.doSoundAtClient(MTEIndustrialChisel.getChiselSound(), this.getTimeBetweenProcessSounds(), 1.0f, 1.0f, aX, aY, aZ);
                break;
            }
            case 8: {
                GTUtility.doSoundAtClient(SoundResource.IC2_MACHINES_INTERRUPT_ONE, 100, 1.0f, aX, aY, aZ);
            }
        }
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiIndustrialChisel;
    }
}

