/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.recipe.maps;

import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.recipe.BasicUIPropertiesBuilder;
import gregtech.api.recipe.NEIRecipePropertiesBuilder;
import gregtech.api.recipe.RecipeMapFrontend;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.common.gui.modularui.UIHelper;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import gtnhintergalactic.recipe.IGRecipeMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpaceAssemblerFrontend
extends RecipeMapFrontend {
    public SpaceAssemblerFrontend(BasicUIPropertiesBuilder uiPropertiesBuilder, NEIRecipePropertiesBuilder neiPropertiesBuilder) {
        super(uiPropertiesBuilder, neiPropertiesBuilder.neiSpecialInfoFormatter(new SpaceAssemblerSpecialValueFormatter()));
    }

    @Override
    public List<Pos2d> getItemInputPositions(int itemInputCount) {
        return UIHelper.getGridPositions(itemInputCount, 16, 8, 4);
    }

    @Override
    public List<Pos2d> getItemOutputPositions(int itemOutputCount) {
        return Collections.singletonList(new Pos2d(142, 8));
    }

    @Override
    public List<Pos2d> getFluidInputPositions(int fluidInputCount) {
        return UIHelper.getGridPositions(fluidInputCount, 106, 8, 1);
    }

    @Override
    public void addProgressBar(ModularWindow.Builder builder, Supplier<Float> progressSupplier, Pos2d windowOffset) {
        int bar1Width = 17;
        int bar2Width = 18;
        List<Supplier<Float>> splitProgress = SpaceAssemblerFrontend.splitProgress(progressSupplier, bar1Width, bar2Width);
        builder.widget(new ProgressBar().setTexture(GTUITextures.PROGRESSBAR_ASSEMBLY_LINE_1, 17).setDirection(ProgressBar.Direction.RIGHT).setProgress(splitProgress.get(0)).setSynced(false, false).setPos(new Pos2d(88, 8).add(windowOffset)).setSize(bar1Width, 72));
        builder.widget(new ProgressBar().setTexture(GTUITextures.PROGRESSBAR_ASSEMBLY_LINE_2, 18).setDirection(ProgressBar.Direction.RIGHT).setProgress(splitProgress.get(1)).setSynced(false, false).setPos(new Pos2d(124, 8).add(windowOffset)).setSize(bar2Width, 72));
    }

    private static class SpaceAssemblerSpecialValueFormatter
    implements INEISpecialInfoFormatter {
        private SpaceAssemblerSpecialValueFormatter() {
        }

        @Override
        public List<String> format(RecipeDisplayInfo recipeInfo) {
            ArrayList<String> specialInfo = new ArrayList<String>();
            int recipeTier = recipeInfo.recipe.getMetadataOrDefault(IGRecipeMaps.MODULE_TIER, 1);
            specialInfo.add(GTUtility.translate("ig.nei.module", recipeTier));
            String neededProject = recipeInfo.recipe.getMetadata(IGRecipeMaps.SPACE_PROJECT);
            String neededProjectLocation = recipeInfo.recipe.getMetadata(IGRecipeMaps.SPACE_LOCATION);
            if (neededProject != null && !neededProject.isEmpty()) {
                specialInfo.add(String.format(GTUtility.translate("ig.nei.spaceassembler.project", new Object[0]), SpaceProjectManager.getProject(neededProject).getLocalizedName()));
                specialInfo.add(String.format(GTUtility.translate("ig.nei.spaceassembler.projectAt", new Object[0]), neededProjectLocation == null || neededProjectLocation.isEmpty() ? GTUtility.translate("ig.nei.spaceassembler.projectAnyLocation", new Object[0]) : GTUtility.translate(SpaceProjectManager.getLocation(neededProjectLocation).getUnlocalizedName(), new Object[0])));
            }
            return specialInfo;
        }
    }
}

