/*
 * Decompiled with CFR 0.152.
 */
package tectech.recipe;

import com.google.common.math.LongMath;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtneioreplugin.plugin.block.BlockDimensionDisplay;
import gtneioreplugin.plugin.block.ModBlocks;
import gtneioreplugin.util.DimensionHelper;
import gtneioreplugin.util.GT5OreLayerHelper;
import gtneioreplugin.util.GT5OreSmallHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import tectech.recipe.EyeOfHarmonyRecipe;
import tectech.recipe.TecTechRecipeMaps;
import tectech.util.FluidStackLong;
import tectech.util.ItemStackLong;

public class EyeOfHarmonyRecipeStorage {
    public static final long BILLION = LongMath.pow((long)10L, (int)9);
    private static final double CHANCE_DECREASE_PER_DIMENSION = 0.05;
    HashMap<Block, String> blocksMapInverted = new HashMap<Block, String>(){
        private static final long serialVersionUID = -1634011860327553337L;
        {
            ModBlocks.blocks.forEach((dimString, dimBlock) -> this.put(dimBlock, dimString));
        }
    };
    private final HashMap<String, EyeOfHarmonyRecipe> recipeHashMap = new HashMap<String, EyeOfHarmonyRecipe>(){
        private static final long serialVersionUID = -3501819612517400500L;
        {
            for (String dimAbbreviation : DimensionHelper.DimNameDisplayed) {
                BlockDimensionDisplay blockDimensionDisplay = (BlockDimensionDisplay)ModBlocks.blocks.get(dimAbbreviation);
                if (dimAbbreviation.equals("DD")) {
                    EyeOfHarmonyRecipeStorage.this.specialDeepDarkRecipe(this, blockDimensionDisplay);
                    continue;
                }
                GT5OreLayerHelper.NormalOreDimensionWrapper normalOre = GT5OreLayerHelper.dimToOreWrapper.getOrDefault(dimAbbreviation, null);
                GT5OreSmallHelper.SmallOreDimensionWrapper smallOre = GT5OreSmallHelper.dimToSmallOreWrapper.getOrDefault(dimAbbreviation, null);
                if (normalOre == null && smallOre == null) continue;
                long spacetimeTier = blockDimensionDisplay.getDimensionRocketTier();
                if (spacetimeTier == 0L) {
                    ++spacetimeTier;
                }
                this.put(dimAbbreviation, new EyeOfHarmonyRecipe(normalOre, smallOre, blockDimensionDisplay, 0.6 + (double)blockDimensionDisplay.getDimensionRocketTier() / 10.0, BILLION * (blockDimensionDisplay.getDimensionRocketTier() + 1L), BILLION * (blockDimensionDisplay.getDimensionRocketTier() + 1L), EyeOfHarmonyRecipeStorage.timeCalculator(blockDimensionDisplay.getDimensionRocketTier()), spacetimeTier - 1L, 1.0 - 0.05 * (double)blockDimensionDisplay.getDimensionRocketTier()));
            }
        }
    };

    public EyeOfHarmonyRecipe recipeLookUp(ItemStack aStack) {
        String dimAbbreviation = this.blocksMapInverted.get(Block.func_149634_a((Item)aStack.func_77973_b()));
        return this.recipeHashMap.get(dimAbbreviation);
    }

    public EyeOfHarmonyRecipeStorage() {
        for (EyeOfHarmonyRecipe recipe : this.recipeHashMap.values()) {
            ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
            for (ItemStackLong itemStackLong : recipe.getOutputItems()) {
                outputItems.add(itemStackLong.itemStack);
            }
            ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
            for (FluidStackLong fluidStackLong : recipe.getOutputFluids()) {
                outputFluids.add(fluidStackLong.fluidStack);
            }
            ItemStack itemStack = recipe.getRecipeTriggerItem().func_77946_l();
            itemStack.field_77994_a = 0;
            GTValues.RA.stdBuilder().itemInputs(itemStack).itemOutputs(outputItems.toArray(new ItemStack[0])).fluidInputs(Materials.Hydrogen.getGas(0L), Materials.Helium.getGas(0L), MaterialsUEVplus.RawStarMatter.getFluid(0L)).fluidOutputs(outputFluids.toArray(new FluidStack[0])).duration(recipe.getRecipeTimeInTicks()).eut(0).special(recipe).addTo(TecTechRecipeMaps.eyeOfHarmonyRecipes);
        }
    }

    private void specialDeepDarkRecipe(HashMap<String, EyeOfHarmonyRecipe> hashMap, BlockDimensionDisplay planetItem) {
        HashSet<Materials> validMaterialSet = new HashSet<Materials>();
        for (Materials material : Materials.values()) {
            ItemStack smallOre;
            ItemStack normalOre = GTOreDictUnificator.get(OrePrefixes.ore, material, 1L);
            if (normalOre != null) {
                validMaterialSet.add(material);
            }
            if ((smallOre = GTOreDictUnificator.get(OrePrefixes.oreSmall, material, 1L)) == null) continue;
            validMaterialSet.add(material);
        }
        ArrayList<Materials> validMaterialList = new ArrayList<Materials>(validMaterialSet);
        long rocketTier = 9L;
        hashMap.put("DD", new EyeOfHarmonyRecipe(this.processDD(validMaterialList), planetItem, 0.6 + (double)rocketTier / 10.0, BILLION * (rocketTier + 1L), BILLION * (rocketTier + 1L), EyeOfHarmonyRecipeStorage.timeCalculator(rocketTier), rocketTier, 1.0 - (double)rocketTier * 0.05));
    }

    private static long timeCalculator(long rocketTier) {
        return (long)(18000.0 * GTUtility.powInt(1.4, rocketTier));
    }

    private ArrayList<Pair<Materials, Long>> processDD(ArrayList<Materials> validMaterialList) {
        EyeOfHarmonyRecipe.HashMapHelper outputMap = new EyeOfHarmonyRecipe.HashMapHelper();
        double mainMultiplier = EyeOfHarmonyRecipeStorage.timeCalculator(10L) * 384L;
        double probability = 1.0 / (double)validMaterialList.size();
        validMaterialList.forEach(material -> EyeOfHarmonyRecipe.processHelper(outputMap, material, mainMultiplier, probability));
        ArrayList<Pair<Materials, Long>> outputList = new ArrayList<Pair<Materials, Long>>();
        outputMap.forEach((material, quantity) -> outputList.add(Pair.of((Object)material, (Object)((long)Math.floor(quantity)))));
        return outputList;
    }
}

