/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import pers.gwyog.gtneioreplugin.GTNEIOrePlugin;
import pers.gwyog.gtneioreplugin.plugin.PluginBase;
import pers.gwyog.gtneioreplugin.util.DimensionHelper;
import pers.gwyog.gtneioreplugin.util.GuiRecipeHelper;

public abstract class PluginGT5Base
extends PluginBase {
    protected static String getLocalizedNameForItem(Materials aMaterial, String aFormat) {
        return String.format(aFormat.replace("%s", "%temp").replace("%material", "%s"), aMaterial.mLocalizedName).replace("%temp", "%s");
    }

    protected static String getLocalizedNameForItem(String aFormat, int aMaterialID) {
        Materials aMaterial;
        if (aMaterialID >= 0 && aMaterialID < 1000 && (aMaterial = GregTech_API.sGeneratedMaterials[aMaterialID]) != null) {
            return PluginGT5Base.getLocalizedNameForItem(aMaterial, aFormat);
        }
        return aFormat;
    }

    public static String getGTOreLocalizedName(short index) {
        if (!PluginGT5Base.getLocalizedNameForItem(GT_LanguageManager.getTranslation((String)PluginGT5Base.getGTOreUnlocalizedName(index)), index % 1000).contains("Awakened")) {
            return PluginGT5Base.getLocalizedNameForItem(GT_LanguageManager.getTranslation((String)PluginGT5Base.getGTOreUnlocalizedName(index)), index % 1000);
        }
        return "Aw. Draconium Ore";
    }

    protected static String getGTOreUnlocalizedName(short index) {
        return "gt.blockores." + index + ".name";
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        if (GTNEIOrePlugin.toolTips && GuiContainerManager.shouldShowTooltip((GuiContainer)gui) && currenttip.size() == 0) {
            String dimNames = this.getDimensionNames(recipe);
            Rectangle dimRect = this.getDimensionNamesRect(gui, recipe, dimNames);
            Point mousePos = GuiDraw.getMousePosition();
            if (dimRect.contains(mousePos.x, mousePos.y)) {
                List<String> dims = DimensionHelper.convertCondensedStringToToolTip(dimNames);
                currenttip.addAll(dims);
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    protected abstract String getDimensionNames(int var1);

    protected Rectangle getDimensionNamesRect(GuiRecipe gui, int recipe, String dimNames) {
        int dimNamesHeight = dimNames.length() > 70 ? 30 : (dimNames.length() > 36 ? 20 : 10);
        Point offset = gui.getRecipePosition(recipe);
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + offset.x + 2, GuiRecipeHelper.getGuiTop(gui) + offset.y + 110, GuiRecipeHelper.getXSize(gui) - 9, dimNamesHeight);
    }

    protected int getMaximumMaterialIndex(short meta, boolean smallOre) {
        int offset;
        int n = offset = smallOre ? 16000 : 0;
        if (!PluginGT5Base.getGTOreLocalizedName((short)(meta + offset + 5000)).equals(PluginGT5Base.getGTOreUnlocalizedName((short)(meta + offset + 5000)))) {
            return 7;
        }
        if (!PluginGT5Base.getGTOreLocalizedName((short)(meta + offset + 5000)).equals(PluginGT5Base.getGTOreUnlocalizedName((short)(meta + offset + 5000)))) {
            return 6;
        }
        return 5;
    }

    protected void drawDimNames(String dimNames) {
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.worldNames", (Object[])new Object[0]) + ": "), (int)2, (int)100, (int)0x404040, (boolean)false);
        if (dimNames.length() > 36) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + dimNames.substring(0, 36)), (int)2, (int)110, (int)0x404040, (boolean)false);
            if (dimNames.length() > 70) {
                GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + dimNames.substring(36, 70)), (int)2, (int)120, (int)0x404040, (boolean)false);
                GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + dimNames.substring(70, dimNames.length() - 1)), (int)2, (int)130, (int)0x404040, (boolean)false);
            } else {
                GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + dimNames.substring(36, dimNames.length() - 1)), (int)2, (int)120, (int)0x404040, (boolean)false);
            }
        } else {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"", (Object[])new Object[0]) + dimNames.substring(0, dimNames.length() - 1)), (int)2, (int)110, (int)0x404040, (boolean)false);
        }
    }

    protected void drawSeeAllRecipesLabel() {
        GuiDraw.drawStringR((String)(EnumChatFormatting.BOLD + I18n.func_135052_a((String)"gtnop.gui.nei.seeAll", (Object[])new Object[0])), (int)(this.getGuiWidth() - 3), (int)5, (int)0x404040, (boolean)false);
    }
}

