/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Loader;
import gregtech.api.GregTech_API;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import pers.gwyog.gtneioreplugin.plugin.gregtech5.PluginGT5Base;
import pers.gwyog.gtneioreplugin.util.GT5OreLayerHelper;

public class PluginGT5VeinStat
extends PluginGT5Base {
    public static String[] getLocalizedVeinName(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        String unlocalizedName = oreLayer.veinName;
        if (unlocalizedName.startsWith("ore.mix.custom.")) {
            return PluginGT5VeinStat.get_Cnames(oreLayer);
        }
        return new String[]{I18n.func_135052_a((String)("gtnop." + unlocalizedName), (Object[])new Object[0]) + I18n.func_135052_a((String)"gtnop.ore.vein.name", (Object[])new Object[0])};
    }

    public static String coustomVeinRenamer(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        HashSet<String> s = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            s.add(PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[i]).replaceAll(" ", ""));
        }
        return ((Object)s).toString().replace("[".charAt(0), ",".charAt(0)).replace("]".charAt(0), ",".charAt(0)).replaceAll(" Ore", ",").replaceAll("Ore", ",").replaceAll(" Sand", ",").replaceAll("Sand", ",").replaceAll("Stone", ",").replaceAll(" Stone", ",").replaceAll("Earth", ",").replaceAll(" Earth", ",").replaceAll("Infused", ",").replaceAll(" Infused", ",").replaceAll(",", "").trim();
    }

    public static String[] get_Cnames(GT5OreLayerHelper.OreLayerWrapper oreLayer) {
        int i;
        String[] splt = PluginGT5VeinStat.coustomVeinRenamer(oreLayer).split("\\s");
        String[] ret = new String[]{oreLayer.veinName.replace("ore.mix.custom.", "") + " ", " ", " "};
        for (i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        for (i = 0; i < splt.length; ++i) {
            if (ret[0].length() + splt[i].length() <= 20) {
                ret[0] = ret[0] + splt[i] + " ";
            }
            if (ret[0].length() + splt[i].length() > 20 && ret[1].length() + splt[i].length() <= 70 && !ret[0].contains(splt[i])) {
                ret[1] = ret[1] + splt[i] + " ";
            }
            if (ret[0].length() + splt[i].length() <= 20 || ret[1].length() + splt[i].length() <= 70 || ret[2].length() + splt[i].length() > 70 || ret[1].contains(splt[i])) continue;
            ret[2] = ret[2] + splt[i] + " ";
        }
        for (i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        if (ret[2].isEmpty() && !ret[1].isEmpty()) {
            if (ret[1].length() <= 65) {
                ret[1] = ret[1] + " Vein";
            } else {
                ret[2] = ret[2] + "Vein";
            }
        } else if (ret[1].isEmpty() && ret[2].isEmpty() && !ret[0].isEmpty()) {
            if (ret[0].length() <= 15) {
                ret[0] = ret[0] + " Vein";
            } else {
                ret[1] = ret[1] + "Vein";
            }
        } else if (!ret[1].isEmpty() || !ret[2].isEmpty()) {
            ret[2] = ret[2] + "Vein";
        }
        String[] ret2 = new String[2];
        if (ret[2].isEmpty() && !ret[1].isEmpty()) {
            ret2[0] = ret[0];
            ret2[1] = ret[1];
            return ret2;
        }
        String[] ret1 = new String[1];
        if (ret[1].isEmpty() && ret[2].isEmpty() && !ret[0].isEmpty()) {
            ret1[0] = ret[0];
            return ret1;
        }
        return ret;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (String veinName : GT5OreLayerHelper.mapOreLayerWrapper.keySet()) {
                GT5OreLayerHelper.OreLayerWrapper oreLayerWrapper = GT5OreLayerHelper.mapOreLayerWrapper.get(veinName);
                ArrayList<ItemStack> stackListPrimary = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListSecondary = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListBetween = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListSporadic = new ArrayList<ItemStack>();
                for (int i = 0; i < 7; ++i) {
                    stackListPrimary.add(new ItemStack(GregTech_API.sBlockOres1, 1, oreLayerWrapper.Meta[0] + i * 1000));
                    stackListSecondary.add(new ItemStack(GregTech_API.sBlockOres1, 1, oreLayerWrapper.Meta[1] + i * 1000));
                    stackListBetween.add(new ItemStack(GregTech_API.sBlockOres1, 1, oreLayerWrapper.Meta[2] + i * 1000));
                    stackListSporadic.add(new ItemStack(GregTech_API.sBlockOres1, 1, oreLayerWrapper.Meta[3] + i * 1000));
                }
                this.arecipes.add(new CachedVeinStatRecipe(veinName, stackListPrimary, stackListSecondary, stackListBetween, stackListSporadic));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack stack) {
        if (stack.func_77977_a().startsWith("gt.blockores")) {
            if (stack.func_77960_j() > 16000) {
                super.loadCraftingRecipes(stack);
                return;
            }
            short baseMeta = (short)(stack.func_77960_j() % 1000);
            for (GT5OreLayerHelper.OreLayerWrapper worldGen : GT5OreLayerHelper.mapOreLayerWrapper.values()) {
                if (worldGen.Meta[0] != baseMeta && worldGen.Meta[1] != baseMeta && worldGen.Meta[2] != baseMeta && worldGen.Meta[3] != baseMeta) continue;
                ArrayList<ItemStack> stackListPrimary = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListSecondary = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListBetween = new ArrayList<ItemStack>();
                ArrayList<ItemStack> stackListSporadic = new ArrayList<ItemStack>();
                for (int i = 0; i < this.getMaximumMaterialIndex(baseMeta, false); ++i) {
                    stackListPrimary.add(new ItemStack(GregTech_API.sBlockOres1, 1, worldGen.Meta[0] + i * 1000));
                    stackListSecondary.add(new ItemStack(GregTech_API.sBlockOres1, 1, worldGen.Meta[1] + i * 1000));
                    stackListBetween.add(new ItemStack(GregTech_API.sBlockOres1, 1, worldGen.Meta[2] + i * 1000));
                    stackListSporadic.add(new ItemStack(GregTech_API.sBlockOres1, 1, worldGen.Meta[3] + i * 1000));
                }
                this.arecipes.add(new CachedVeinStatRecipe(worldGen.veinName, stackListPrimary, stackListSecondary, stackListBetween, stackListSporadic));
            }
        } else {
            super.loadCraftingRecipes(stack);
        }
    }

    public void drawExtras(int recipe) {
        CachedVeinStatRecipe crecipe = (CachedVeinStatRecipe)((Object)this.arecipes.get(recipe));
        GT5OreLayerHelper.OreLayerWrapper oreLayer = GT5OreLayerHelper.mapOreLayerWrapper.get(crecipe.veinName);
        String sDimNames = GT5OreLayerHelper.bufferedDims.get(oreLayer);
        if (Loader.isModLoaded((String)"visualprospecting")) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.veinName", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)oreLayer.veinName, (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"gtnop.gui.nei.vein", (Object[])new Object[0])), (int)2, (int)20, (int)0x404040, (boolean)false);
        } else if (PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]).contains("Ore")) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.veinName", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]).split("Ore")[0] + "" + I18n.func_135052_a((String)"gtnop.gui.nei.vein", (Object[])new Object[0])), (int)2, (int)20, (int)0x404040, (boolean)false);
        } else if (PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]).contains("Sand")) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.veinName", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]).split("Sand")[0] + "" + I18n.func_135052_a((String)"gtnop.gui.nei.vein", (Object[])new Object[0])), (int)2, (int)20, (int)0x404040, (boolean)false);
        } else {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.veinName", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0]) + " " + I18n.func_135052_a((String)"gtnop.gui.nei.vein", (Object[])new Object[0])), (int)2, (int)20, (int)0x404040, (boolean)false);
        }
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.primaryOre", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[0])), (int)2, (int)50, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.secondaryOre", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[1])), (int)2, (int)60, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.betweenOre", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[2])), (int)2, (int)70, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.sporadicOre", (Object[])new Object[0]) + ": " + PluginGT5VeinStat.getGTOreLocalizedName(oreLayer.Meta[3])), (int)2, (int)80, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.genHeight", (Object[])new Object[0]) + ": " + oreLayer.worldGenHeightRange), (int)2, (int)90, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gtnop.gui.nei.weightedChance", (Object[])new Object[0]) + ": " + Integer.toString(oreLayer.randomWeight)), (int)100, (int)90, (int)0x404040, (boolean)false);
        this.drawDimNames(sDimNames);
        this.drawSeeAllRecipesLabel();
    }

    @Override
    public String getOutputId() {
        return "GTOrePluginVein";
    }

    @Override
    public String getRecipeName() {
        return I18n.func_135052_a((String)"gtnop.gui.veinStat.name", (Object[])new Object[0]);
    }

    @Override
    protected String getDimensionNames(int recipe) {
        CachedVeinStatRecipe crecipe = (CachedVeinStatRecipe)((Object)this.arecipes.get(recipe));
        GT5OreLayerHelper.OreLayerWrapper oreLayer = GT5OreLayerHelper.mapOreLayerWrapper.get(crecipe.veinName);
        return GT5OreLayerHelper.bufferedDims.get(oreLayer);
    }

    public class CachedVeinStatRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public String veinName;
        public PositionedStack positionedStackPrimary;
        public PositionedStack positionedStackSecondary;
        public PositionedStack positionedStackBetween;
        public PositionedStack positionedStackSporadic;

        public CachedVeinStatRecipe(String veinName, List<ItemStack> stackListPrimary, List<ItemStack> stackListSecondary, List<ItemStack> stackListBetween, List<ItemStack> stackListSporadic) {
            super((TemplateRecipeHandler)PluginGT5VeinStat.this);
            this.veinName = veinName;
            this.positionedStackPrimary = new PositionedStack(stackListPrimary, 2, 0);
            this.positionedStackSecondary = new PositionedStack(stackListSecondary, 22, 0);
            this.positionedStackBetween = new PositionedStack(stackListBetween, 42, 0);
            this.positionedStackSporadic = new PositionedStack(stackListSporadic, 62, 0);
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> ingredientsList = new ArrayList<PositionedStack>();
            this.positionedStackPrimary.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackSecondary.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackBetween.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            this.positionedStackSporadic.setPermutationToRender(PluginGT5VeinStat.this.cycleticks / 20 % this.positionedStackPrimary.items.length);
            ingredientsList.add(this.positionedStackPrimary);
            ingredientsList.add(this.positionedStackSecondary);
            ingredientsList.add(this.positionedStackBetween);
            ingredientsList.add(this.positionedStackSporadic);
            return ingredientsList;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

