/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.I18n;
import pers.gwyog.gtneioreplugin.GTNEIOrePlugin;
import pers.gwyog.gtneioreplugin.util.StringPaddingHack;

public class DimensionHelper {
    public static String[] DimName = new String[]{"Overworld", "Nether", "Twilight", "TheEnd", "Vanilla_EndAsteroids", "EndAsteroid", "GalacticraftCore_Moon", "GalaxySpace_Deimos", "GalacticraftMars_Mars", "GalaxySpace_Phobos", "GalacticraftMars_Asteroids", "GalaxySpace_Callisto", "GalaxySpace_Ceres", "GalaxySpace_Europa", "GalaxySpace_Ganymede", "GalaxySpace_Io", "GalaxySpace_Mercury", "GalaxySpace_Venus", "GalaxySpace_Enceladus", "GalaxySpace_Miranda", "GalaxySpace_Oberon", "GalaxySpace_Titan", "GalaxySpace_Proteus", "GalaxySpace_Triton", "GalaxySpace_Haumea", "GalaxySpace_Kuiperbelt", "GalaxySpace_MakeMake", "GalaxySpace_Pluto", "GalaxySpace_BarnardC", "GalaxySpace_BarnardE", "GalaxySpace_BarnardF", "GalaxySpace_CentauriA", "GalaxySpace_TcetiE", "Underdark", "GalaxySpace_VegaB"};
    public static String[] DimNameDisplayed = new String[]{"Ow", "Ne", "TF", "EN", "VA", "EA", "Mo", "De", "Ma", "Ph", "As", "Ca", "Ce", "Eu", "Ga", "Io", "Me", "Ve", "En", "Mi", "Ob", "Ti", "Pr", "Tr", "Ha", "KB", "MM", "Pl", "BC", "BE", "BF", "CB", "TE", "DD", "VB"};
    private static HashMap<String, List<String>> tooltipBuffer = new HashMap();

    private static List<String> computeString(String line) {
        String[] dims = line.split(",");
        for (int j = 0; j < dims.length; ++j) {
            String s = dims[j];
            s = s.replaceAll(",", "");
            s = s.trim();
            for (int i = 0; i < DimNameDisplayed.length; ++i) {
                if (!s.equals(DimNameDisplayed[i])) continue;
                String k = DimName[i].replaceAll("GalacticraftCore_", "").replaceAll("GalacticraftMars_", "").replaceAll("GalaxySpace_", "").replaceAll("Vanilla_", "Vanilla ");
                s = I18n.func_135052_a((String)("gtnop.world." + k), (Object[])new Object[0]);
                switch (k) {
                    case "Moon": {
                        s = "T1: " + s;
                        break;
                    }
                    case "Deimos": 
                    case "Mars": 
                    case "Phobos": {
                        s = "T2: " + s;
                        break;
                    }
                    case "Asteroids": 
                    case "Callisto": 
                    case "Ceres": 
                    case "Europa": 
                    case "Ganymede": {
                        s = "T3: " + s;
                        break;
                    }
                    case "Io": 
                    case "Mercury": 
                    case "Venus": {
                        s = "T4: " + s;
                        break;
                    }
                    case "Enceladus": 
                    case "Miranda": 
                    case "Oberon": 
                    case "Titan": {
                        s = "T5: " + s;
                        break;
                    }
                    case "Proteus": 
                    case "Triton": {
                        s = "T6: " + s;
                        break;
                    }
                    case "Haumea": 
                    case "Kuiperbelt": 
                    case "MakeMake": 
                    case "Pluto": {
                        s = "T7: " + s;
                        break;
                    }
                    case "BarnardC": 
                    case "BarnardE": 
                    case "BarnardF": 
                    case "CentauriA": 
                    case "TcetiE": 
                    case "Underdark": 
                    case "VegaB": {
                        s = "T8: " + s;
                    }
                }
                dims[j] = s;
            }
        }
        if (dims.length > GTNEIOrePlugin.maxTooltipLines) {
            dims = StringPaddingHack.stringsToSpacedColumns(dims, dims.length / GTNEIOrePlugin.maxTooltipLines + (dims.length % GTNEIOrePlugin.maxTooltipLines == 0 ? 0 : 1), 2);
        }
        return Arrays.asList(dims);
    }

    public static List<String> convertCondensedStringToToolTip(String line) {
        return tooltipBuffer.computeIfAbsent(line, tmp -> DimensionHelper.computeString(line));
    }
}

