/*
 * Decompiled with CFR 0.152.
 */
package pers.gwyog.gtneioreplugin.plugin.gregtech5;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.util.GT_Utility;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pers.gwyog.gtneioreplugin.plugin.PluginBase;
import pers.gwyog.gtneioreplugin.plugin.item.ItemDimensionDisplay;
import pers.gwyog.gtneioreplugin.util.GT5UndergroundFluidHelper;

public class PluginGT5UndergroundFluid
extends PluginBase {
    private static final int lineSpace = 20;
    private static final int xDimensionDisplay = 30;
    private static final int halfItemLength = 8;

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOutputId())) {
            for (Map.Entry<String, List<GT5UndergroundFluidHelper.UndergroundFluidWrapper>> entry : GT5UndergroundFluidHelper.getAllEntries().entrySet()) {
                Fluid fluid = FluidRegistry.getFluid((String)entry.getKey());
                if (fluid == null) continue;
                this.arecipes.add(new CachedUndergroundFluidRecipe(fluid, entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack displayFluid;
        Fluid fluid = null;
        FluidStack containerFluid = GT_Utility.getFluidForFilledItem((ItemStack)result, (boolean)true);
        if (containerFluid != null) {
            fluid = containerFluid.getFluid();
        }
        if (fluid == null && (displayFluid = GT_Utility.getFluidFromDisplayStack((ItemStack)result)) != null) {
            fluid = displayFluid.getFluid();
        }
        if (fluid == null) {
            return;
        }
        List<GT5UndergroundFluidHelper.UndergroundFluidWrapper> wrappers = GT5UndergroundFluidHelper.getEntry(fluid.getName());
        if (wrappers != null) {
            this.arecipes.add(new CachedUndergroundFluidRecipe(fluid, wrappers));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        String dimension = ItemDimensionDisplay.getDimension(ingredient);
        if (dimension != null) {
            for (Map.Entry<String, List<GT5UndergroundFluidHelper.UndergroundFluidWrapper>> entry : GT5UndergroundFluidHelper.getAllEntries().entrySet()) {
                Fluid fluid;
                boolean found = false;
                for (GT5UndergroundFluidHelper.UndergroundFluidWrapper wrapper : entry.getValue()) {
                    if (!wrapper.dimension.equals(dimension)) continue;
                    found = true;
                    break;
                }
                if (!found || (fluid = FluidRegistry.getFluid((String)entry.getKey())) == null) continue;
                this.arecipes.add(new CachedUndergroundFluidRecipe(fluid, entry.getValue()));
            }
        }
    }

    public void drawExtras(int recipeIndex) {
        this.drawSeeAllRecipesLabel();
        int xChance = 85;
        int xAmount = 140;
        int yHeader = 30;
        int black = 0x404040;
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"gtnop.gui.nei.dimension", (Object[])new Object[0]) + ":"), (int)30, (int)yHeader, (int)black, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"gtnop.gui.nei.chance", (Object[])new Object[0]) + ":"), (int)xChance, (int)yHeader, (int)black, (boolean)false);
        GuiDraw.drawStringC((String)(I18n.func_135052_a((String)"gtnop.gui.nei.fluidAmount", (Object[])new Object[0]) + ":"), (int)xAmount, (int)yHeader, (int)black, (boolean)false);
        int y = 50;
        CachedUndergroundFluidRecipe recipe = (CachedUndergroundFluidRecipe)((Object)this.arecipes.get(recipeIndex));
        for (int i = 0; i < recipe.dimensionDisplayItems.size(); ++i) {
            GuiDraw.drawStringC((String)(new DecimalFormat("0.#").format((double)((Integer)recipe.chances.get(i)).intValue() / 100.0) + "%"), (int)xChance, (int)y, (int)black, (boolean)false);
            GuiDraw.drawStringC((String)(((Integer)recipe.minAmounts.get(i)).toString() + "-" + ((Integer)recipe.maxAmounts.get(i)).toString()), (int)xAmount, (int)y, (int)black, (boolean)false);
            y += 20;
        }
    }

    @Override
    public String getOutputId() {
        return "GTOrePluginUndergroundFluid";
    }

    @Override
    public String getRecipeName() {
        return I18n.func_135052_a((String)"gtnop.gui.undergroundFluid.name", (Object[])new Object[0]);
    }

    private class CachedUndergroundFluidRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final PositionedStack targetFluidDisplay;
        private final List<PositionedStack> dimensionDisplayItems;
        private final List<Integer> chances;
        private final List<Integer> maxAmounts;
        private final List<Integer> minAmounts;

        private CachedUndergroundFluidRecipe(Fluid fluid, List<GT5UndergroundFluidHelper.UndergroundFluidWrapper> wrappers) {
            super((TemplateRecipeHandler)PluginGT5UndergroundFluid.this);
            this.dimensionDisplayItems = new ArrayList<PositionedStack>();
            this.chances = new ArrayList<Integer>();
            this.maxAmounts = new ArrayList<Integer>();
            this.minAmounts = new ArrayList<Integer>();
            this.targetFluidDisplay = new PositionedStack((Object)GT_Utility.getFluidDisplayStack((Fluid)fluid), PluginGT5UndergroundFluid.this.getGuiWidth() / 2 - 8, 3);
            int y = 42;
            for (GT5UndergroundFluidHelper.UndergroundFluidWrapper wrapper : wrappers) {
                ItemStack dimensionDisplay = ItemDimensionDisplay.getItem(wrapper.dimension);
                if (dimensionDisplay == null) continue;
                this.dimensionDisplayItems.add(new PositionedStack((Object)dimensionDisplay, 22, y + GuiDraw.fontRenderer.field_78288_b / 2));
                y += 20;
                this.chances.add(wrapper.chance);
                this.maxAmounts.add(wrapper.maxAmount);
                this.minAmounts.add(wrapper.minAmount);
            }
        }

        public PositionedStack getResult() {
            return this.targetFluidDisplay;
        }

        public List<PositionedStack> getIngredients() {
            return this.dimensionDisplayItems;
        }
    }
}

