/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.recipe;

import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizons.gtnhintergalactic.item.IGItems;
import com.gtnewhorizons.gtnhintergalactic.item.ItemMiningDrones;
import com.gtnewhorizons.gtnhintergalactic.recipe.IG_RecipeAdder;
import cpw.mods.fml.common.Loader;
import goodgenerator.items.MyMaterial;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpaceMiningRecipes {
    private static final ItemStack[] MINING_DRONES = new ItemStack[ItemMiningDrones.DroneTiers.values().length];
    private static final ItemStack[] MINING_DRILLS = new ItemStack[ItemMiningDrones.DroneMaterials.values().length];
    private static final ItemStack[] MINING_RODS = new ItemStack[ItemMiningDrones.DroneMaterials.values().length];

    public static void addAsteroids() {
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 2000, 4000}, new Materials[]{Materials.Salt, Materials.RockSalt, Materials.Saltpeter}, OrePrefixes.oreEndstone, 30, 120, 1, 250, 20, 1, 200, (int)GT_Values.VP[4], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 300);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 2000, 2000, 1000, 1000}, new Materials[]{Materials.Iron, Materials.Magnetite, Materials.Pyrite, Materials.BasalticMineralSand, Materials.GraniticMineralSand}, OrePrefixes.oreEndstone, 30, 150, 1, 180, 10, 1, 200, (int)GT_Values.VP[4], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 600);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.Copper, Materials.Chalcopyrite, Materials.Malachite}, OrePrefixes.oreEndstone, 30, 150, 3, 12, 10, 1, 200, (int)GT_Values.VP[4], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 500);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{2000, 2000, 6000}, new Materials[]{Materials.Cassiterite, Materials.CassiteriteSand, Materials.Tin}, OrePrefixes.oreEndstone, 50, 200, 2, 100, 10, 1, 50, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 400);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{5000, 3500, 1500}, new Materials[]{Materials.Aluminium, Materials.Bauxite, Materials.Rutile}, OrePrefixes.oreEndstone, 10, 20, 5, 20, 20, 1, 50, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.EV.ordinal(), 120);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 3000, 3000}, new Materials[]{Materials.Nickel, Materials.Pentlandite, Materials.Garnierite}, OrePrefixes.oreEndstone, 20, 40, 5, 20, 20, 1, 50, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.IV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.Chrome, Materials.Ruby, Materials.Chromite}, OrePrefixes.oreEndstone, 16, 32, 10, 20, 40, 1, 50, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{6000, 2000, 1500, 500}, new Materials[]{Materials.Platinum, Materials.Palladium, Materials.Iridium, Materials.Osmium}, OrePrefixes.oreEndstone, 20, 40, 10, 50, 60, 1, 50, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 130);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{1500, 1500, 1500, 1500, 1500, 1500, 500, 400, 100}, new Materials[]{Materials.Ruby, Materials.Emerald, Materials.GreenSapphire, Materials.Diamond, Materials.Opal, Materials.Topaz, Materials.Bauxite, Materials.Vinteum, Materials.NetherStar}, OrePrefixes.oreEndstone, 30, 160, 17, 40, 60, 1, 100, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 180);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{7000, 2000, 1000}, new Materials[]{Materials.Indium, Materials.Sphalerite, Materials.Zinc}, OrePrefixes.oreEndstone, 30, 120, 50, 90, 120, 2, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{6000, 4000}, new Materials[]{Materials.Thaumium, Materials.Void}, OrePrefixes.dust, 20, 50, 10, 70, 120, 1, 600, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3500, 3500, 500, 500, 500, 500, 500, 500}, new Materials[]{Materials.InfusedGold, Materials.Shadow, Materials.InfusedAir, Materials.InfusedEarth, Materials.InfusedFire, Materials.InfusedWater, Materials.InfusedEntropy, Materials.InfusedOrder}, OrePrefixes.oreEndstone, 24, 60, 8, 24, 120, 1, 100, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{8000, 2000}, new Materials[]{Materials.MysteriousCrystal, Materials.Mytryl}, OrePrefixes.oreEndstone, 30, 60, 65, 120, 300, 1, 500, (int)GT_Values.VP[7], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 220);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3000, 2000, 1500, 3500}, new Materials[]{Materials.Niobium, Materials.Quantium, Materials.Ytterbium, Materials.Yttrium}, OrePrefixes.oreEndstone, 30, 120, 30, 160, 120, 1, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 160);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 3500, 2500}, new Materials[]{Materials.Quartzite, Materials.Quartz, Materials.Vanadium}, OrePrefixes.oreEndstone, 20, 80, 20, 120, 50, 1, 500, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 230);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{1500, 1500, 1500, 5500}, new Materials[]{Materials.Tellurium, Materials.Thulium, Materials.Tantalum, Materials.Redstone}, OrePrefixes.oreEndstone, 20, 80, 40, 240, 90, 1, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3000, 2000, 3500, 1500}, new Materials[]{Materials.Graphite, Materials.Mica, Materials.Silicon, Materials.SiliconSG}, OrePrefixes.oreEndstone, 20, 80, 50, 250, 60, 2, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4500, 2500, 3000}, new Materials[]{Materials.Phosphate, Materials.TricalciumPhosphate, Materials.Sulfur}, OrePrefixes.oreEndstone, 20, 150, 60, 250, 60, 1, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3000, 2500, 2500, 2000}, new Materials[]{Materials.Lead, Materials.Arsenic, Materials.Barium, Materials.Lepidolite}, OrePrefixes.oreEndstone, 30, 100, 5, 150, 20, 1, 500, (int)GT_Values.VP[4], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 220);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3500, 2500, 2500, 1500}, new Materials[]{Materials.Adamantium, Materials.Antimony, Materials.Gallium, Materials.Lithium}, OrePrefixes.oreEndstone, 30, 120, 5, 120, 20, 1, 500, (int)GT_Values.VP[4], ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 300);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3750, 3750, 2500}, new Materials[]{Materials.Tungsten, Materials.Titanium, Materials.Neodymium}, OrePrefixes.oreEndstone, 30, 70, 60, 200, 120, 1, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{6000, 2000, 2000}, new Materials[]{Materials.Lapis, Materials.Lazurite, Materials.Sodalite}, OrePrefixes.oreEndstone, 10, 50, 20, 200, 60, 1, 500, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 250);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3500, 1500, 2500, 2500}, new Materials[]{Materials.Aluminium, Materials.Bauxite, Materials.Monazite, Materials.Bastnasite}, OrePrefixes.oreEndstone, 10, 80, 40, 120, 60, 1, 500, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.MV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 250);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{6500, 2500, 1000}, new Materials[]{Materials.Draconium, Materials.DraconiumAwakened, Materials.ElectrumFlux}, OrePrefixes.oreEndstone, 15, 60, 60, 200, 360, 2, 600, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.LuV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 190);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3000, 2500, 2500, 2000}, new Materials[]{Materials.Uranium, Materials.Uranium235, Materials.Plutonium, Materials.Plutonium241}, OrePrefixes.oreEndstone, 20, 90, 30, 70, 120, 1, 400, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.HV.ordinal(), ItemMiningDrones.DroneTiers.ZPM.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{10000}, new Materials[]{Materials.Cheese}, OrePrefixes.oreEndstone, 1, 30, 90, 200, 240, 2, 1000, (int)GT_Values.VP[7], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 10);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3750, 3750, 2500}, new Materials[]{Materials.Cobalt, Materials.Ardite, Materials.Manyullyn}, OrePrefixes.ore, 20, 90, 30, 100, 180, 1, 1000, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{2000, 4000, 4000}, new Materials[]{Materials.Europium, Materials.Ledox, Materials.CallistoIce}, OrePrefixes.oreEndstone, 10, 30, 40, 60, 240, 2, 1000, (int)GT_Values.VP[7], ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 100);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{2500, 2500, 2500, 2500}, new Materials[]{Materials.CosmicNeutronium, Materials.Neutronium, Materials.BlackPlutonium, Materials.Bedrockium}, OrePrefixes.oreEndstone, 10, 70, 60, 100, 240, 2, 500, (int)GT_Values.VP[8], ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 170);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.InfinityCatalyst, Materials.CosmicNeutronium, Materials.Neutronium}, OrePrefixes.oreEndstone, 30, 120, 70, 100, 320, 2, 1000, (int)GT_Values.VP[8], ItemMiningDrones.DroneTiers.UV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{5000, 3000, 2000}, new Materials[]{Materials.ShadowIron, Materials.MeteoricIron, Materials.Ichorium}, OrePrefixes.oreEndstone, 30, 120, 70, 100, 320, 3, 1000, (int)GT_Values.VP[8], ItemMiningDrones.DroneTiers.UV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 150);
        SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{10000}, new ItemStack[]{new ItemStack(Blocks.field_150435_aG, 64)}, 30, 60, 20, 100, 30, 1, 800, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.LV.ordinal(), ItemMiningDrones.DroneTiers.LuV.ordinal(), 200);
        if (Loader.isModLoaded((String)"bartworks")) {
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{2000, 3000, 3000, 2000}, new Materials[]{Materials.Holmium, Materials.Samarium, WerkstoffLoader.Tiberium.getBridgeMaterial(), Materials.Strontium}, OrePrefixes.ore, 5, 25, 40, 80, 260, 2, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.UV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 75);
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{3800, 2000, 1500, 500, 1200, 1000}, new Materials[]{Materials.Platinum, Materials.Palladium, Materials.Iridium, Materials.Osmium, WerkstoffLoader.Ruthenium.getBridgeMaterial(), WerkstoffLoader.Rhodium.getBridgeMaterial()}, OrePrefixes.dust, 10, 30, 25, 200, 360, 3, 500, (int)GT_Values.VP[7], ItemMiningDrones.DroneTiers.ZPM.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 60);
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 3000, 3000}, new Materials[]{Materials.Magnesium, Materials.Manganese, WerkstoffLoader.Fluorspar.getBridgeMaterial()}, OrePrefixes.ore, 10, 80, 10, 200, 60, 1, 400, (int)GT_Values.VP[5], ItemMiningDrones.DroneTiers.EV.ordinal(), ItemMiningDrones.DroneTiers.UHV.ordinal(), 250);
        }
        if (Loader.isModLoaded((String)"GoodGenerator")) {
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{1500, 2000, 3000, 3500}, new Materials[]{Materials.Trinium, Materials.Lanthanum, MyMaterial.orundum.getBridgeMaterial(), Materials.Silver}, OrePrefixes.ore, 30, 120, 30, 230, 120, 2, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 150);
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{100, 2200, 4700, 3000}, new Materials[]{Materials.Dilithium, MyMaterial.orundum.getBridgeMaterial(), Materials.Vanadium, Materials.Ytterbium}, OrePrefixes.ore, 5, 80, 20, 100, 120, 3, 500, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.UEV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 50);
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{4000, 3500, 2500}, new Materials[]{MyMaterial.naquadahEarth.getBridgeMaterial(), MyMaterial.enrichedNaquadahEarth.getBridgeMaterial(), MyMaterial.naquadriaEarth.getBridgeMaterial()}, OrePrefixes.ore, 20, 80, 50, 150, 240, 1, 1000, (int)GT_Values.VP[6], ItemMiningDrones.DroneTiers.IV.ordinal(), ItemMiningDrones.DroneTiers.UV.ordinal(), 200);
        }
        if (Loader.isModLoaded((String)"EMT")) {
            SpaceMiningRecipes.addRecipesToDrones(null, null, new int[]{100, 100, 9800}, new ItemStack[]{GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)16), GT_ModHandler.getModItem((String)"DraconicEvolution", (String)"draconicCore", (long)1L, (int)0), ItemList.ZPM.getWithCharge(1L, 0x7FFFFFFE, new Object[0])}, 1, 1, 50, 200, 1000, 3, 2000, (int)GT_Values.VP[10], ItemMiningDrones.DroneTiers.UHV.ordinal(), ItemMiningDrones.DroneTiers.UEV.ordinal(), 1);
        }
    }

    private static void addRecipesToDrones(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, ItemStack[] aItemOutputs, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int startDroneTier, int endDroneTier, int recipeWeight) {
        ItemStack[] tItemInputs;
        if (aItemInputs == null) {
            tItemInputs = new ItemStack[3];
        } else {
            tItemInputs = new ItemStack[aItemInputs.length + 3];
            System.arraycopy(aItemInputs, 0, tItemInputs, 3, aItemInputs.length);
        }
        for (int i = startDroneTier; i <= endDroneTier; ++i) {
            tItemInputs[0] = MINING_DRONES[i];
            tItemInputs[1] = MINING_DRILLS[i];
            tItemInputs[2] = MINING_RODS[i];
            IG_RecipeAdder.addSpaceMiningRecipe(tItemInputs, aFluidInputs, aChances, aItemOutputs, minSize + (int)Math.pow(2.0, i - startDroneTier) - 1, maxSize + (int)Math.pow(2.0, i - startDroneTier) - 1, minDistance, maxDistance, computationRequiredPerSec, minModuleTier, (int)Math.ceil((double)duration / Math.sqrt(i - startDroneTier + 1)), EUt, recipeWeight);
        }
    }

    private static void addRecipesToDrones(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int[] aChances, Materials[] ores, OrePrefixes orePrefixes, int minSize, int maxSize, int minDistance, int maxDistance, int computationRequiredPerSec, int minModuleTier, int duration, int EUt, int startDroneTier, int endDroneTier, int recipeWeight) {
        ItemStack[] tItemInputs;
        if (aItemInputs == null) {
            tItemInputs = new ItemStack[3];
        } else {
            tItemInputs = new ItemStack[aItemInputs.length + 3];
            System.arraycopy(aItemInputs, 0, tItemInputs, 3, aItemInputs.length);
        }
        for (int i = startDroneTier; i <= endDroneTier; ++i) {
            tItemInputs[0] = MINING_DRONES[i];
            tItemInputs[1] = MINING_DRILLS[i];
            tItemInputs[2] = MINING_RODS[i];
            IG_RecipeAdder.addSpaceMiningRecipe(tItemInputs, aFluidInputs, aChances, ores, orePrefixes, minSize + (int)Math.pow(2.0, i - startDroneTier) - 1, maxSize + (int)Math.pow(2.0, i - startDroneTier) - 1, minDistance, maxDistance, computationRequiredPerSec, minModuleTier, (int)Math.ceil((double)duration / Math.sqrt(i - startDroneTier + 1)), (int)Math.ceil((double)EUt * Math.sqrt(i - startDroneTier + 1)), recipeWeight);
        }
    }

    static {
        for (ItemMiningDrones.DroneTiers droneTiers : ItemMiningDrones.DroneTiers.values()) {
            SpaceMiningRecipes.MINING_DRONES[droneTiers.ordinal()] = new ItemStack(IGItems.MiningDrones, 0, droneTiers.ordinal());
        }
        for (Enum enum_ : ItemMiningDrones.DroneMaterials.values()) {
            SpaceMiningRecipes.MINING_DRILLS[enum_.ordinal()] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadDrill, (Object)((ItemMiningDrones.DroneMaterials)enum_).getMaterial(), (long)4L);
            SpaceMiningRecipes.MINING_RODS[enum_.ordinal()] = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stick, (Object)((ItemMiningDrones.DroneMaterials)enum_).getMaterial(), (long)4L);
        }
    }
}

