/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.client.lore;

import com.gtnewhorizons.gtnhintergalactic.GTNHIntergalactic;
import com.gtnewhorizons.gtnhintergalactic.client.lore.LoreHolder;
import gregtech.api.objects.XSTR;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

public class LoreHandler
implements IResourceManagerReloadListener {
    private static final Map<Field, String> LORE_HOLDERS = new HashMap<Field, String>();

    public void func_110549_a(IResourceManager p_110549_1_) {
        LoreHandler.updateLoreHolders();
    }

    public static void registerLoreHolder(Class<?> clazz) {
        try {
            for (Field field : clazz.getDeclaredFields()) {
                LoreHolder loreHolder;
                if (!field.getType().isAssignableFrom(String.class) || !Modifier.isStatic(field.getModifiers()) || (loreHolder = field.getDeclaredAnnotation(LoreHolder.class)) == null) continue;
                field.setAccessible(true);
                LORE_HOLDERS.put(field, loreHolder.value());
            }
        }
        catch (Exception e) {
            GTNHIntergalactic.LOG.warn("Unable to find LoreHolder in " + clazz.toString(), (Throwable)e);
        }
    }

    private static void updateLoreHolders() {
        LORE_HOLDERS.forEach((field, keyPrefix) -> {
            try {
                field.set(null, LoreHandler.getRandomLine(keyPrefix));
            }
            catch (Exception e) {
                GTNHIntergalactic.LOG.warn("Unable to update LoreHolder in " + field.getDeclaringClass().toString() + " (Field: " + field.getName() + ")", (Throwable)e);
            }
        });
    }

    private static String getRandomLine(String keyPrefix) {
        List<String> allLines = LoreHandler.getAllLines(keyPrefix);
        int size = allLines.size();
        return size == 0 ? null : allLines.get(XSTR.XSTR_INSTANCE.nextInt(size));
    }

    private static List<String> getAllLines(String keyPrefix) {
        String localizedLine;
        String unlocalizedLine;
        ArrayList<String> allLines = new ArrayList<String>();
        int i = 0;
        while (!(unlocalizedLine = keyPrefix + i).equals(localizedLine = StatCollector.func_74838_a((String)unlocalizedLine))) {
            if (!StringUtils.isBlank((CharSequence)localizedLine)) {
                allLines.add(localizedLine);
            }
            ++i;
        }
        return allLines;
    }
}

