/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gtnhintergalactic.tile.multi.elevatormodules;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.INameFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.LedStatus;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.Parameters;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.gtnhintergalactic.block.IGBlocks;
import com.gtnewhorizons.gtnhintergalactic.gui.IG_UITextures;
import com.gtnewhorizons.gtnhintergalactic.tile.multi.GT_MetaTileEntity_EnhancedMultiBlockBase_EM;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public abstract class TileEntityModuleBase
extends GT_MetaTileEntity_EnhancedMultiBlockBase_EM {
    protected static long EU_BUFFER_BASE_SIZE = 160008000L;
    protected final long euBufferSize;
    protected final int tTier;
    protected final int tModuleTier;
    protected final int tMinMotorTier;
    protected boolean isConnected = false;
    Parameters.Group.ParameterOut energyDisplay;
    private static final INameFunction<TileEntityModuleBase> ENERGY_DISPLAY_NAME = (base, p) -> GCCoreUtil.translate((String)"gt.blockmachines.multimachine.project.ig.cfgo.0");
    private static final IStatusFunction<TileEntityModuleBase> ENERGY_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary((double)p.get(), (double)1.0, (double)((double)base.maxEUStore() / 2.0), (double)((double)base.maxEUStore() * 2.0), (double)((double)base.maxEUStore() * 2.0), (double[])new double[0]);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<TileEntityModuleBase> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"H", "H"}, {"~", "H"}, {"H", "H"}, {"H", "H"}, {"H", "H"}})).addElement('H', GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)4096, (int)1, (Block)IGBlocks.SpaceElevatorCasing, (int)0)).build();

    protected TileEntityModuleBase(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aID, aName, aNameRegional);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7);
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(int aID, String aName, String aNameRegional, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aID, aName, aNameRegional);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7) * (long)bufferSizeMultiplier;
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(String aName, int tTier, int tModuleTier, int tMinMotorTier) {
        super(aName);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7);
        this.useLongPower = true;
    }

    protected TileEntityModuleBase(String aName, int tTier, int tModuleTier, int tMinMotorTier, int bufferSizeMultiplier) {
        super(aName);
        this.tTier = tTier;
        this.tModuleTier = tModuleTier;
        this.tMinMotorTier = tMinMotorTier;
        this.euBufferSize = EU_BUFFER_BASE_SIZE * (1L << tTier - 7) * (long)bufferSizeMultiplier;
        this.useLongPower = true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && this.isConnected) {
            super.onPostTick(aBaseMetaTileEntity, aTick);
            if (aTick % 400L == 0L) {
                this.fixAllIssues();
            }
            if (aTick % 20L == 0L) {
                this.energyDisplay.set((double)this.getEUVar());
            }
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (aBaseMetaTileEntity.getStoredEU() <= 0L && this.mMaxProgresstime > 0) {
                this.stopMachine();
            }
        }
    }

    public boolean drainEnergyInput(long EUtEffective, long Amperes) {
        long EUuse = EUtEffective * Amperes;
        if (EUuse == 0L) {
            return true;
        }
        if (EUuse < 0L) {
            EUuse = -EUuse;
        }
        if (EUuse <= this.getEUVar()) {
            this.setEUVar(this.getEUVar() - EUuse);
            return true;
        }
        return false;
    }

    public long maxEUStore() {
        return this.euBufferSize;
    }

    public long increaseStoredEU(long maximumIncrease) {
        if (this.getBaseMetaTileEntity() == null) {
            return 0L;
        }
        this.isConnected = true;
        long increasedEU = Math.min(this.getBaseMetaTileEntity().getEUCapacity() - this.getBaseMetaTileEntity().getStoredEU(), maximumIncrease);
        return this.getBaseMetaTileEntity().increaseStoredEnergyUnits(increasedEU, false) ? increasedEU : 0L;
    }

    public void disconnect() {
        this.isConnected = false;
    }

    protected void chargeController_EM(IGregTechTileEntity aBaseMetaTileEntity) {
    }

    protected void fixAllIssues() {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public int getTier() {
        return this.tTier;
    }

    public int getNeededMotorTier() {
        return this.tMinMotorTier;
    }

    public long getMaxInputVoltage() {
        return GT_Values.V[this.tTier];
    }

    @Override
    public IStructureDefinition<? extends GT_MetaTileEntity_MultiblockBase_EM> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(STRUCTURE_PIECE_MAIN, 0, 1, 0, stackSize, hintsOnly);
    }

    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.fixAllIssues();
        return this.structureCheck_EM(STRUCTURE_PIECE_MAIN, 0, 1, 0);
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean willExplodeInRain() {
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096), new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? GT_MetaTileEntity_MultiblockBase_EM.ScreenON : GT_MetaTileEntity_MultiblockBase_EM.ScreenOFF))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)4096)};
    }

    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)IG_UITextures.PICTURE_ELEVATOR_LOGO_DARK).setSize(18, 18).setPos(173, 74));
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.setSynced(false).setSpace(0).setPos(10, 7);
        ((Column)screenElements.widget(new TextWidget(GT_Utility.trans((String)"138", (String)"Incomplete Structure.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> !this.mMachine))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mMachine, val -> {
            this.mMachine = val;
        }));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.ready")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.noRecipe")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && !this.getBaseMetaTileEntity().isActive()));
        screenElements.widget(new TextWidget(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.ig.elevator.gui.recipe")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setEnabled(widget -> this.mMachine && this.getBaseMetaTileEntity().isActive()));
    }

    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, false);
        this.energyDisplay = hatch_0.makeOutParameter(0, 0.0, ENERGY_DISPLAY_NAME, ENERGY_STATUS);
    }
}

