/*
 * Decompiled with CFR 0.152.
 */
package com.elisis.gtnhlanth.common.tileentity;

import com.elisis.gtnhlanth.api.recipe.LanthanidesRecipeMaps;
import com.elisis.gtnhlanth.util.DescTextLocalization;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class Digester
extends GT_MetaTileEntity_EnhancedMultiBlockBase<Digester>
implements ISurvivalConstructable {
    protected int casingAmount = 0;
    protected int height = 0;
    private HeatingCoilLevel heatLevel;
    private final IStructureDefinition<Digester> multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"       ", " ttttt ", " t---t ", " t---t ", " t---t ", " ttttt ", "       "}, {"  ttt  ", " t---t ", "t-----t", "t-----t", "t-----t", " t---t ", "  ttt  "}, {" tccct ", "tc---ct", "c-----c", "c-----c", "c-----c", "tc---ct", " tccct "}, {" tt~tt ", "thhhhht", "thsssht", "thsssht", "thsssht", "thhhhht", " ttttt "}})).addElement('t', (IStructureElement)GT_StructureUtility.buildHatchAdder(Digester.class).atLeast(new IHatchElement[]{GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.OutputBus, GT_HatchElement.Maintenance, GT_HatchElement.Energy, GT_HatchElement.Muffler}).casingIndex(47).dot(1).buildAndChain(GregTech_API.sBlockCasings4, 0)).addElement('h', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)).addElement('s', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)).addElement('c', GT_StructureUtility.ofCoil(Digester::setCoilLevel, Digester::getCoilLevel)).build();

    public Digester(String name) {
        super(name);
    }

    public Digester(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(this.mName, 3, 3, 0) && !this.mMufflerHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.heatLevel;
    }

    public void setCoilLevel(HeatingCoilLevel level) {
        this.heatLevel = level;
    }

    public RecipeMap<?> getRecipeMap() {
        return LanthanidesRecipeMaps.digesterRecipes;
    }

    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return super.createOverclockCalculator(recipe).enablePerfectOC();
            }

            @Nonnull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                return (long)recipe.mSpecialValue <= Digester.this.getCoilLevel().getHeat() ? CheckRecipeResultRegistry.SUCCESSFUL : CheckRecipeResultRegistry.insufficientHeat((int)recipe.mSpecialValue);
            }
        };
    }

    public boolean supportsVoidProtection() {
        return true;
    }

    public boolean supportsInputSeparation() {
        return true;
    }

    public boolean supportsBatchMode() {
        return true;
    }

    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new Digester(this.mName);
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(this.mName, itemStack, b, 3, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 3, 3, 0, elementBudget, env, false, true);
    }

    public String[] getStructureDescription(ItemStack arg0) {
        return DescTextLocalization.addText("Digester.hint", 6);
    }

    public ITexture[] getTexture(IGregTechTileEntity te, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstone) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW}).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47], TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER}).extFacing().build(), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW}).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][47]};
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Digester").addInfo("Controller block for the Digester").addInfo("Input ores and fluid, output water.").addInfo(DescTextLocalization.BLUEPRINT_INFO).addSeparator().addController("Front bottom").addInputHatch("Hint block with dot 1").addInputBus("Hint block with dot 1").addOutputHatch("Hint block with dot 1").addOutputBus("Hint block with dot 1").addMaintenanceHatch("Hint block with dot 1").addMufflerHatch("Hint block with dot 1").toolTipFinisher("GTNH: Lanthanides");
        return tt;
    }

    public IStructureDefinition<Digester> getStructureDefinition() {
        return this.multiDefinition;
    }

    public boolean explodesOnComponentBreak(ItemStack arg0) {
        return false;
    }

    public int getDamageToComponent(ItemStack arg0) {
        return 0;
    }
}

