/*
 * Decompiled with CFR 0.152.
 */
package com.elisis.gtnhlanth.loader;

import com.elisis.gtnhlanth.common.register.BotWerkstoffMaterialPool;
import com.elisis.gtnhlanth.common.register.LanthItemList;
import com.elisis.gtnhlanth.common.register.WerkstoffMaterialPool;
import com.elisis.gtnhlanth.loader.RecipeAdder;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import goodgenerator.items.MyMaterial;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeLoader {
    private static final Materials[] BLACKLIST = null;

    public static void loadGeneral() {
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.Zirconia.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getFluid(4000L), Materials.Water.getFluid(2000L), WerkstoffMaterialPool.ZirconiumTetrachloride.get(OrePrefixes.dust, 1), 300);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.ZirconiumTetrachloride.get(OrePrefixes.dust, 1), Materials.Water.getFluid(1000L), WerkstoffMaterialPool.ZirconiumTetrachlorideSolution.getFluidOrGas(1000), null, 200);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)2), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Magnesium, (long)2L), WerkstoffMaterialPool.ZirconiumTetrachlorideSolution.getFluidOrGas(1000), null, WerkstoffMaterialPool.Zirconium.get(OrePrefixes.ingotHot, 1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Magnesiumchloride, (long)2L), 600, 1920, 4500);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.Hafnia.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getFluid(4000L), Materials.Water.getFluid(2000L), WerkstoffMaterialPool.HafniumTetrachloride.get(OrePrefixes.dust, 1), 300);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.HafniumTetrachloride.get(OrePrefixes.dust, 1), Materials.Water.getFluid(1000L), WerkstoffMaterialPool.HafniumTetrachlorideSolution.getFluidOrGas(1000), null, 200);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)2), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Magnesium, (long)2L), WerkstoffMaterialPool.HafniumTetrachlorideSolution.getFluidOrGas(1000), null, WerkstoffMaterialPool.LowPurityHafnium.get(OrePrefixes.dust, 1), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Magnesiumchloride, (long)2L), 600, 1920, 2700);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.LowPurityHafnium.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.Iodine.getFluidOrGas(4000), null, WerkstoffMaterialPool.HafniumIodide.get(OrePrefixes.dust, 1), 300);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.LowPurityHafnium.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.Iodine.get(OrePrefixes.dust, 4), null, null, WerkstoffMaterialPool.HafniumIodide.get(OrePrefixes.dust, 1), 300);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)12), WerkstoffMaterialPool.HafniumIodide.get(OrePrefixes.dust, 1), null, WerkstoffMaterialPool.Iodine.getFluidOrGas(2000), WerkstoffMaterialPool.Hafnium.get(OrePrefixes.ingotHot, 1), WerkstoffMaterialPool.HafniumRunoff.get(OrePrefixes.dustTiny, 1), 600, 1920, 3400);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)13), WerkstoffMaterialPool.HafniumIodide.get(OrePrefixes.dust, 9), null, WerkstoffMaterialPool.Iodine.getFluidOrGas(18000), WerkstoffMaterialPool.Hafnium.get(OrePrefixes.ingotHot, 9), WerkstoffMaterialPool.HafniumRunoff.get(OrePrefixes.dust, 1), 5400, 1920, 3400);
        GT_Values.RA.addCentrifugeRecipe(WerkstoffMaterialPool.HafniaZirconiaBlend.get(OrePrefixes.dust, 1), null, null, null, WerkstoffMaterialPool.Hafnia.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.Zirconia.get(OrePrefixes.dust, 1), null, null, null, null, new int[]{10000, 10000}, 600, 1920);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)12), Materials.NitricAcid.getCells(1), Materials.Ammonium.getFluid(1000L), null, null, 400);
        GT_ModHandler.addSmeltingRecipe((ItemStack)GT_ModHandler.getModItem((String)"harvestcraft", (String)"seaweedItem", (long)1L), (ItemStack)WerkstoffMaterialPool.SeaweedAsh.get(OrePrefixes.dustSmall, 1));
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.SeaweedAsh.get(OrePrefixes.dust, 1), null, null, null, Materials.DilutedSulfuricAcid.getFluid(600L), WerkstoffMaterialPool.SeaweedConcentrate.getFluidOrGas(600), Materials.Calcite.getDustSmall(2), 300, 240);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.SeaweedAsh.get(OrePrefixes.dust, 4), null, null, null, Materials.DilutedSulfuricAcid.getFluid(2400L), WerkstoffMaterialPool.SeaweedConcentrate.getFluidOrGas(2400), Materials.Calcite.getDust(2), 1200, 240);
        GT_Values.RA.addCentrifugeRecipe(Materials.Benzene.getCells(1), null, WerkstoffMaterialPool.SeaweedConcentrate.getFluidOrGas(2000), WerkstoffMaterialPool.SeaweedByproducts.getFluidOrGas(200), WerkstoffMaterialPool.Iodine.get(OrePrefixes.dust, 1), null, null, null, null, null, new int[]{10000}, 760, 480);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.MagnesiumPeroxide.get(OrePrefixes.dust, 2), GT_ModHandler.getModItem((String)"dreamcraft", (String)"PotassiumHydroxideDust", (long)4L), Materials.Oxygen.getGas(2000L), Materials.Water.getFluid(2000L), WerkstoffMaterialPool.PotassiumPermanganate.get(OrePrefixes.dust, 2), null, 150, 480, 1200);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), Materials.SiliconDioxide.getDust(1), Materials.HydrofluoricAcid.getFluid(6000L), WerkstoffMaterialPool.FluorosilicicAcid.getFluidOrGas(1000), null, 300, 600);
        GT_Values.RA.addChemicalRecipe(Materials.Empty.getCells(2), Materials.Salt.getDust(2), WerkstoffMaterialPool.FluorosilicicAcid.getFluidOrGas(1000), WerkstoffMaterialPool.SodiumFluorosilicate.getFluidOrGas(1000), Materials.HydrochloricAcid.getCells(2), 600, 450);
    }

    public static void loadLanthanideRecipes() {
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{MyMaterial.vanadiumPentoxide.get(OrePrefixes.dustTiny, 0)}, new FluidStack[]{Materials.Methanol.getFluid(1000L), Materials.CarbonMonoxide.getGas(2000L), Materials.Oxygen.getGas(3000L)}, new FluidStack[]{MyMaterial.oxalate.getFluidOrGas(1000)}, null, 450, 600);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{MyMaterial.vanadiumPentoxide.get(OrePrefixes.dustTiny, 0)}, new FluidStack[]{Materials.Ethanol.getFluid(1000L), Materials.CarbonMonoxide.getGas(3000L), Materials.Oxygen.getGas(3000L)}, new FluidStack[]{MyMaterial.oxalate.getFluidOrGas(1000)}, null, 450, 600);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.CeriumDioxide.get(OrePrefixes.dust, 1), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(3000), Materials.Ammonia.getGas(3000L), WerkstoffMaterialPool.CeriumChloride.get(OrePrefixes.dust, 1), 300, 450);
        GT_Values.RA.addChemicalRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.CeriumChloride.get(OrePrefixes.dust, 2), MyMaterial.oxalate.getFluidOrGas(3000), Materials.HydrochloricAcid.getFluid(6000L), WerkstoffMaterialPool.CeriumOxalate.get(OrePrefixes.dust, 1), 300, 450);
        GT_Values.RA.addElectrolyzerRecipe(WerkstoffMaterialPool.CeriumIIIOxide.get(OrePrefixes.dust, 5), null, null, Materials.Oxygen.getFluid(3000L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Cerium, (long)2L), null, null, null, null, null, new int[]{10000}, 150, 120);
        RecipeAdder.instance.DigesterRecipes.addDigesterRecipe(new FluidStack[]{Materials.NitricAcid.getFluid(350L)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushed, (Object)Materials.Monazite, (long)1L)}, WerkstoffMaterialPool.MuddyRareEarthMonaziteSolution.getFluidOrGas(200), new ItemStack[]{Materials.SiliconDioxide.getDustSmall(2)}, 1920, 200, 800);
        RecipeAdder.instance.DissolutionTankRecipes.addDissolutionTankRecipe(new FluidStack[]{Materials.Water.getFluid(10000L), WerkstoffMaterialPool.MuddyRareEarthMonaziteSolution.getFluidOrGas(1000)}, new ItemStack[]{Materials.Saltpeter.getDust(1)}, WerkstoffMaterialPool.DilutedRareEarthMonaziteMud.getFluidOrGas(11000), new ItemStack[]{WerkstoffMaterialPool.HafniaZirconiaBlend.get(OrePrefixes.dustTiny, 4), WerkstoffLoader.Thorianit.get(OrePrefixes.dust, 1), Materials.Monazite.getDustTiny(2)}, 480, 900, 10);
        GT_Recipe.GT_Recipe_Map.sSifterRecipes.addRecipe(false, null, new ItemStack[]{WerkstoffMaterialPool.MonaziteSulfate.get(OrePrefixes.dust, 1), Materials.SiliconDioxide.getDust(1), Materials.Rutile.getDust(1), WerkstoffLoader.RedZircon.get(OrePrefixes.dust, 1), Materials.Ilmenite.getDust(1)}, null, new int[]{9000, 7500, 2000, 500, 2000}, new FluidStack[]{WerkstoffMaterialPool.DilutedRareEarthMonaziteMud.getFluidOrGas(1000)}, null, 400, 240, 0);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.MonaziteSulfate.get(OrePrefixes.dust, 1), null, null, null, null, null, Materials.Water.getFluid(6000L), WerkstoffMaterialPool.DilutedMonaziteSulfate.getFluidOrGas(7000), null, 480, 400);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)13)}, new FluidStack[]{WerkstoffMaterialPool.DilutedMonaziteSulfate.getFluidOrGas(1000), WerkstoffMaterialPool.AmmoniumNitrate.getFluidOrGas(200)}, null, new ItemStack[]{WerkstoffMaterialPool.AcidicMonazitePowder.get(OrePrefixes.dustTiny, 3)}, 480, 480);
        GT_Values.RA.addMultiblockChemicalRecipe(new ItemStack[]{GT_Utility.getIntegratedCircuit((int)14)}, new FluidStack[]{WerkstoffMaterialPool.DilutedMonaziteSulfate.getFluidOrGas(9000), WerkstoffMaterialPool.AmmoniumNitrate.getFluidOrGas(1800)}, null, new ItemStack[]{WerkstoffMaterialPool.AcidicMonazitePowder.get(OrePrefixes.dust, 3)}, 4320, 480);
        GT_Values.RA.addSifterRecipe(WerkstoffMaterialPool.AcidicMonazitePowder.get(OrePrefixes.dust, 1), new ItemStack[]{WerkstoffMaterialPool.MonaziteRareEarthFiltrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.ThoriumPhosphateCake.get(OrePrefixes.dust, 1)}, new int[]{9000, 7000}, 600, 256);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.ThoriumPhosphateCake.get(OrePrefixes.dust, 1), null, null, null, WerkstoffMaterialPool.ThoriumPhosphateConcentrate.get(OrePrefixes.dust, 1), null, 300, 128, 1500);
        GT_Values.RA.addThermalCentrifugeRecipe(WerkstoffMaterialPool.ThoriumPhosphateConcentrate.get(OrePrefixes.dust), Materials.Thorium.getDust(1), Materials.Phosphate.getDust(1), null, new int[]{10000, 10000}, 200, 480);
        GT_Values.RA.addChemicalBathRecipe(WerkstoffMaterialPool.MonaziteRareEarthFiltrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.AmmoniumNitrate.getFluidOrGas(320), WerkstoffMaterialPool.NeutralizedMonaziteRareEarthFiltrate.get(OrePrefixes.dust, 1), null, null, new int[]{10000}, 120, 240);
        GT_Values.RA.addSifterRecipe(WerkstoffMaterialPool.NeutralizedMonaziteRareEarthFiltrate.get(OrePrefixes.dust, 1), new ItemStack[]{WerkstoffMaterialPool.MonaziteRareEarthHydroxideConcentrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.UraniumFiltrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.UraniumFiltrate.get(OrePrefixes.dust, 1)}, new int[]{9000, 5000, 4000}, 800, 480);
        GT_Values.RA.addChemicalBathRecipe(WerkstoffMaterialPool.UraniumFiltrate.get(OrePrefixes.dust, 1), Materials.HydrofluoricAcid.getFluid(100L), WerkstoffMaterialPool.NeutralizedUraniumFiltrate.get(OrePrefixes.dust, 1), null, null, new int[]{10000}, 360, 120);
        GT_Values.RA.addSifterRecipe(WerkstoffMaterialPool.NeutralizedUraniumFiltrate.get(OrePrefixes.dust, 1), new ItemStack[]{Materials.Fluorite.getDust(1), Materials.Uranium.getDust(1), Materials.Uranium.getDust(1), Materials.Uranium.getDust(1), Materials.Uranium235.getDust(1), Materials.Uranium235.getDust(1)}, new int[]{9500, 4500, 4000, 3000, 3000, 2000}, 1000, 30);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.MonaziteRareEarthHydroxideConcentrate.get(OrePrefixes.dust, 1), null, null, null, WerkstoffMaterialPool.DriedMonaziteRareEarthConcentrate.get(OrePrefixes.dust, 1), null, 300, 120, 1200);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.DriedMonaziteRareEarthConcentrate.get(OrePrefixes.dust, 1), null, Materials.NitricAcid.getFluid(500L), WerkstoffMaterialPool.NitratedRareEarthMonaziteConcentrate.getFluidOrGas(1000), null, 500, 480);
        GT_Values.RA.addMixerRecipe(Materials.Water.getCells(1), null, null, null, WerkstoffMaterialPool.NitratedRareEarthMonaziteConcentrate.getFluidOrGas(1000), WerkstoffMaterialPool.NitricLeachedMonaziteMixture.getFluidOrGas(1000), Materials.Empty.getCells(1), 200, 120);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 3), null, null, null, WerkstoffMaterialPool.NitratedRareEarthMonaziteConcentrate.getFluidOrGas(1000), WerkstoffMaterialPool.NitricLeachedMonaziteMixture.getFluidOrGas(2000), Materials.Empty.getCells(1), 220, 120);
        GT_Recipe.GT_Recipe_Map.sSifterRecipes.addRecipe(false, null, new ItemStack[]{WerkstoffMaterialPool.CeriumDioxide.get(OrePrefixes.dust, 1)}, null, new int[]{1111}, new FluidStack[]{WerkstoffMaterialPool.NitricLeachedMonaziteMixture.getFluidOrGas(1000)}, new FluidStack[]{WerkstoffMaterialPool.NitricMonaziteLeachedConcentrate.getFluidOrGas(1000)}, 400, 240, 0);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.CeriumDioxide.get(OrePrefixes.dust, 1), Materials.Empty.getCells(1), WerkstoffLoader.AmmoniumChloride.getFluidOrGas(3000), Materials.Ammonia.getFluid(3000L), WerkstoffMaterialPool.CeriumChloride.get(OrePrefixes.dust, 1), Materials.Water.getCells(1), 500, 1920);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.CeriumOxalate.get(OrePrefixes.dust, 1), null, null, Materials.CarbonMonoxide.getGas(6000L), WerkstoffMaterialPool.CeriumIIIOxide.get(OrePrefixes.dust), null, 200, 480, 800);
        GT_Recipe.GT_Recipe_Map.sVacuumRecipes.addRecipe(false, null, new ItemStack[]{WerkstoffMaterialPool.CooledMonaziteRareEarthConcentrate.get(OrePrefixes.dust, 1)}, null, new FluidStack[]{WerkstoffMaterialPool.NitricMonaziteLeachedConcentrate.getFluidOrGas(1000)}, null, 100, 240, 0);
        GT_Values.RA.addElectromagneticSeparatorRecipe(WerkstoffMaterialPool.CooledMonaziteRareEarthConcentrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.MonaziteRarerEarthSediment.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.EuropiumOxide.get(OrePrefixes.dustSmall, 1), null, new int[]{9000, 10}, 600, 1920);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.EuropiumOxide.get(OrePrefixes.dust, 1), null, Materials.HydricSulfide.getGas(1000L), Materials.Water.getFluid(1000L), WerkstoffMaterialPool.EuropiumSulfide.get(OrePrefixes.dust, 1), 300, 8400);
        GT_Values.RA.addElectrolyzerRecipe(WerkstoffMaterialPool.EuropiumSulfide.get(OrePrefixes.dust, 2), null, null, null, Materials.Europium.getDust(1), Materials.Sulfur.getDust(1), null, null, null, null, new int[]{10000, 10000}, 600, 33000);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.MonaziteRarerEarthSediment.get(OrePrefixes.dust, 1), null, Materials.Chlorine.getGas(1000L), null, WerkstoffMaterialPool.MonaziteHeterogenousHalogenicRareEarthMixture.get(OrePrefixes.dust, 1), null, 500, 480, 1200);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.MonaziteHeterogenousHalogenicRareEarthMixture.get(OrePrefixes.dust, 1), null, null, null, Materials.Acetone.getFluid(1000L), null, WerkstoffMaterialPool.SaturatedMonaziteRareEarthMixture.get(OrePrefixes.dust, 1), 200, 240);
        GT_Values.RA.addCentrifugeRecipe(WerkstoffMaterialPool.SaturatedMonaziteRareEarthMixture.get(OrePrefixes.dust, 2), null, null, Materials.Chloromethane.getFluid(200L), WerkstoffMaterialPool.SamaricResidue.get(OrePrefixes.dustSmall, 6), WerkstoffMaterialPool.UnknownBlend.get(OrePrefixes.dustSmall, 2), null, null, null, null, new int[]{10000, 10000}, 700, 1920);
        GT_Values.RA.addCentrifugeRecipe(WerkstoffMaterialPool.SaturatedMonaziteRareEarthMixture.get(OrePrefixes.dust, 18), null, null, Materials.Chloromethane.getFluid(1800L), WerkstoffMaterialPool.SamaricResidue.get(OrePrefixes.dust, 6), WerkstoffMaterialPool.UnknownBlend.get(OrePrefixes.dust, 2), null, null, null, null, new int[]{10000, 10000}, 6300, 1920);
        GT_Values.RA.addSifterRecipe(WerkstoffMaterialPool.SamaricResidue.get(OrePrefixes.dust, 9), new ItemStack[]{Materials.Samarium.getDust(6), Materials.Gadolinium.getDust(3)}, new int[]{10000, 10000}, 400, 1920);
        RecipeAdder.instance.DigesterRecipes.addDigesterRecipe(new FluidStack[]{Materials.NitricAcid.getFluid(350L)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushed, (Object)Materials.Bastnasite, (long)1L)}, WerkstoffMaterialPool.MuddyRareEarthBastnasiteSolution.getFluidOrGas(200), new ItemStack[]{Materials.SiliconDioxide.getDustSmall(2)}, 1920, 200, 800);
        GT_Values.RA.addCrackingRecipe(1, WerkstoffMaterialPool.MuddyRareEarthBastnasiteSolution.getFluidOrGas(1000), GT_ModHandler.getSteam((long)1000L), WerkstoffMaterialPool.SteamCrackedBasnasiteSolution.getFluidOrGas(2000), 600, 480);
        GT_Values.RA.addMixerRecipe(GT_Utility.getIntegratedCircuit((int)6), WerkstoffMaterialPool.SteamCrackedBasnasiteSolution.get(OrePrefixes.cell, 1), null, null, WerkstoffMaterialPool.SodiumFluorosilicate.getFluidOrGas(320), WerkstoffMaterialPool.ConditionedBastnasiteMud.getFluidOrGas(1320), null, 800, 120);
        RecipeAdder.instance.DissolutionTankRecipes.addDissolutionTankRecipe(new FluidStack[]{Materials.Water.getFluid(10000L), WerkstoffMaterialPool.ConditionedBastnasiteMud.getFluidOrGas(1000)}, new ItemStack[]{Materials.Saltpeter.getDust(1)}, WerkstoffMaterialPool.DiltedRareEarthBastnasiteMud.getFluidOrGas(11000), new ItemStack[]{WerkstoffMaterialPool.Gangue.get(OrePrefixes.dust, 1)}, 1920, 1000, 10);
        GT_Recipe.GT_Recipe_Map.sSifterRecipes.addRecipe(false, null, new ItemStack[]{Materials.SiliconDioxide.getDust(1), Materials.Rutile.getDust(1), WerkstoffLoader.RedZircon.get(OrePrefixes.dust, 1), Materials.Ilmenite.getDust(1)}, null, new int[]{9000, 7500, 1000, 500, 2000}, new FluidStack[]{WerkstoffMaterialPool.DiltedRareEarthBastnasiteMud.getFluidOrGas(1000)}, new FluidStack[]{WerkstoffMaterialPool.FilteredBastnasiteMud.getFluidOrGas(400)}, 400, 240, 0);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)1), null, WerkstoffMaterialPool.FilteredBastnasiteMud.getFluidOrGas(1000), null, WerkstoffMaterialPool.BastnasiteRareEarthOxidePowder.get(OrePrefixes.dust, 1), null, 500, 600, 1400);
        GT_Values.RA.addChemicalBathRecipe(WerkstoffMaterialPool.BastnasiteRareEarthOxidePowder.get(OrePrefixes.dust, 1), Materials.HydrochloricAcid.getFluid(500L), WerkstoffMaterialPool.LeachedBastnasiteRareEarthOxides.get(OrePrefixes.dust, 1), null, null, new int[]{10000}, 200, 30);
        GT_Values.RA.addBlastRecipe(GT_Utility.getIntegratedCircuit((int)1), WerkstoffMaterialPool.LeachedBastnasiteRareEarthOxides.get(OrePrefixes.dust, 1), Materials.Oxygen.getGas(1000L), Materials.Fluorine.getGas(13L), WerkstoffMaterialPool.RoastedRareEarthOxides.get(OrePrefixes.dust, 1), null, 600, 120, 1200);
        GT_Values.RA.addMixerRecipe(GT_Utility.getIntegratedCircuit((int)7), WerkstoffMaterialPool.RoastedRareEarthOxides.get(OrePrefixes.dust, 1), null, null, Materials.Water.getFluid(200L), null, WerkstoffMaterialPool.WetRareEarthOxides.get(OrePrefixes.dust, 1), 100, 30);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.WetRareEarthOxides.get(OrePrefixes.dust, 1), null, Materials.Fluorine.getGas(4000L), Materials.HydrofluoricAcid.getFluid(4000L), WerkstoffMaterialPool.CeriumOxidisedRareEarthOxides.get(OrePrefixes.dust, 1), 300, 480);
        GT_Values.RA.addCentrifugeRecipe(WerkstoffMaterialPool.CeriumOxidisedRareEarthOxides.get(OrePrefixes.dust, 1), null, null, null, WerkstoffMaterialPool.BastnasiteRarerEarthOxides.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.CeriumDioxide.get(OrePrefixes.dust, 1), null, null, null, null, new int[]{10000, 9000}, 600, 480);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.BastnasiteRarerEarthOxides.get(OrePrefixes.dust, 1), null, null, null, Materials.NitricAcid.getFluid(400L), WerkstoffMaterialPool.NitratedBastnasiteRarerEarthOxides.getFluidOrGas(1000), null, 300, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.NitratedBastnasiteRarerEarthOxides.get(OrePrefixes.cell, 1), null, Materials.Acetone.getFluid(1000L), WerkstoffMaterialPool.SaturatedBastnasiteRarerEarthOxides.getFluidOrGas(1000), null, 700, 480);
        GT_Values.RA.addCentrifugeRecipe(null, null, WerkstoffMaterialPool.SaturatedBastnasiteRarerEarthOxides.getFluidOrGas(1000), null, WerkstoffMaterialPool.NeodymicRareEarthConcentrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.SamaricRareEarthConcentrate.get(OrePrefixes.dust, 1), null, null, null, null, new int[]{8000, 5000}, 900, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.NeodymicRareEarthConcentrate.get(OrePrefixes.dust, 1), null, Materials.HydrochloricAcid.getFluid(1000L), null, WerkstoffMaterialPool.LanthaniumChloride.get(OrePrefixes.dustSmall, 2), WerkstoffMaterialPool.NeodymiumOxide.get(OrePrefixes.dustSmall, 2), 450, 800);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.SamaricRareEarthConcentrate.get(OrePrefixes.dust, 1), null, Materials.HydrofluoricAcid.getFluid(2000L), null, WerkstoffMaterialPool.FluorinatedSamaricConcentrate.get(OrePrefixes.dust, 1), null, 300, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.SamaricRareEarthConcentrate.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1), Materials.HydrofluoricAcid.getFluid(2000L), null, WerkstoffMaterialPool.FluorinatedSamaricConcentrate.get(OrePrefixes.dust, 2), null, 350, 480);
        GT_Values.RA.addBlastRecipe(WerkstoffMaterialPool.FluorinatedSamaricConcentrate.get(OrePrefixes.dust, 2), Materials.Calcium.getDust(3), null, WerkstoffMaterialPool.CalciumFluoride.getFluidOrGas(3000), Materials.Holmium.getDustSmall(1), WerkstoffMaterialPool.SamariumTerbiumMixture.get(OrePrefixes.dust, 1), 400, 1920, 1200);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.SamariumTerbiumMixture.get(OrePrefixes.dust, 1), BotWerkstoffMaterialPool.AmmoniumNitrate.get(OrePrefixes.dust, 1), null, null, WerkstoffMaterialPool.NitratedSamariumTerbiumMixture.get(OrePrefixes.dust, 1), null, 600, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.NitratedSamariumTerbiumMixture.get(OrePrefixes.dust, 1), Materials.Copper.getDustSmall(1), null, null, WerkstoffMaterialPool.TerbiumNitrate.get(OrePrefixes.dustSmall, 2), WerkstoffMaterialPool.SamaricResidue.get(OrePrefixes.dustSmall, 2), 800, 1920);
    }

    public static void addRandomChemCrafting() {
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.Butanediol.get(OrePrefixes.cell, 1), null, WerkstoffMaterialPool.TolueneTetramethylDiisocyanate.getFluidOrGas(4000), WerkstoffMaterialPool.PTMEGElastomer.getMolten(4000), Materials.Empty.getCells(1), 1500, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.TolueneDiisocyanate.get(OrePrefixes.cell, 3), Materials.Hydrogen.getCells(2), WerkstoffMaterialPool.Polytetrahydrofuran.getFluidOrGas(1000), WerkstoffMaterialPool.TolueneTetramethylDiisocyanate.getFluidOrGas(2000), Materials.Empty.getCells(5), 1200, 480);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.TungstophosphoricAcid.get(OrePrefixes.cell, 1), Materials.Oxygen.getCells(1), WerkstoffMaterialPool.Tetrahydrofuran.getFluidOrGas(144), WerkstoffMaterialPool.Polytetrahydrofuran.getFluidOrGas(432), Materials.Empty.getCells(2), 1000, 120);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.AcidicButanediol.get(OrePrefixes.cell, 1), null, Materials.Ethanol.getFluid(1000L), WerkstoffMaterialPool.Tetrahydrofuran.getFluidOrGas(1000), Materials.Empty.getCells(1), 800, 480);
        GT_Values.RA.addMixerRecipe(Materials.SulfuricAcid.getCells(1), null, null, null, WerkstoffMaterialPool.Butanediol.getFluidOrGas(1000), WerkstoffMaterialPool.AcidicButanediol.getFluidOrGas(1000), Materials.Water.getCells(1), 600, 2000);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.MoTeOCatalyst.get(OrePrefixes.dustTiny, 1), null, Materials.Butane.getGas(1000L), WerkstoffMaterialPool.Butanediol.getFluidOrGas(1000), null, 900, 1920);
        GT_Values.RA.addMixerRecipe(WerkstoffMaterialPool.MolybdenumIVOxide.get(OrePrefixes.dust, 1), WerkstoffMaterialPool.TelluriumIVOxide.get(OrePrefixes.dust, 1), null, null, null, null, WerkstoffMaterialPool.MoTeOCatalyst.get(OrePrefixes.dust, 2), 300, 120);
        GT_Values.RA.addChemicalRecipe(Materials.PhosphoricAcid.getCells(1), Materials.HydrochloricAcid.getCells(24), BotWerkstoffMaterialPool.SodiumTungstate.getFluidOrGas(12000), WerkstoffMaterialPool.TungstophosphoricAcid.getFluidOrGas(1000), Materials.Salt.getDust(24), Materials.Empty.getCells(25), 500, 1024);
        GT_Values.RA.addChemicalRecipe(WerkstoffMaterialPool.Diaminotoluene.get(OrePrefixes.cell, 1), null, BotWerkstoffMaterialPool.Phosgene.getFluidOrGas(1000), WerkstoffMaterialPool.TolueneDiisocyanate.getFluidOrGas(1000), Materials.HydrochloricAcid.getCells(1), 900, 480);
        GT_Values.RA.addChemicalRecipe(Materials.Hydrogen.getCells(2), null, WerkstoffMaterialPool.Dinitrotoluene.getFluidOrGas(1000), WerkstoffMaterialPool.Diaminotoluene.getFluidOrGas(1000), Materials.Empty.getCells(2), 300, 480);
        GT_Values.RA.addChemicalRecipe(Materials.NitricAcid.getCells(2), null, Materials.Toluene.getFluid(1000L), WerkstoffMaterialPool.Dinitrotoluene.getFluidOrGas(1000), Materials.Empty.getCells(2), 900, 480);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemList.Hull_IV.get(1L, new Object[0]), ItemList.Super_Tank_EV.get(2L, new Object[0]), ItemList.Electric_Motor_IV.get(4L, new Object[0]), ItemList.Electric_Pump_IV.get(4L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.rotor, (Object)Materials.Desh, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.Master, (long)4L), GT_Utility.getIntegratedCircuit((int)1)}, Materials.Polytetrafluoroethylene.getMolten(1440L), LanthItemList.DIGESTER, 600, 4096);
        GT_Values.RA.addAssemblerRecipe(new ItemStack[]{ItemList.Hull_EV.get(1L, new Object[0]), ItemList.Super_Tank_HV.get(2L, new Object[0]), ItemList.Electric_Motor_EV.get(4L, new Object[0]), ItemList.Electric_Pump_EV.get(2L, new Object[0]), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.rotor, (Object)Materials.VibrantAlloy, (long)4L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.circuit, (Object)Materials.Data, (long)4L), GT_Utility.getIntegratedCircuit((int)1)}, Materials.Polytetrafluoroethylene.getMolten(720L), LanthItemList.DISSOLUTION_TANK, 400, 960);
    }

    public static void removeCeriumSources() {
        int i;
        GT_Recipe tRecipe;
        int[] oreDict;
        ItemStack input;
        GT_Log.out.print("gtnhlanth: AAAAAA");
        HashSet<GT_Recipe> remove = new HashSet<GT_Recipe>(5000);
        HashSet<GT_Recipe> reAdd = new HashSet<GT_Recipe>(5000);
        block0: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.mRecipeList) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((Object)input)) continue;
            for (int oreDictID : oreDict = OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)oreDictID).startsWith("ore") && !OreDictionary.getOreName((int)oreDictID).startsWith("crushed")) continue;
                GT_Log.out.print(OreDictionary.getOreName((int)oreDictID));
                tRecipe = recipe.copy();
                for (i = 0; i < tRecipe.mOutputs.length; ++i) {
                    if (!GT_Utility.isStackValid((Object)tRecipe.mOutputs[i])) continue;
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Cerium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Samarium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (!tRecipe.mOutputs[i].func_77969_a(Materials.Lanthanum.getDust(1))) continue;
                    tRecipe.mOutputs[i] = null;
                }
                if (tRecipe.equals(recipe)) continue block0;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block0;
            }
        }
        GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Crusher done!\n");
        block3: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sOreWasherRecipes.mRecipeList) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((Object)input)) continue;
            for (int oreDictID : oreDict = OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)oreDictID).startsWith("crushed")) continue;
                tRecipe = recipe.copy();
                for (i = 0; i < tRecipe.mOutputs.length; ++i) {
                    if (!GT_Utility.isStackValid((Object)tRecipe.mOutputs[i])) continue;
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Cerium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Samarium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (!tRecipe.mOutputs[i].func_77969_a(Materials.Lanthanum.getDust(1))) continue;
                    tRecipe.mOutputs[i] = null;
                }
                if (tRecipe.equals(recipe)) continue block3;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block3;
            }
        }
        GT_Recipe.GT_Recipe_Map.sOreWasherRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sOreWasherRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sOreWasherRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Washer done!\n");
        block6: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes.mRecipeList) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((Object)input)) continue;
            for (int oreDictID : oreDict = OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)oreDictID).startsWith("crushed") && !OreDictionary.getOreName((int)oreDictID).startsWith("purified")) continue;
                tRecipe = recipe.copy();
                for (i = 0; i < tRecipe.mOutputs.length; ++i) {
                    if (!GT_Utility.isStackValid((Object)tRecipe.mOutputs[i])) continue;
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Cerium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (tRecipe.mOutputs[i].func_77969_a(Materials.Samarium.getDust(1))) {
                        tRecipe.mOutputs[i] = GT_Utility.copyAmount((long)(tRecipe.mOutputs[i].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (!tRecipe.mOutputs[i].func_77969_a(Materials.Lanthanum.getDust(1))) continue;
                    tRecipe.mOutputs[i] = null;
                }
                if (tRecipe.equals(recipe)) continue block6;
                reAdd.add(tRecipe);
                remove.add(recipe);
                continue block6;
            }
        }
        GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Thermal Centrifuge done!\n");
        for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList) {
            input = null;
            FluidStack fluidInput = null;
            if (recipe.mInputs.length > 0) {
                input = recipe.mInputs[0];
            }
            if (recipe.mFluidInputs.length > 0) {
                fluidInput = recipe.mFluidInputs[0];
            }
            if (GT_Utility.isStackValid((Object)input)) {
                int[] oreDict2;
                int[] nArray = oreDict2 = OreDictionary.getOreIDs((ItemStack)input);
                int n = nArray.length;
                for (int oreDictID = 0; oreDictID < n; ++oreDictID) {
                    int oreDictID2 = nArray[oreDictID];
                    if (!OreDictionary.getOreName((int)oreDictID2).startsWith("dust")) continue;
                    GT_Recipe tRecipe2 = recipe.copy();
                    for (int i2 = 0; i2 < tRecipe2.mOutputs.length; ++i2) {
                        if (!GT_Utility.isStackValid((Object)tRecipe2.mOutputs[i2])) continue;
                        if (tRecipe2.mOutputs[i2].func_77969_a(Materials.Cerium.getDustTiny(1))) {
                            tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dustTiny, 1)});
                            continue;
                        }
                        if (tRecipe2.mOutputs[i2].func_77969_a(Materials.Cerium.getDust(1))) {
                            tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                            continue;
                        }
                        if (tRecipe2.mOutputs[i2].func_77969_a(Materials.Cerium.getDustSmall(1))) {
                            tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dustSmall, 1)});
                            continue;
                        }
                        if (tRecipe2.mOutputs[i2].func_77969_a(Materials.Samarium.getDustTiny(1))) {
                            tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dustTiny, 1)});
                            continue;
                        }
                        if (tRecipe2.mOutputs[i2].func_77969_a(Materials.Samarium.getDust(1))) {
                            tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1)});
                            continue;
                        }
                        if (!tRecipe2.mOutputs[i2].func_77969_a(Materials.Samarium.getDustSmall(1))) continue;
                        tRecipe2.mOutputs[i2] = GT_Utility.copyAmount((long)(tRecipe2.mOutputs[i2].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dustSmall, 1)});
                    }
                    if (tRecipe2.equals(recipe)) break;
                    reAdd.add(tRecipe2);
                    remove.add(recipe);
                    break;
                }
            }
            GT_Recipe tRecipe3 = recipe.copy();
            if (!GT_Utility.isStackValid((Object)fluidInput) || fluidInput.getLocalizedName() != MyMaterial.plutoniumBasedLiquidFuel.getDefaultName()) continue;
            tRecipe3.mOutputs[1] = GT_Utility.copyAmount((long)(tRecipe3.mOutputs[1].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
            reAdd.add(tRecipe3);
            remove.add(tRecipe3);
        }
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Centrifuge done!\n");
        block12: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sHammerRecipes.mRecipeList) {
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((Object)input)) continue;
            for (int oreDictID : oreDict = OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)oreDictID).startsWith("crushed")) continue;
                GT_Recipe tRecipe4 = recipe.copy();
                for (int i3 = 0; i3 < tRecipe4.mOutputs.length; ++i3) {
                    if (!GT_Utility.isStackValid((Object)tRecipe4.mOutputs[i3])) continue;
                    if (tRecipe4.mOutputs[i3].func_77969_a(Materials.Cerium.getDust(1))) {
                        tRecipe4.mOutputs[i3] = GT_Utility.copyAmount((long)(tRecipe4.mOutputs[i3].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (!tRecipe4.mOutputs[i3].func_77969_a(Materials.Samarium.getDust(1))) continue;
                    tRecipe4.mOutputs[i3] = GT_Utility.copyAmount((long)(tRecipe4.mOutputs[i3].field_77994_a * 2), (Object[])new Object[]{WerkstoffMaterialPool.SamariumOreConcentrate.get(OrePrefixes.dust, 1)});
                }
                if (tRecipe4.equals(recipe)) continue block12;
                reAdd.add(tRecipe4);
                remove.add(recipe);
                continue block12;
            }
        }
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sHammerRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Hammer done!\n");
        block15: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList) {
            for (ItemStack input2 : recipe.mInputs) {
                GT_Log.out.print(input2.func_82833_r() + "\n");
                if (!GT_Utility.isStackValid((Object)input2) || !input2.func_82833_r().startsWith("Hibonite") && !input2.func_82833_r().startsWith("Lanthanite") && !input2.func_82833_r().startsWith("Zirconolite") && !input2.func_82833_r().startsWith("Yttrocerite") && !input2.func_82833_r().startsWith("Xenotime")) continue;
                GT_Recipe tRecipe5 = recipe.copy();
                for (int i4 = 0; i4 < tRecipe5.mOutputs.length; ++i4) {
                    if (!GT_Utility.isStackValid((Object)tRecipe5.mOutputs[i4])) continue;
                    if (tRecipe5.mOutputs[i4].func_77969_a(Materials.Cerium.getDust(1))) {
                        tRecipe5.mOutputs[i4] = GT_Utility.copyAmount((long)tRecipe5.mOutputs[i4].field_77994_a, (Object[])new Object[]{WerkstoffMaterialPool.CeriumRichMixture.get(OrePrefixes.dust, 1)});
                        continue;
                    }
                    if (tRecipe5.mOutputs[i4].func_77969_a(WerkstoffMaterialPool.Zirconium.get(OrePrefixes.dust, 1))) {
                        tRecipe5.mOutputs[i4] = null;
                        continue;
                    }
                    if (!tRecipe5.mOutputs[i4].func_77969_a(Materials.Samarium.getDust(1))) continue;
                    tRecipe5.mOutputs[i4] = null;
                }
                if (tRecipe5.equals(recipe)) continue block15;
                reAdd.add(tRecipe5);
                remove.add(recipe);
                continue block15;
            }
        }
        GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("Electrolyzer done!\n");
        block18: for (GT_Recipe recipe : GT_Recipe.GT_Recipe_Map.sByProductList.mRecipeList) {
            int[] oreDict3;
            input = recipe.mInputs[0];
            if (!GT_Utility.isStackValid((Object)input)) continue;
            for (int oreDictID : oreDict3 = OreDictionary.getOreIDs((ItemStack)input)) {
                if (!OreDictionary.getOreName((int)oreDictID).startsWith("ore") || !OreDictionary.getOreName((int)oreDictID).contains("Cerium")) continue;
                GT_Recipe tRecipe6 = recipe.copy();
                for (int i5 = 0; i5 < tRecipe6.mOutputs.length; ++i5) {
                    if (!GT_Utility.isStackValid((Object)tRecipe6.mOutputs[i5])) continue;
                    if (tRecipe6.mOutputs[i5].func_77969_a(Materials.Cerium.getDust(1))) {
                        remove.add(tRecipe6);
                        continue;
                    }
                    if (!tRecipe6.mOutputs[i5].func_77969_a(Materials.Samarium.getDust(1))) continue;
                    remove.add(tRecipe6);
                }
                continue block18;
            }
        }
        GT_Recipe.GT_Recipe_Map.sByProductList.mRecipeList.removeAll(remove);
        GT_Recipe.GT_Recipe_Map.sByProductList.mRecipeList.addAll(reAdd);
        GT_Recipe.GT_Recipe_Map.sByProductList.reInit();
        GT_Log.out.print("gtnhlanth: Replace " + remove.size() + "! ");
        remove.clear();
        reAdd.clear();
        GT_Log.out.print("ByProduct List done!\n");
    }
}

