/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.config;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigFieldParser;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public final class SyncedConfigElement {
    private final Object instance;
    private final Field field;
    private final Runnable restore;
    private boolean synced = false;

    SyncedConfigElement(@Nullable Object instance, @NotNull Field field, @NotNull Runnable restore) {
        this.instance = instance;
        this.field = field;
        this.restore = restore;
    }

    void setSyncValue(String value) throws ConfigException {
        ConfigFieldParser.setValueFromString(this.instance, this.field, value);
        this.synced = true;
    }

    void restoreValue() {
        this.restore.run();
        this.synced = false;
    }

    boolean isSynced() {
        return this.synced;
    }

    public String getValue() throws ConfigException {
        return ConfigFieldParser.getValueAsString(this.instance, this.field);
    }

    public String toString() {
        return this.field.toString();
    }
}

