/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.datastructs.space;

import com.gtnewhorizon.gtnhlib.datastructs.space.VolumeShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class ArrayProximityMap4D<T> {
    private final List<DimensionData<T>> dimList = new ArrayList<DimensionData<T>>();
    private final VolumeShape shape;

    public ArrayProximityMap4D(@Nonnull VolumeShape shape) {
        Objects.requireNonNull(shape);
        this.shape = shape;
    }

    private DimensionData<T> getDataForDim(int dim) {
        int size = this.dimList.size();
        for (int i = 0; i < size; ++i) {
            DimensionData<T> dimData = this.dimList.get(i);
            if (dimData.getDimId() != dim) continue;
            return dimData;
        }
        return null;
    }

    public void put(T obj, int dim, int x, int y, int z, int radius) {
        if (radius < 0) {
            throw new IllegalArgumentException("Radius must be strictly positive");
        }
        DimensionData<T> dimData = this.getDataForDim(dim);
        if (dimData == null) {
            dimData = new DimensionData(dim);
            this.dimList.add(dimData);
        }
        dimData.put(obj, x, y, z, radius);
    }

    public T remove(int dim, int x, int y, int z) {
        DimensionData<T> dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return null;
        }
        T obj = dimData.remove(x, y, z);
        if (dimData.isEmpty()) {
            this.dimList.remove(dimData);
        }
        return obj;
    }

    public boolean isInRange(int dim, double x, double y, double z) {
        DimensionData<T> dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return false;
        }
        if (this.shape == VolumeShape.SPHERE) {
            return dimData.isInSphere(x, y, z);
        }
        if (this.shape == VolumeShape.CUBE) {
            return dimData.isInCube(x, y, z);
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public T getClosest(int dim, double x, double y, double z) {
        DimensionData<T> dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return null;
        }
        if (this.shape == VolumeShape.SPHERE) {
            return dimData.closestSphere(x, y, z);
        }
        if (this.shape == VolumeShape.CUBE) {
            return dimData.closestCube(x, y, z);
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public void forEachInRange(int dim, double x, double y, double z, Consumer<T> action) {
        DimensionData<T> dimData = this.getDataForDim(dim);
        if (dimData == null) {
            return;
        }
        if (this.shape == VolumeShape.SPHERE) {
            dimData.forEachInSphere(x, y, z, action);
        } else if (this.shape == VolumeShape.CUBE) {
            dimData.forEachInCube(x, y, z, action);
        } else {
            throw new IllegalArgumentException("Invalid shape");
        }
    }

    public int size() {
        int size = 0;
        int listSize = this.dimList.size();
        for (int i = 0; i < listSize; ++i) {
            size += this.dimList.get(i).size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.dimList.isEmpty();
    }

    public void clear() {
        this.dimList.clear();
    }

    private static class DimensionData<T> {
        private final int dimId;
        private int[] data;
        private Object[] objects;
        private int size;
        private static final int INITIAL_CAPACITY = 8;

        public DimensionData(int dimensionId) {
            this.dimId = dimensionId;
            this.data = new int[32];
            this.objects = new Object[8];
            this.size = 0;
        }

        public int getDimId() {
            return this.dimId;
        }

        public int size() {
            return this.size;
        }

        public void put(T obj, int x, int y, int z, int radius) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                if (x != a[i] || y != a[i + 1] || z != a[i + 2]) continue;
                a[i + 3] = radius;
                this.objects[i / 4] = obj;
                return;
            }
            if (maxIndex == this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
                this.objects = Arrays.copyOf(this.objects, this.objects.length * 2);
            }
            this.data[maxIndex] = x;
            this.data[maxIndex + 1] = y;
            this.data[maxIndex + 2] = z;
            this.data[maxIndex + 3] = radius;
            this.objects[this.size] = obj;
            ++this.size;
        }

        public T remove(int x, int y, int z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                if (x != a[i] || y != a[i + 1] || z != a[i + 2]) continue;
                Object removed = this.objects[i / 4];
                int numMoved = maxIndex - i - 4;
                if (numMoved > 0) {
                    System.arraycopy(this.data, maxIndex - 4, this.data, i, 4);
                    this.objects[i / 4] = this.objects[this.size - 1];
                    this.objects[this.size - 1] = null;
                }
                --this.size;
                if (this.data.length >= 64 && this.size * 4 < this.data.length / 4) {
                    this.data = Arrays.copyOf(this.data, this.data.length / 2);
                    this.objects = Arrays.copyOf(this.objects, this.objects.length / 2);
                }
                return (T)removed;
            }
            return null;
        }

        public boolean isInSphere(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double dx = x - (double)a[i] - 0.5;
                double dy = y - (double)a[i + 1] - 0.5;
                double dz = z - (double)a[i + 2] - 0.5;
                double radius = a[i + 3];
                if (!(dx * dx + dy * dy + dz * dz < radius * radius)) continue;
                return true;
            }
            return false;
        }

        public boolean isInCube(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double centerX = (double)a[i] + 0.5;
                double centerY = (double)a[i + 1] + 0.5;
                double centerZ = (double)a[i + 2] + 0.5;
                double radius = (double)a[i + 3] + 0.5;
                if (!(centerX - radius < x) || !(x < centerX + radius) || !(centerY - radius < y) || !(y < centerY + radius) || !(centerZ - radius < z) || !(z < centerZ + radius)) continue;
                return true;
            }
            return false;
        }

        public T closestSphere(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            int closestIndex = -1;
            double closestDistSq = Double.MAX_VALUE;
            for (int i = 0; i < maxIndex; i += 4) {
                double dx = x - (double)a[i] - 0.5;
                double dy = y - (double)a[i + 1] - 0.5;
                double dz = z - (double)a[i + 2] - 0.5;
                double distSq = dx * dx + dy * dy + dz * dz;
                double radius = a[i + 3];
                if (!(distSq < radius * radius) || !(distSq < closestDistSq)) continue;
                closestIndex = i;
                closestDistSq = distSq;
            }
            if (closestIndex == -1) {
                return null;
            }
            return (T)this.objects[closestIndex / 4];
        }

        public T closestCube(double x, double y, double z) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            int closestIndex = -1;
            double closestDistSq = Double.MAX_VALUE;
            for (int i = 0; i < maxIndex; i += 4) {
                double dz;
                double dy;
                double dx;
                double distSq;
                double centerX = (double)a[i] + 0.5;
                double centerY = (double)a[i + 1] + 0.5;
                double centerZ = (double)a[i + 2] + 0.5;
                double radius = (double)a[i + 3] + 0.5;
                if (!(centerX - radius < x) || !(x < centerX + radius) || !(centerY - radius < y) || !(y < centerY + radius) || !(centerZ - radius < z) || !(z < centerZ + radius) || !((distSq = (dx = x - centerX) * dx + (dy = y - centerY) * dy + (dz = z - centerZ) * dz) < closestDistSq)) continue;
                closestIndex = i;
                closestDistSq = distSq;
            }
            if (closestIndex == -1) {
                return null;
            }
            return (T)this.objects[closestIndex / 4];
        }

        public void forEachInSphere(double x, double y, double z, Consumer<T> action) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double dx = x - (double)a[i] - 0.5;
                double dy = y - (double)a[i + 1] - 0.5;
                double dz = z - (double)a[i + 2] - 0.5;
                double distSq = dx * dx + dy * dy + dz * dz;
                double radius = a[i + 3];
                if (!(distSq < radius * radius)) continue;
                action.accept(this.objects[i / 4]);
            }
        }

        public void forEachInCube(double x, double y, double z, Consumer<T> action) {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            for (int i = 0; i < maxIndex; i += 4) {
                double centerX = (double)a[i] + 0.5;
                double centerY = (double)a[i + 1] + 0.5;
                double centerZ = (double)a[i + 2] + 0.5;
                double radius = (double)a[i + 3] + 0.5;
                if (!(centerX - radius < x) || !(x < centerX + radius) || !(centerY - radius < y) || !(y < centerY + radius) || !(centerZ - radius < z) || !(z < centerZ + radius)) continue;
                action.accept(this.objects[i / 4]);
            }
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            int maxIndex = this.size * 4;
            int[] a = this.data;
            StringBuilder sb = new StringBuilder("DimensionData{");
            sb.append("dimId=").append(this.dimId);
            sb.append(", size=").append(this.size);
            sb.append(", data={");
            for (int i = 0; i < maxIndex; i += 4) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("{x=").append(a[i]);
                sb.append(", y=").append(a[i + 1]);
                sb.append(", z=").append(a[i + 2]);
                sb.append(", radius=").append(a[i + 3]);
                sb.append(" , obj=").append(this.objects[i / 4]).append('}');
            }
            sb.append("}}");
            return sb.toString();
        }
    }
}

