/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhmixins.core;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import com.gtnewhorizon.gtnhmixins.Reflection;
import com.gtnewhorizon.mixinextras.MixinExtrasBootstrap;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.transformer.Config;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.SortingIndex(value=-2147483643)
@IFMLLoadingPlugin.Name(value="GTNHMixins Core Plugin")
@IFMLLoadingPlugin.TransformerExclusions(value={"com.gtnewhorizon.gtnhmixins.core"})
public class GTNHMixinsCore
implements IFMLLoadingPlugin {
    public static final String PLUGIN_NAME = "GTNHMixins Core Plugin";
    public static final Logger LOGGER = LogManager.getLogger((String)"GTNHMixins Core Plugin");
    public static final Map<String, String> MANUALLY_IDENTIFIED_COREMODS = ImmutableMap.builder().put((Object)"optifine.OptiFineForgeTweaker", (Object)"optifine.OptiFineForgeTweaker").put((Object)"codechicken.lib.asm.ModularASMTransformer", (Object)"codechicken.lib").put((Object)"org.bukkit.World", (Object)"Bukkit").build();

    private static void fixMixinClasspathOrder() {
        URL url = GTNHMixinsCore.class.getProtectionDomain().getCodeSource().getLocation();
        GTNHMixinsCore.givePriorityInClasspath(url, (ClassLoader)Launch.classLoader);
        GTNHMixinsCore.givePriorityInClasspath(url, ClassLoader.getSystemClassLoader());
    }

    private static void givePriorityInClasspath(URL url, ClassLoader classLoader) {
        try {
            URL[] originalUrls;
            Field urlUcpField = URLClassLoader.class.getDeclaredField("ucp");
            urlUcpField.setAccessible(true);
            Field ucpField = null;
            if (classLoader instanceof URLClassLoader) {
                ucpField = urlUcpField;
            } else {
                try {
                    ucpField = classLoader.getClass().getDeclaredField("ucp");
                }
                catch (NoSuchFieldException e) {
                    ucpField = classLoader.getClass().getSuperclass().getDeclaredField("ucp");
                }
            }
            ucpField.setAccessible(true);
            Method rawUrlsGetter = ucpField.getType().getDeclaredMethod("getURLs", new Class[0]);
            rawUrlsGetter.setAccessible(true);
            if (classLoader instanceof URLClassLoader) {
                originalUrls = ((URLClassLoader)classLoader).getURLs();
            } else {
                Object oldUcp = ucpField.get(classLoader);
                originalUrls = (URL[])rawUrlsGetter.invoke(oldUcp, new Object[0]);
            }
            ArrayList<URL> urls = new ArrayList<URL>(Arrays.asList(originalUrls));
            urls.remove(url);
            urls.add(0, url);
            URLClassLoader dummyLoader = new URLClassLoader(urls.toArray(new URL[0]), classLoader);
            Object newUcp = urlUcpField.get(dummyLoader);
            ucpField.set(classLoader, newUcp);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            if (!(classLoader instanceof URLClassLoader)) {
                LOGGER.warn("System class loader is of unsupported type {} and could not be handled", new Object[]{classLoader.getClass().getName(), e});
            }
            throw new AssertionError((Object)e);
        }
    }

    public String[] getASMTransformerClass() {
        return new String[0];
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    private Set<String> getLoadedCoremods(List<?> coremodList) {
        HashSet<String> loadedCoremods = new HashSet<String>();
        MANUALLY_IDENTIFIED_COREMODS.forEach((clsName, coreModIdentifier) -> {
            try {
                Class.forName(clsName);
                loadedCoremods.add((String)coreModIdentifier);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
        for (Object tweak : (ArrayList)Launch.blackboard.get("Tweaks")) {
            try {
                Object obj = Reflection.pluginWrapperClass.isInstance(tweak) ? Reflection.coreModInstanceField.get(tweak) : tweak;
                loadedCoremods.add(obj.toString().split("@")[0]);
            }
            catch (Exception exception) {}
        }
        for (Object coremod : coremodList) {
            try {
                Object theMod = Reflection.coreModInstanceField.get(coremod);
                loadedCoremods.add(theMod.toString().split("@")[0]);
            }
            catch (Exception exception) {}
        }
        return loadedCoremods;
    }

    public void injectData(Map<String, Object> data) {
        LOGGER.info("Examining core mod list");
        Object coremodList = data.get("coremodList");
        if (coremodList instanceof List) {
            Set<String> loadedCoremods = this.getLoadedCoremods((List)coremodList);
            LOGGER.info("LoadedCoreMods {}", new Object[]{loadedCoremods.toString()});
            for (Object coremod : (List)coremodList) {
                try {
                    Object theMod = Reflection.coreModInstanceField.get(coremod);
                    if (!(theMod instanceof IEarlyMixinLoader)) continue;
                    IEarlyMixinLoader loader = (IEarlyMixinLoader)theMod;
                    String mixinConfig = loader.getMixinConfig();
                    Config config = Config.create(mixinConfig);
                    List<String> mixins = loader.getMixins(loadedCoremods);
                    for (String mixin : mixins) {
                        LOGGER.info("Loading [{}] {}", new Object[]{mixinConfig, mixin});
                    }
                    Reflection.mixinClassesField.set(Reflection.configField.get(config), mixins);
                    Reflection.registerConfigurationMethod.invoke(null, config);
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    public String getAccessTransformerClass() {
        return null;
    }

    static {
        LOGGER.info("Initializing GTNHMixins Core");
        GTNHMixinsCore.fixMixinClasspathOrder();
        MixinBootstrap.init();
        MixinExtrasBootstrap.init();
    }
}

