/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhmixins.mixins;

import com.gtnewhorizon.gtnhmixins.GTNHMixins;
import com.gtnewhorizon.gtnhmixins.ILateMixinLoader;
import com.gtnewhorizon.gtnhmixins.LateMixin;
import com.gtnewhorizon.gtnhmixins.Reflection;
import com.gtnewhorizon.gtnhmixins.core.GTNHMixinsCore;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.transformer.Config;
import org.spongepowered.asm.mixin.transformer.Proxy;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;

@Mixin(value={FMLConstructionEvent.class}, remap=false)
public class LateMixinOrchestrationMixin {
    private static boolean finished = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void beforeConstructing(Object[] eventData, CallbackInfo ci) throws Throwable {
        if (finished) {
            return;
        }
        finished = true;
        GTNHMixins.LOGGER.info("Instantiating all @LateMixin annotated and ILateMixinLoader implemented classes...");
        ModClassLoader modClassLoader = (ModClassLoader)eventData[0];
        ASMDataTable asmDataTable = (ASMDataTable)eventData[1];
        Loader loader = Loader.instance();
        Set<String> loadedMods = loader.getIndexedModList().keySet();
        GTNHMixinsCore.LOGGER.info("LoadedMods {}", new Object[]{loadedMods.toString()});
        for (ASMDataTable.ASMData asmData : asmDataTable.getAll(LateMixin.class.getName())) {
            modClassLoader.addFile(asmData.getCandidate().getModContainer());
            String mixinClassName = asmData.getClassName().replace('/', '.');
            GTNHMixins.LOGGER.info("Instantiating {} for its mixins.", new Object[]{mixinClassName});
            Class<?> lateMixinClass = Class.forName(mixinClassName);
            if (!ILateMixinLoader.class.isAssignableFrom(lateMixinClass)) {
                GTNHMixins.LOGGER.error("Class {} has the @LateMixin annotation, but does not implement the ILateMixinLoader interface!", new Object[]{mixinClassName});
                continue;
            }
            ILateMixinLoader lateLoader = (ILateMixinLoader)lateMixinClass.newInstance();
            String mixinConfig = lateLoader.getMixinConfig();
            GTNHMixins.LOGGER.info("Adding {} mixin configuration.", new Object[]{mixinConfig});
            Config config = Config.create(mixinConfig);
            List<String> mixins = lateLoader.getMixins(loadedMods);
            for (String mixin : mixins) {
                GTNHMixins.LOGGER.info("Loading [{}] {}", new Object[]{mixinConfig, mixin});
            }
            Reflection.mixinClassesField.set(Reflection.configField.get(config), mixins);
            Reflection.registerConfigurationMethod.invoke(null, config);
        }
        for (ModContainer container : loader.getActiveModList()) {
            modClassLoader.addFile(container.getSource());
        }
        Field transformerField = Proxy.class.getDeclaredField("transformer");
        transformerField.setAccessible(true);
        Object transformer = transformerField.get(Launch.classLoader.getTransformers().stream().filter(Proxy.class::isInstance).findFirst().get());
        Object processor = Reflection.processorField.get(transformer);
        MixinEnvironment env = MixinEnvironment.getCurrentEnvironment();
        Extensions extensions = (Extensions)Reflection.extensionsField.get(processor);
        Reflection.selectConfigsMethod.invoke(processor, env);
        Reflection.prepareConfigsMethod.invoke(processor, env, extensions);
    }
}

