/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.core.LoadingConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class HodgepodgeMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger log = LogManager.getLogger((String)"Hodgepodge");
    public static LoadingConfig config;
    public static boolean thermosTainted;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        for (MixinSets set : MixinSets.values()) {
            if (!set.applied()) continue;
            mixins.addAll(Arrays.asList(set.mixinClasses));
            log.info("Loading hodgepodge plugin '{}' with mixins: {}", new Object[]{set.name, set.mixinClasses});
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        log.info("Initializing Hodgepodge");
        config = new LoadingConfig(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
        log.info("Looking for Thermos/Bukkit taint.");
        try {
            Class.forName("org.bukkit.World");
            thermosTainted = true;
            log.warn("Thermos/Bukkit detected; This is an unsupported configuration -- Things may not function properly. (I'm looking to you, Kane)");
        }
        catch (ClassNotFoundException e) {
            thermosTainted = false;
            log.info("Thermos/Bukkit NOT detected :-D");
        }
    }

    public static enum MixinSets {
        FENCE_CONNECTIONS_FIX("Fence Connections Fix", () -> HodgepodgeMixinPlugin.config.fixFenceConnections, "fixfenceconnections.block.MixinBlockFence"),
        GRASS_CHUNK_LOADING_FIX("Grass loads chunks Fix", () -> HodgepodgeMixinPlugin.config.fixGrassChunkLoads && !thermosTainted, "fixgrasschunkloads.block.MixinBlockGrass"),
        NORTHWEST_BIAS_FIX("Northwest Bias Fix", () -> HodgepodgeMixinPlugin.config.fixNorthWestBias, "fixnorthwestbias.entity.ai.MixinRandomPositionGenerator"),
        IC2_DIRECT_INV_ACCESS("IC2 Direct Inventory Access Fix", () -> HodgepodgeMixinPlugin.config.fixIc2DirectInventoryAccess, "fixic2directinventoryaccess.item.MixinItemCropSeed", "fixic2directinventoryaccess.crop.MixinTileEntityCrop"),
        FIX_NBT_LOADING("Fixed ID based Item Loading", () -> HodgepodgeMixinPlugin.config.fixIDBasedNBTLoading, "fixItemStackNBTLoad.MixinNBTFix");

        private String name;
        private Supplier<Boolean> applyIf;
        private String[] mixinClasses;

        private MixinSets(String name, Supplier<Boolean> applyIf, String ... mixinClasses) {
            this.name = name;
            this.applyIf = applyIf;
            this.mixinClasses = mixinClasses;
        }

        public boolean applied() {
            return this.applyIf.get();
        }
    }
}

