/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WorldTransformer
implements IClassTransformer {
    private static final Logger LOGGER = LogManager.getLogger((String)"CoFHCoreFix");

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("net.minecraft.world.World".equals(transformedName)) {
            LOGGER.info("Patching net.minecraft.world.World");
            ClassReader cr = new ClassReader(basicClass);
            ClassNode cn = new ClassNode(327680);
            cr.accept((ClassVisitor)cn, 8);
            int pushReplaced = 0;
            block0: for (MethodNode m : cn.methods) {
                for (AbstractInsnNode node : m.instructions) {
                    if (!(node instanceof MethodInsnNode)) continue;
                    MethodInsnNode n = (MethodInsnNode)node;
                    if (!"cofh/lib/util/LinkedHashList".equals(n.owner) || !"push".equals(n.name) || !"(Ljava/lang/Object;)Z".equals(n.desc)) continue;
                    LOGGER.debug("Replacing LinkedHashList::push inside {}{}", new Object[]{n.name, n.desc});
                    m.instructions.insertBefore((AbstractInsnNode)n, (AbstractInsnNode)new InsnNode(87));
                    m.instructions.remove((AbstractInsnNode)n);
                    ++pushReplaced;
                    continue block0;
                }
            }
            LOGGER.info("Removed {} occurrence of LinkedHashList::push", new Object[]{pushReplaced});
            ClassWriter cw = new ClassWriter(2);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }
}

