/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.util;

import codechicken.lib.inventory.InventoryUtils;
import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class ItemStackMap<T>
extends AbstractMap<ItemStack, T> {
    public static final NBTTagCompound WILDCARD_TAG = new NBTTagCompound();
    private final HashMap<Item, DetailMap> itemMap = new HashMap();
    private int size;

    static int getKeyType(int damage, NBTTagCompound tag) {
        int i = 0;
        if (ItemStackMap.isWildcard(damage)) {
            i = 1;
        }
        if (ItemStackMap.isWildcard(tag)) {
            i |= 2;
        }
        return i;
    }

    static ItemStack wildcard(Item item) {
        return InventoryUtils.newItemStack((Item)item, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)WILDCARD_TAG);
    }

    static boolean isWildcard(int damage) {
        return damage == Short.MAX_VALUE;
    }

    static boolean isWildcard(NBTTagCompound tag) {
        return tag != null && tag.func_74767_n("*");
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map == null ? null : (T)map.get(stack);
    }

    @Override
    public T put(ItemStack key, T value) {
        if (key == null || key.func_77973_b() == null || value == null) {
            return null;
        }
        return this.itemMap.computeIfAbsent(key.func_77973_b(), k -> new DetailMap()).put(key, value);
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map == null ? null : (T)map.remove(stack);
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof ItemStack)) {
            return false;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return false;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map != null && map.get(stack) != null;
    }

    @Override
    public void clear() {
        this.itemMap.clear();
        this.size = 0;
    }

    @Override
    public Set<Map.Entry<ItemStack, T>> entrySet() {
        return new SetView();
    }

    static {
        WILDCARD_TAG.func_74757_a("*", true);
    }

    private class SetView
    extends AbstractSet<Map.Entry<ItemStack, T>> {
        private SetView() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return Objects.equals(ItemStackMap.this.get(entry.getKey()), entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<ItemStack, T> itemStackTEntry) {
            return itemStackTEntry.getKey() != null && itemStackTEntry.getValue() != null && ItemStackMap.this.put(itemStackTEntry.getKey(), itemStackTEntry.getValue()) == null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ItemStackMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<ItemStack, T>> iterator() {
            return Iterators.concat((Iterator)Iterators.transform(ItemStackMap.this.itemMap.entrySet().iterator(), x$0 -> new DetailIter((Map.Entry)x$0)));
        }

        @Override
        public int size() {
            return ItemStackMap.this.size;
        }
    }

    private class DetailMap {
        private boolean hasWildcard;
        private T wildcard;
        private HashMap<Integer, T> damageMap;
        private HashMap<NBTTagCompound, T> tagMap;
        private HashMap<StackMetaKey, T> metaMap;
        private int size;

        private DetailMap() {
        }

        public T get(ItemStack key) {
            Object ret;
            if (this.wildcard != null) {
                return this.wildcard;
            }
            if (this.damageMap != null && (ret = this.damageMap.get(InventoryUtils.actualDamage((ItemStack)key))) != null) {
                return ret;
            }
            if (this.tagMap != null && (ret = this.tagMap.get(key.field_77990_d)) != null) {
                return ret;
            }
            if (this.metaMap != null) {
                return this.metaMap.get(new StackMetaKey(key));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T put(ItemStack key, T value) {
            try {
                switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                    case 0: {
                        if (this.metaMap == null) {
                            this.metaMap = new HashMap();
                        }
                        Object t = this.metaMap.put(new StackMetaKey(key), value);
                        return t;
                    }
                    case 1: {
                        if (this.tagMap == null) {
                            this.tagMap = new HashMap();
                        }
                        Object t = this.tagMap.put(key.field_77990_d, value);
                        return t;
                    }
                    case 2: {
                        if (this.damageMap == null) {
                            this.damageMap = new HashMap();
                        }
                        Object t = this.damageMap.put(InventoryUtils.actualDamage((ItemStack)key), value);
                        return t;
                    }
                    case 3: {
                        Object ret = this.wildcard;
                        this.wildcard = value;
                        this.hasWildcard = true;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public T remove(ItemStack key) {
            try {
                switch (ItemStackMap.getKeyType(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d)) {
                    case 0: {
                        Object t = this.metaMap != null ? (Object)this.metaMap.remove(new StackMetaKey(key)) : null;
                        return t;
                    }
                    case 1: {
                        Object t = this.tagMap != null ? (Object)this.tagMap.remove(key.field_77990_d) : null;
                        return t;
                    }
                    case 2: {
                        Object t = this.damageMap != null ? (Object)this.damageMap.remove(InventoryUtils.actualDamage((ItemStack)key)) : null;
                        return t;
                    }
                    case 3: {
                        Object ret = this.wildcard;
                        this.wildcard = null;
                        this.hasWildcard = false;
                        Object t = ret;
                        return t;
                    }
                }
                return null;
            }
            finally {
                this.updateSize();
            }
        }

        private void updateSize() {
            int newSize = (this.hasWildcard ? 1 : 0) + (this.metaMap != null ? this.metaMap.size() : 0) + (this.tagMap != null ? this.tagMap.size() : 0) + (this.damageMap != null ? this.damageMap.size() : 0);
            if (newSize != this.size) {
                ItemStackMap itemStackMap = ItemStackMap.this;
                itemStackMap.size = itemStackMap.size + (newSize - this.size);
                this.size = newSize;
            }
        }
    }

    private static class DetailIter<T>
    implements Iterator<Map.Entry<ItemStack, T>> {
        private final Item owner;
        private final DetailMap backing;
        @Nullable
        private final Iterator<Map.Entry<Integer, T>> damageIter;
        @Nullable
        private final Iterator<Map.Entry<NBTTagCompound, T>> tagIter;
        @Nullable
        private final Iterator<Map.Entry<StackMetaKey, T>> metaIter;
        private DetailIterState state = DetailIterState.NOT_STARTED;
        private boolean removed = false;

        private DetailIter(Map.Entry<Item, DetailMap> input) {
            this.owner = input.getKey();
            this.backing = input.getValue();
            this.damageIter = this.backing.damageMap != null ? this.backing.damageMap.entrySet().iterator() : null;
            this.tagIter = this.backing.tagMap != null ? this.backing.tagMap.entrySet().iterator() : null;
            this.metaIter = this.backing.metaMap != null ? this.backing.metaMap.entrySet().iterator() : null;
        }

        private DetailIterState nextState() {
            switch (this.state) {
                case NOT_STARTED: {
                    if (this.backing.hasWildcard) {
                        return DetailIterState.WILDCARD;
                    }
                }
                case WILDCARD: 
                case DAMAGE: {
                    if (this.damageIter != null && this.damageIter.hasNext()) {
                        return DetailIterState.DAMAGE;
                    }
                }
                case TAG: {
                    if (this.tagIter != null && this.tagIter.hasNext()) {
                        return DetailIterState.TAG;
                    }
                }
                case META: {
                    if (this.metaIter != null && this.metaIter.hasNext()) {
                        return DetailIterState.META;
                    }
                }
                case DONE: {
                    return DetailIterState.DONE;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.state));
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException("remove() called twice");
            }
            this.state.remove(this);
            this.removed = true;
        }

        @Override
        public boolean hasNext() {
            return this.nextState() != DetailIterState.DONE;
        }

        @Override
        public Map.Entry<ItemStack, T> next() {
            DetailIterState nextState = this.nextState();
            if (nextState == DetailIterState.DONE) {
                throw new NoSuchElementException();
            }
            this.state = nextState;
            this.removed = false;
            return nextState.get(this);
        }

        private static enum DetailIterState {
            NOT_STARTED{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on NOT_STARTED");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new IllegalStateException("next() never called");
                }
            }
            ,
            WILDCARD{

                @Override
                <T> Map.Entry<ItemStack, T> get(final DetailIter<T> iter) {
                    return new Map.Entry<ItemStack, T>(){
                        private final ItemStack key;
                        {
                            this.key = ItemStackMap.wildcard(iter.owner);
                        }

                        @Override
                        public ItemStack getKey() {
                            return this.key;
                        }

                        @Override
                        public T getValue() {
                            return iter.backing.wildcard;
                        }

                        @Override
                        public T setValue(T value) {
                            return iter.backing.wildcard = value;
                        }
                    };
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).backing.hasWildcard);
                    ((DetailIter)iter).backing.wildcard = null;
                    ((DetailIter)iter).backing.hasWildcard = false;
                }
            }
            ,
            DAMAGE{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    assert (((DetailIter)iter).damageIter != null);
                    Map.Entry entry = (Map.Entry)((DetailIter)iter).damageIter.next();
                    return new ItemStackEntry(InventoryUtils.newItemStack((Item)((DetailIter)iter).owner, (int)1, (int)((Integer)entry.getKey()), (NBTTagCompound)WILDCARD_TAG), entry);
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).damageIter != null);
                    ((DetailIter)iter).damageIter.remove();
                }
            }
            ,
            TAG{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    assert (((DetailIter)iter).tagIter != null);
                    Map.Entry entry = (Map.Entry)((DetailIter)iter).tagIter.next();
                    return new ItemStackEntry(InventoryUtils.newItemStack((Item)((DetailIter)iter).owner, (int)1, (int)Short.MAX_VALUE, (NBTTagCompound)((NBTTagCompound)entry.getKey())), entry);
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).tagIter != null);
                    ((DetailIter)iter).tagIter.remove();
                }
            }
            ,
            META{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    assert (((DetailIter)iter).metaIter != null);
                    Map.Entry entry = (Map.Entry)((DetailIter)iter).metaIter.next();
                    return new ItemStackEntry(InventoryUtils.newItemStack((Item)((DetailIter)iter).owner, (int)1, (int)((StackMetaKey)entry.getKey()).damage, (NBTTagCompound)((StackMetaKey)entry.getKey()).tag), entry);
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).metaIter != null);
                    ((DetailIter)iter).metaIter.remove();
                }
            }
            ,
            DONE{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on DONE");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call remove on DONE");
                }
            };


            abstract <T> Map.Entry<ItemStack, T> get(DetailIter<T> var1);

            abstract <T> void remove(DetailIter<T> var1);

            private static class ItemStackEntry<T>
            implements Map.Entry<ItemStack, T> {
                private final ItemStack key;
                private final Map.Entry<?, T> entry;

                public ItemStackEntry(ItemStack key, Map.Entry<?, T> entry) {
                    this.key = key;
                    this.entry = entry;
                }

                @Override
                public ItemStack getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.entry.getValue();
                }

                @Override
                public T setValue(T value) {
                    return this.entry.setValue(value);
                }
            }
        }
    }

    private static class StackMetaKey {
        public final int damage;
        public final NBTTagCompound tag;

        public StackMetaKey(int damage, NBTTagCompound tag) {
            this.damage = damage;
            this.tag = tag;
        }

        public StackMetaKey(ItemStack key) {
            this(InventoryUtils.actualDamage((ItemStack)key), key.field_77990_d);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.damage, this.tag});
        }

        public boolean equals(Object o) {
            if (!(o instanceof StackMetaKey)) {
                return false;
            }
            StackMetaKey t = (StackMetaKey)o;
            return this.damage == t.damage && com.google.common.base.Objects.equal((Object)this.tag, (Object)t.tag);
        }
    }
}

