/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core;

import com.mitchej123.hodgepodge.asm.References;
import com.mitchej123.hodgepodge.core.LoadingConfig;
import com.mitchej123.hodgepodge.core.util.ColorOverrideType;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.MinecraftForge;

public class HodgePodgeClient {
    public static Method colorGrass;
    public static Method colorLiquid;
    public static Method colorLeaves;
    public static Method colorFoliage;

    public static void postInit() {
        colorGrass = (Method)References.gt_PollutionRenderer.getMethod("colorGrass").resolve();
        colorLiquid = (Method)References.gt_PollutionRenderer.getMethod("colorLiquid").resolve();
        colorLeaves = (Method)References.gt_PollutionRenderer.getMethod("colorLeaves").resolve();
        colorFoliage = (Method)References.gt_PollutionRenderer.getMethod("colorFoliage").resolve();
        if (colorGrass != null) {
            LoadingConfig.postInitClient();
            MinecraftForge.EVENT_BUS.register((Object)LoadingConfig.standardBlocks);
            MinecraftForge.EVENT_BUS.register((Object)LoadingConfig.liquidBlocks);
            MinecraftForge.EVENT_BUS.register((Object)LoadingConfig.doublePlants);
            MinecraftForge.EVENT_BUS.register((Object)LoadingConfig.crossedSquares);
            MinecraftForge.EVENT_BUS.register((Object)LoadingConfig.blockVine);
        }
    }

    public static int renderStandardBlock_colorMultiplier(int oColor, Block block, int x, int z) {
        ColorOverrideType type = LoadingConfig.standardBlocks.matchesID(block);
        if (type == null) {
            return oColor;
        }
        return type.getColor(oColor, x, z);
    }

    public static int renderBlockLiquid_colorMultiplier(int oColor, Block block, int x, int z) {
        ColorOverrideType type = LoadingConfig.liquidBlocks.matchesID(block);
        if (type == null || block.field_149764_J != Material.field_151586_h) {
            return oColor;
        }
        return type.getColor(oColor, x, z);
    }

    public static int renderBlockDoublePlant_colorMultiplier(int oColor, Block block, int x, int z) {
        ColorOverrideType type = LoadingConfig.doublePlants.matchesID(block);
        if (type == null) {
            return oColor;
        }
        return type.getColor(oColor, x, z);
    }

    public static int renderCrossedSquares_colorMultiplier(int oColor, Block block, int x, int z) {
        ColorOverrideType type = LoadingConfig.crossedSquares.matchesID(block);
        if (type == null) {
            return oColor;
        }
        return type.getColor(oColor, x, z);
    }

    public static int renderBlockVine_colorMultiplier(int oColor, Block block, int x, int z) {
        ColorOverrideType type = LoadingConfig.blockVine.matchesID(block);
        if (type == null) {
            return oColor;
        }
        return type.getColor(oColor, x, z);
    }
}

