/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.util;

import com.google.common.collect.Iterators;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ItemStackMap<T>
extends AbstractMap<ItemStack, T> {
    private final HashMap<Item, DetailMap> itemMap = new HashMap();
    private int size;

    static ItemStack wildcard(Item item) {
        return new ItemStack(item, 1, Short.MAX_VALUE);
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map == null ? null : (T)map.get(stack);
    }

    @Override
    public T put(ItemStack key, T value) {
        if (key == null || key.func_77973_b() == null || value == null) {
            return null;
        }
        return this.itemMap.computeIfAbsent(key.func_77973_b(), k -> new DetailMap()).put(key, value);
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof ItemStack)) {
            return null;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return null;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map == null ? null : (T)map.remove(stack);
    }

    @Override
    public boolean containsKey(Object key) {
        if (!(key instanceof ItemStack)) {
            return false;
        }
        ItemStack stack = (ItemStack)key;
        if (stack.func_77973_b() == null) {
            return false;
        }
        DetailMap map = this.itemMap.get(stack.func_77973_b());
        return map != null && map.get(stack) != null;
    }

    @Override
    public void clear() {
        this.itemMap.clear();
        this.size = 0;
    }

    @Override
    @Nonnull
    public Set<Map.Entry<ItemStack, T>> entrySet() {
        return new SetView();
    }

    private class SetView
    extends AbstractSet<Map.Entry<ItemStack, T>> {
        private SetView() {
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return Objects.equals(ItemStackMap.this.get(entry.getKey()), entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<ItemStack, T> itemStackTEntry) {
            return itemStackTEntry.getKey() != null && itemStackTEntry.getValue() != null && ItemStackMap.this.put(itemStackTEntry.getKey(), itemStackTEntry.getValue()) == null;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            return ItemStackMap.this.remove(entry.getKey(), entry.getValue());
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<ItemStack, T>> iterator() {
            return Iterators.concat((Iterator)Iterators.transform(ItemStackMap.this.itemMap.entrySet().iterator(), x$0 -> new DetailIter((Map.Entry)x$0)));
        }

        @Override
        public int size() {
            return ItemStackMap.this.size;
        }
    }

    private class DetailMap {
        private boolean hasWildcard;
        private T wildcard;
        private HashMap<Integer, T> damageMap;
        private int size;

        private DetailMap() {
        }

        public T get(ItemStack key) {
            Object ret;
            if (this.wildcard != null) {
                return this.wildcard;
            }
            if (this.damageMap != null && (ret = this.damageMap.get(key.func_77960_j())) != null) {
                return ret;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T put(ItemStack key, T value) {
            try {
                if (key.func_77960_j() == Short.MAX_VALUE) {
                    Object ret = this.wildcard;
                    this.wildcard = value;
                    this.hasWildcard = true;
                    Object t = ret;
                    return t;
                }
                if (this.damageMap == null) {
                    this.damageMap = new HashMap();
                }
                Object t = this.damageMap.put(key.func_77960_j(), value);
                return t;
            }
            finally {
                this.updateSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T remove(ItemStack key) {
            try {
                if (key.func_77960_j() == Short.MAX_VALUE) {
                    Object ret = this.wildcard;
                    this.wildcard = null;
                    this.hasWildcard = false;
                    Object t = ret;
                    return t;
                }
                Object t = this.damageMap != null ? (Object)this.damageMap.remove(key.func_77960_j()) : null;
                return t;
            }
            finally {
                this.updateSize();
            }
        }

        private void updateSize() {
            int newSize = (this.hasWildcard ? 1 : 0) + (this.damageMap != null ? this.damageMap.size() : 0);
            if (newSize != this.size) {
                ItemStackMap itemStackMap = ItemStackMap.this;
                itemStackMap.size = itemStackMap.size + (newSize - this.size);
                this.size = newSize;
            }
        }
    }

    private static class DetailIter<T>
    implements Iterator<Map.Entry<ItemStack, T>> {
        private final Item owner;
        private final DetailMap backing;
        @Nullable
        private final Iterator<Map.Entry<Integer, T>> damageIter;
        private DetailIterState state = DetailIterState.NOT_STARTED;
        private boolean removed = false;

        private DetailIter(Map.Entry<Item, DetailMap> input) {
            this.owner = input.getKey();
            this.backing = input.getValue();
            this.damageIter = this.backing.damageMap != null ? this.backing.damageMap.entrySet().iterator() : null;
        }

        private DetailIterState nextState() {
            switch (this.state) {
                case NOT_STARTED: {
                    if (this.backing.hasWildcard) {
                        return DetailIterState.WILDCARD;
                    }
                }
                case WILDCARD: 
                case DAMAGE: {
                    if (this.damageIter != null && this.damageIter.hasNext()) {
                        return DetailIterState.DAMAGE;
                    }
                }
                case DONE: {
                    return DetailIterState.DONE;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.state));
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException("remove() called twice");
            }
            this.state.remove(this);
            this.removed = true;
        }

        @Override
        public boolean hasNext() {
            return this.nextState() != DetailIterState.DONE;
        }

        @Override
        public Map.Entry<ItemStack, T> next() {
            DetailIterState nextState = this.nextState();
            if (nextState == DetailIterState.DONE) {
                throw new NoSuchElementException();
            }
            this.state = nextState;
            this.removed = false;
            return nextState.get(this);
        }

        private static enum DetailIterState {
            NOT_STARTED{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on NOT_STARTED");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new IllegalStateException("next() never called");
                }
            }
            ,
            WILDCARD{

                @Override
                <T> Map.Entry<ItemStack, T> get(final DetailIter<T> iter) {
                    return new Map.Entry<ItemStack, T>(){
                        private final ItemStack key;
                        {
                            this.key = ItemStackMap.wildcard(iter.owner);
                        }

                        @Override
                        public ItemStack getKey() {
                            return this.key;
                        }

                        @Override
                        public T getValue() {
                            return iter.backing.wildcard;
                        }

                        @Override
                        public T setValue(T value) {
                            return iter.backing.wildcard = value;
                        }
                    };
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).backing.hasWildcard);
                    ((DetailIter)iter).backing.wildcard = null;
                    ((DetailIter)iter).backing.hasWildcard = false;
                }
            }
            ,
            DAMAGE{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    assert (((DetailIter)iter).damageIter != null);
                    Map.Entry entry = (Map.Entry)((DetailIter)iter).damageIter.next();
                    return new ItemStackEntry(new ItemStack(((DetailIter)iter).owner, 1, ((Integer)entry.getKey()).intValue()), entry);
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    assert (((DetailIter)iter).damageIter != null);
                    ((DetailIter)iter).damageIter.remove();
                }
            }
            ,
            DONE{

                @Override
                <T> Map.Entry<ItemStack, T> get(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call get on DONE");
                }

                @Override
                <T> void remove(DetailIter<T> iter) {
                    throw new AssertionError((Object)"Should not call remove on DONE");
                }
            };


            abstract <T> Map.Entry<ItemStack, T> get(DetailIter<T> var1);

            abstract <T> void remove(DetailIter<T> var1);

            private static class ItemStackEntry<T>
            implements Map.Entry<ItemStack, T> {
                private final ItemStack key;
                private final Map.Entry<?, T> entry;

                public ItemStackEntry(ItemStack key, Map.Entry<?, T> entry) {
                    this.key = key;
                    this.entry = entry;
                }

                @Override
                public ItemStack getKey() {
                    return this.key;
                }

                @Override
                public T getValue() {
                    return this.entry.getValue();
                }

                @Override
                public T setValue(T value) {
                    return this.entry.setValue(value);
                }
            }
        }
    }
}

