/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.minecraft;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockHopper.class})
public class MixinBlockHopper
extends Block {
    @Unique
    private static final EnumMap<EnumFacing, List<AxisAlignedBB>> bounds;

    protected MixinBlockHopper(Material p_i45394_1_) {
        super(p_i45394_1_);
    }

    private static AxisAlignedBB makeAABB(int fromX, int fromY, int fromZ, int toX, int toY, int toZ) {
        return AxisAlignedBB.func_72330_a((double)((float)fromX / 16.0f), (double)((float)fromY / 16.0f), (double)((float)fromZ / 16.0f), (double)((float)toX / 16.0f), (double)((float)toY / 16.0f), (double)((float)toZ / 16.0f));
    }

    private static MovingObjectPosition rayTrace(Vec3 pos, Vec3 start, Vec3 end, AxisAlignedBB boundingBox) {
        Vec3 vec3d1;
        Vec3 vec3d = start.func_72441_c(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c);
        MovingObjectPosition raytraceresult = boundingBox.func_72327_a(vec3d, vec3d1 = end.func_72441_c(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c));
        if (raytraceresult == null) {
            return null;
        }
        Vec3 res = raytraceresult.field_72307_f.func_72441_c(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        return new MovingObjectPosition((int)res.field_72450_a, (int)res.field_72448_b, (int)res.field_72449_c, raytraceresult.field_72310_e, pos);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        EnumFacing facing = EnumFacing.values()[BlockHopper.func_149918_b((int)world.func_72805_g(x, y, z))];
        List<AxisAlignedBB> list = bounds.get(facing);
        if (list == null) {
            return super.func_149731_a(world, x, y, z, start, end);
        }
        return list.stream().map(bb -> MixinBlockHopper.rayTrace(pos, start, end, bb)).anyMatch(Objects::nonNull) ? super.func_149731_a(world, x, y, z, start, end) : null;
    }

    private static /* synthetic */ List lambda$static$2(List commonBounds, EnumFacing a) {
        return new ArrayList(commonBounds);
    }

    static {
        ImmutableList commonBounds = ImmutableList.of((Object)MixinBlockHopper.makeAABB(0, 10, 0, 16, 16, 16), (Object)MixinBlockHopper.makeAABB(4, 4, 4, 12, 10, 12));
        bounds = Stream.of(EnumFacing.values()).filter(t -> t != EnumFacing.UP).collect(Collectors.toMap(a -> a, arg_0 -> MixinBlockHopper.lambda$static$2((List)commonBounds, arg_0), (u, v) -> {
            throw new IllegalStateException();
        }, () -> new EnumMap(EnumFacing.class)));
        bounds.get(EnumFacing.DOWN).add(MixinBlockHopper.makeAABB(6, 0, 6, 10, 4, 10));
        bounds.get(EnumFacing.NORTH).add(MixinBlockHopper.makeAABB(6, 4, 0, 10, 8, 4));
        bounds.get(EnumFacing.SOUTH).add(MixinBlockHopper.makeAABB(6, 4, 12, 10, 8, 16));
        bounds.get(EnumFacing.WEST).add(MixinBlockHopper.makeAABB(0, 4, 6, 4, 8, 10));
        bounds.get(EnumFacing.EAST).add(MixinBlockHopper.makeAABB(12, 4, 6, 16, 8, 10));
    }
}

