/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm;

import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"com.mitchej123.hodgepodge.asm", "optifine"})
@IFMLLoadingPlugin.SortingIndex(value=1002)
@IFMLLoadingPlugin.DependsOn(value={"cofh.asm.LoadingPlugin"})
public class HodgePodgeASMLoader
implements IFMLLoadingPlugin {
    private static final Logger log = LogManager.getLogger((String)"Hodgepodge");
    public static final IFMLLoadingPlugin.SortingIndex index = HodgePodgeASMLoader.class.getAnnotation(IFMLLoadingPlugin.SortingIndex.class);

    public static int getSortingIndex() {
        return index != null ? index.value() : 0;
    }

    public String[] getASMTransformerClass() {
        return (String[])Arrays.stream(AsmTransformers.values()).map(asmTransformer -> {
            if (asmTransformer.shouldBeLoaded()) {
                log.info("Loading hodgepodge transformers {}", new Object[]{((AsmTransformers)asmTransformer).name});
                return ((AsmTransformers)asmTransformer).asmTransformers;
            }
            return null;
        }).filter(Objects::nonNull).flatMap(Collection::stream).toArray(String[]::new);
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public static enum AsmTransformers {
        POLLUTION_TRANSFORMER("Pollution Transformer", () -> Common.config.pollutionAsm, Collections.singletonList("com.mitchej123.hodgepodge.asm.PollutionClassTransformer")),
        CoFHWorldTransformer("World Transformer - Remove CoFH tile entity cache", () -> Common.config.cofhWorldTransformer, Collections.singletonList("com.mitchej123.hodgepodge.asm.WorldTransformer")),
        SpeedupProgressBar("Speed up Progress Bar by speeding up stripSpecialCharacters", () -> Common.config.speedupProgressBar, Collections.singletonList("com.mitchej123.hodgepodge.asm.SpeedupProgressBarTransformer")),
        FIX_TINKER_POTION_EFFECT_OFFSET("Prevents the inventory from shifting when the player has active potion effects", () -> Common.config.fixPotionRenderOffset, Collections.singletonList("com.mitchej123.hodgepodge.asm.transformers.tconstruct.TabRegistryTransformer")),
        THERMOS_SLEDGEHAMMER_FURNACE_FIX("Take a sledgehammer to CraftServer.resetRecipes() to prevent it from breaking our Furnace Fix", () -> Common.thermosTainted && Common.config.speedupVanillaFurnace, Collections.singletonList("com.mitchej123.hodgepodge.asm.ThermosFurnaceSledgeHammer")),
        BIBLIOCRAFT_RECIPE_SLEDGEHAMMER("Remove recipes from Bibliocraft BlockLoader and Itemloader : addRecipies()", () -> Common.config.biblocraftRecipes, Collections.singletonList("com.mitchej123.hodgepodge.asm.BibliocraftTransformer"));

        private final String name;
        private final Supplier<Boolean> applyIf;
        private final List<String> asmTransformers;

        private AsmTransformers(String name, Supplier<Boolean> applyIf, List<String> asmTransformers) {
            this.name = name;
            this.applyIf = applyIf;
            this.asmTransformers = asmTransformers;
        }

        public boolean shouldBeLoaded() {
            return this.applyIf.get();
        }
    }
}

