/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.core.util;

public class ManagedEnum<T extends Enum<?>> {
    private final T[] allValues;
    private T value;

    public ManagedEnum(T initialValue) {
        if (initialValue == null) {
            throw new IllegalArgumentException();
        }
        this.value = initialValue;
        Enum[] allValues = (Enum[])this.value.getClass().getEnumConstants();
        this.allValues = allValues;
    }

    public boolean is(T value) {
        return this.value == value;
    }

    public T next() {
        this.value = this.allValues[(((Enum)this.value).ordinal() + 1) % this.allValues.length];
        return this.value;
    }

    public void set(T value) {
        this.value = value;
    }

    public void set(int ordinal) {
        this.value = this.allValues[Math.min(Math.max(0, ordinal), this.allValues.length - 1)];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManagedEnum that = (ManagedEnum)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return ((Enum)this.value).hashCode();
    }

    public String toString() {
        return ((Enum)this.value).toString();
    }
}

