/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.biomesoplenty;

import biomesoplenty.client.fog.FogHandler;
import biomesoplenty.client.fog.IBiomeFog;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FogHandler.class})
public class MixinFogHandler {
    @Shadow(remap=false)
    private static double fogX;
    @Shadow(remap=false)
    private static double fogZ;
    @Shadow(remap=false)
    private static boolean fogInit;
    @Shadow(remap=false)
    private static float fogFarPlaneDistance;
    private static float farPlaneDistanceScale;
    private static float farPlaneDistanceM;
    private static AtomicInteger ticks;

    @Overwrite(remap=false)
    @SubscribeEvent
    public void onRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        EntityLivingBase entity = event.entity;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        if ((double)playerX == fogX && (double)playerZ == fogZ && fogInit) {
            MixinFogHandler.renderFog(event.fogMode, fogFarPlaneDistance, 0.75f);
        }
        farPlaneDistanceM = event.farPlaneDistance;
        if (ticks.get() < -50) {
            new ClientTickThread().start();
            ticks.set(0);
        }
        if (Math.random() < 0.1) {
            ticks.incrementAndGet();
        }
        MixinFogHandler.renderFog(event.fogMode, fogFarPlaneDistance, farPlaneDistanceScale);
    }

    @Shadow(remap=false)
    private static void renderFog(int fogMode, float farPlaneDistance, float farPlaneDistanceScale) {
    }

    static {
        farPlaneDistanceScale = 0.75f;
        ticks = new AtomicInteger(-100);
    }

    private class ClientTickThread
    extends Thread {
        private ClientTickThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (Minecraft.func_71410_x().field_71441_e == null) {
                    ticks.set(0);
                    try {
                        ClientTickThread.sleep(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ticks.get() > 0) {
                    try {
                        int distance = 20;
                        float fpDistanceBiomeFog = 0.0f;
                        float weightBiomeFog = 0.0f;
                        for (int x = -distance; x <= distance; ++x) {
                            for (int z = -distance; z <= distance; ++z) {
                                double zDiff;
                                double xDiff;
                                EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
                                int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
                                int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
                                int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
                                BiomeGenBase biome = Minecraft.func_71410_x().field_71441_e.func_72807_a(playerX + x, playerZ + z);
                                if (!(biome instanceof IBiomeFog)) continue;
                                float distancePart = ((IBiomeFog)biome).getFogDensity(playerX + x, playerY, playerZ + z);
                                float weightPart = 1.0f;
                                if (x == -distance) {
                                    xDiff = 1.0 - (player.field_70165_t - (double)playerX);
                                    distancePart = (float)((double)distancePart * xDiff);
                                    weightPart = (float)((double)weightPart * xDiff);
                                } else if (x == distance) {
                                    xDiff = player.field_70165_t - (double)playerX;
                                    distancePart = (float)((double)distancePart * xDiff);
                                    weightPart = (float)((double)weightPart * xDiff);
                                }
                                if (z == -distance) {
                                    zDiff = 1.0 - (player.field_70161_v - (double)playerZ);
                                    distancePart = (float)((double)distancePart * zDiff);
                                    weightPart = (float)((double)weightPart * zDiff);
                                } else if (z == distance) {
                                    zDiff = player.field_70161_v - (double)playerZ;
                                    distancePart = (float)((double)distancePart * zDiff);
                                    weightPart = (float)((double)weightPart * zDiff);
                                }
                                fpDistanceBiomeFog += distancePart;
                                weightBiomeFog += weightPart;
                            }
                        }
                        float weightMixed = (float)(distance * distance) * 4.0f;
                        float weightDefault = weightMixed - weightBiomeFog;
                        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
                        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + farPlaneDistanceM * weightDefault) / weightMixed;
                        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
                        fogX = Minecraft.func_71410_x().field_71439_g.field_70165_t;
                        fogZ = Minecraft.func_71410_x().field_71439_g.field_70161_v;
                        farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / weightMixed;
                        fogFarPlaneDistance = Math.min(farPlaneDistance, farPlaneDistanceM);
                        fogInit = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ticks.decrementAndGet();
                    continue;
                }
                try {
                    ClientTickThread.sleep(1000L);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

