/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.client;

import biomesoplenty.common.eventhandler.client.gui.WorldTypeMessageEventHandler;
import com.mitchej123.hodgepodge.Common;
import com.mitchej123.hodgepodge.Compat;
import com.mitchej123.hodgepodge.client.ClientTicker;
import com.mitchej123.hodgepodge.client.DebugScreenHandler;
import com.mitchej123.hodgepodge.client.PollutionTooltip;
import com.mitchej123.hodgepodge.client.handlers.ClientKeyListener;
import com.mitchej123.hodgepodge.util.ManagedEnum;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import java.util.Collections;
import net.minecraftforge.common.MinecraftForge;

public class HodgepodgeClient {
    public static final ManagedEnum<AnimationMode> animationsMode = new ManagedEnum<AnimationMode>(AnimationMode.VISIBLE_ONLY);
    public static final ManagedEnum<RenderDebugMode> renderDebugMode = new ManagedEnum<RenderDebugMode>(RenderDebugMode.REDUCED);

    public static void preInit() {
        if (Compat.isGT5Present()) {
            MinecraftForge.EVENT_BUS.register((Object)PollutionTooltip.INSTANCE);
        }
    }

    public static void postInit() {
        if (Common.config.renderDebug) {
            renderDebugMode.set(Common.config.renderDebugMode);
        } else {
            renderDebugMode.set(RenderDebugMode.OFF);
        }
        if (Common.config.enableDefaultLanPort && (Common.config.defaultLanPort < 0 || Common.config.defaultLanPort > 65535)) {
            Common.log.error(String.format("Default LAN port number must be in range of 0-65535, but %s was given. Defaulting to 0.", Common.config.defaultLanPort));
            Common.config.defaultLanPort = 0;
        }
        if (Compat.isGT5Present()) {
            Common.config.postInitClient();
            MinecraftForge.EVENT_BUS.register((Object)Common.config.standardBlocks);
            MinecraftForge.EVENT_BUS.register((Object)Common.config.liquidBlocks);
            MinecraftForge.EVENT_BUS.register((Object)Common.config.doublePlants);
            MinecraftForge.EVENT_BUS.register((Object)Common.config.crossedSquares);
            MinecraftForge.EVENT_BUS.register((Object)Common.config.blockVine);
        }
        FMLCommonHandler.instance().bus().register((Object)ClientTicker.INSTANCE);
        if (Common.config.addSystemInfo) {
            MinecraftForge.EVENT_BUS.register((Object)DebugScreenHandler.INSTANCE);
        }
        if (Common.config.speedupAnimations) {
            FMLCommonHandler.instance().bus().register((Object)new ClientKeyListener());
        }
        if (Compat.isIC2CropPluginPresent()) {
            ModMetadata meta = ((ModContainer)Loader.instance().getIndexedModList().get("Ic2Nei")).getMetadata();
            meta.authorList = Collections.singletonList("Speiger");
            meta.description = "This IC2 Addon allows you to simulate the CropBreeding.";
            meta.autogenerated = false;
        }
        if (Compat.isBiomesOPlentyPresent() && (Compat.isDreamcraftPresent() || Common.config.removeBOPWarning)) {
            MinecraftForge.EVENT_BUS.unregister((Object)WorldTypeMessageEventHandler.instance);
        }
    }

    public static enum RenderDebugMode {
        OFF,
        REDUCED,
        FULL;

    }

    public static enum AnimationMode {
        NONE,
        VISIBLE_ONLY,
        ALL;

    }
}

