/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.rfb;

import com.gtnewhorizons.retrofuturabootstrap.api.ClassNodeHandle;
import com.gtnewhorizons.retrofuturabootstrap.api.ExtensibleClassLoader;
import com.gtnewhorizons.retrofuturabootstrap.api.RfbClassTransformer;
import com.mitchej123.hodgepodge.asm.EarlyConfig;
import java.util.jar.Manifest;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ForgeConfigurationTransformer
implements RfbClassTransformer {
    private static final String EARLY_HOOKS_INTERNAL = "com/mitchej123/hodgepodge/asm/hooks/early/EarlyASMCallHooks";
    private static final String CATEGORY_INTERNAL = "net/minecraftforge/common/config/ConfigCategory";
    private static final String PROPERTY_INTERNAL = "net/minecraftforge/common/config/Property";
    private static final String OPEN_MAP_INTERNAL = "it/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap";

    @Pattern(value="[a-z0-9-]+")
    @NotNull
    public String id() {
        return "forge-configuration";
    }

    public boolean shouldTransformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        return !EarlyConfig.noLeanerForgeConfiguration && classNode.isPresent() && (className.equals("net.minecraftforge.common.config.Property") || className.equals("net.minecraftforge.common.config.ConfigCategory"));
    }

    public void transformClass(@NotNull ExtensibleClassLoader classLoader, @NotNull RfbClassTransformer.Context context, @Nullable Manifest manifest, @NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return;
        }
        if (cn.methods == null) {
            return;
        }
        for (MethodNode mn : cn.methods) {
            if (mn.instructions == null || mn.instructions.size() == 0) continue;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                MethodInsnNode intern;
                AbstractInsnNode aInsn = mn.instructions.get(i);
                if (aInsn.getOpcode() == 184 && aInsn instanceof MethodInsnNode) {
                    MethodInsnNode mInsn = (MethodInsnNode)aInsn;
                    if ("java/lang/String".equals(mInsn.owner) && "valueOf".equals(mInsn.name) && "(I)Ljava/lang/String;".equals(mInsn.desc) || "java/lang/Integer".equals(mInsn.owner) && "toString".equals(mInsn.name) && "(I)Ljava/lang/String;".equals(mInsn.desc)) {
                        mInsn.owner = EARLY_HOOKS_INTERNAL;
                        mInsn.name = "intToCachedString";
                        continue;
                    }
                    if ((!"java/lang/String".equals(mInsn.owner) || !"valueOf".equals(mInsn.name) || !"(D)Ljava/lang/String;".equals(mInsn.desc)) && (!"java/lang/Double".equals(mInsn.owner) || !"toString".equals(mInsn.name) || !"(D)Ljava/lang/String;".equals(mInsn.desc))) continue;
                    mInsn.owner = EARLY_HOOKS_INTERNAL;
                    mInsn.name = "doubleToCachedString";
                    continue;
                }
                if (aInsn.getOpcode() != 181 || !(aInsn instanceof FieldInsnNode)) continue;
                FieldInsnNode fInsn = (FieldInsnNode)aInsn;
                if (PROPERTY_INTERNAL.equals(fInsn.owner) && ("value".equals(fInsn.name) || "defaultValue".equals(fInsn.name))) {
                    intern = new MethodInsnNode(182, "java/lang/String", "intern", "()Ljava/lang/String;", false);
                    mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)intern);
                    ++i;
                    continue;
                }
                if (PROPERTY_INTERNAL.equals(fInsn.owner) && ("values".equals(fInsn.name) || "defaultValues".equals(fInsn.name) || "validValues".equals(fInsn.name))) {
                    intern = new MethodInsnNode(184, EARLY_HOOKS_INTERNAL, "internArray", "([Ljava/lang/String;)[Ljava/lang/String;", false);
                    mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)intern);
                    ++i;
                    continue;
                }
                if (!CATEGORY_INTERNAL.equals(fInsn.owner) || !"properties".equals(fInsn.name) || !"<init>".equals(mn.name)) continue;
                mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new InsnNode(87));
                mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new TypeInsnNode(187, OPEN_MAP_INTERNAL));
                mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new InsnNode(89));
                mn.instructions.insertBefore((AbstractInsnNode)fInsn, (AbstractInsnNode)new MethodInsnNode(183, OPEN_MAP_INTERNAL, "<init>", "()V", false));
                i += 4;
            }
        }
    }
}

