/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.transformers.early;

import com.mitchej123.hodgepodge.asm.EarlyConfig;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class EarlyClassTransformer
implements IClassTransformer {
    private static final String EARLY_HOOKS_INTERNAL = "com/mitchej123/hodgepodge/asm/hooks/early/EarlyASMCallHooks";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null || name == null) {
            return basicClass;
        }
        if (name.equals("cpw.mods.fml.common.ModContainerFactory")) {
            if (EarlyConfig.noNukeBaseMod) {
                return basicClass;
            }
            return EarlyClassTransformer.transformModContainerFactory(basicClass);
        }
        return basicClass;
    }

    private static byte[] transformModContainerFactory(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(0);
        ClassVisitor cv = new ClassVisitor(327680, (ClassVisitor)cw){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                if ("modClass".equals(name)) {
                    return null;
                }
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                switch (name) {
                    case "build": {
                        mv.visitVarInsn(25, 1);
                        mv.visitVarInsn(25, 2);
                        mv.visitVarInsn(25, 3);
                        mv.visitMethodInsn(184, EarlyClassTransformer.EARLY_HOOKS_INTERNAL, "build", "(Lcpw/mods/fml/common/discovery/asm/ASMModParser;Ljava/io/File;Lcpw/mods/fml/common/discovery/ModCandidate;)Lcpw/mods/fml/common/ModContainer;", false);
                        mv.visitInsn(176);
                        mv.visitMaxs(3, 4);
                        mv.visitEnd();
                        return null;
                    }
                    case "<clinit>": {
                        mv = new MethodVisitor(327680, mv){

                            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                                if (name.equals("modClass")) {
                                    super.visitInsn(87);
                                } else {
                                    super.visitFieldInsn(opcode, owner, name, desc);
                                }
                            }
                        };
                    }
                }
                return mv;
            }
        };
        cr.accept(cv, 0);
        return cw.toByteArray();
    }

    static {
        EarlyConfig.ensureLoaded();
    }
}

