/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.util;

import com.mitchej123.hodgepodge.mixins.interfaces.HasID;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EmbeddedObjectIntMap<K>
extends IdentityHashMap<K, Integer> {
    private final Reference2IntMap<K> forwardMap;
    private Class<?> type = null;
    private boolean useEmbed = true;

    public EmbeddedObjectIntMap(int expectedMaxSize) {
        super(0);
        this.forwardMap = new Reference2IntOpenHashMap(expectedMaxSize);
        this.forwardMap.defaultReturnValue(-1);
    }

    public void setEmbed(boolean useEmbed) {
        this.useEmbed = useEmbed;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    @Deprecated
    public Integer put(K key, Integer value) {
        int ret = this.put(key, (int)value);
        return ret == -1 ? null : Integer.valueOf(ret);
    }

    @Override
    public int put(K key, int value) {
        Class<?> keyClass = key.getClass();
        if (this.type != null && !this.type.isAssignableFrom(keyClass)) {
            throw new ClassCastException("Expected a " + this.type.getName() + " but got a " + keyClass.getName());
        }
        if (key instanceof HasID) {
            HasID idHaver = (HasID)key;
            idHaver.hodgepodge$setID(value);
        }
        return this.forwardMap.put(key, value);
    }

    @Override
    public Integer get(Object key) {
        int value = this.getInt(key);
        return value == -1 ? null : Integer.valueOf(value);
    }

    public int getInt(Object key) {
        if (key == null) {
            return -1;
        }
        Class<?> keyClass = key.getClass();
        if (this.type != null && !this.type.isAssignableFrom(keyClass)) {
            return -1;
        }
        if (this.useEmbed && key instanceof HasID) {
            HasID idHaver = (HasID)key;
            return idHaver.hodgepodge$getID();
        }
        return this.forwardMap.getInt(key);
    }

    @Override
    public Integer getOrDefault(Object key, Integer defaultValue) {
        return this.containsKey(key) ? this.forwardMap.getInt(key) : defaultValue.intValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forwardMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            return this.forwardMap.containsValue(intValue.intValue());
        }
        return false;
    }

    @Override
    public Integer remove(Object key) {
        if (key instanceof HasID) {
            HasID idHaver = (HasID)key;
            idHaver.hodgepodge$setID(-1);
        }
        return this.forwardMap.removeInt(key);
    }

    @Override
    public void clear() {
        this.forwardMap.forEach((k, v) -> {
            if (k instanceof HasID) {
                HasID idHaver = (HasID)k;
                idHaver.hodgepodge$setID(-1);
            }
        });
        this.forwardMap.clear();
    }

    @Override
    public int size() {
        return this.forwardMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.forwardMap.isEmpty();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.forwardMap.keySet();
    }

    @Override
    @NotNull
    public Collection<Integer> values() {
        return this.forwardMap.values();
    }

    @Override
    @Deprecated
    @NotNull
    public Set<Map.Entry<K, Integer>> entrySet() {
        return this.forwardMap.entrySet();
    }
}

