/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.SearchField;
import codechicken.nei.api.ItemFilter;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.api.IHoloGlasses;
import net.dries007.holoInventory.client.ClientHandler;
import net.dries007.holoInventory.items.HoloGlasses;
import net.dries007.holoInventory.network.EntityRequestMessage;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.NamedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private static final DecimalFormat DF_ONE_FRACTION_DIGIT = new DecimalFormat("##.0");
    private static final DecimalFormat DF_TWO_FRACTION_DIGIT = new DecimalFormat("#.00");
    static int stackSizeDebugOverride = 0;
    private static final String[] suffixNormal = new String[]{"", "K", "M", "B"};
    private static final String[] suffixDarkened = new String[]{"", EnumChatFormatting.GRAY + "K", EnumChatFormatting.GRAY + "M", EnumChatFormatting.GRAY + "B"};
    private static final int TEXTCOLOR = -1426063361;
    public static final HashMap<Integer, NamedData<ItemStack[]>> tileMap = new HashMap();
    public static final HashMap<Integer, NamedData<ItemStack[]>> entityMap = new HashMap();
    public static final HashMap<Integer, NamedData<MerchantRecipeList>> merchantMap = new HashMap();
    public static final HashMap<Integer, Long> requestMap = new HashMap();
    private final EntityItem customitem;
    private Coord coord;
    public boolean enabled;
    private static double renderPosX;
    private static double renderPosY;
    private static double renderPosZ;
    public static final Renderer INSTANCE;
    private float timeD;
    private float blockScale;
    private float maxWith;
    private float maxHeight;
    private int maxColumns;
    private int maxRows;
    private boolean renderText;
    ItemFilter cachedFilter;
    String cachedSearch;

    private Renderer() {
        this.customitem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        this.enabled = true;
        this.cachedFilter = null;
        this.cachedSearch = "";
        this.customitem.field_70290_d = 0.0f;
    }

    @SubscribeEvent
    public void renderEvent(RenderWorldLastEvent event) {
        if (!this.enabled) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        ItemStack glasses = HoloGlasses.getHoloGlasses((World)world, (EntityPlayer)player);
        try {
            if (glasses != null && ((IHoloGlasses)glasses.func_77973_b()).shouldRender(glasses)) {
                this.doEvent(event.partialTicks);
            }
        }
        catch (Exception e) {
            HoloInventory.getLogger().warn("Some error while rendering the hologram :(");
            HoloInventory.getLogger().warn("Please make an issue on github if this happens");
            e.printStackTrace();
        }
    }

    private void doEvent(float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71446_o == null || RenderManager.field_78727_a == null || RenderManager.field_78727_a.func_78716_a() == null || mc.field_71474_y.field_74320_O != 0 || mc.field_71476_x == null) {
            return;
        }
        this.coord = new Coord(mc.field_71441_e.field_73011_w.field_76574_g, mc.field_71476_x);
        switch (mc.field_71476_x.field_72313_a) {
            case BLOCK: {
                TileEntity te = mc.field_71441_e.func_147438_o((int)this.coord.x, (int)this.coord.y, (int)this.coord.z);
                if (Helper.weWant(te)) {
                    String clazz = te.getClass().getCanonicalName();
                    if (Config.bannedTiles.contains(clazz)) {
                        return;
                    }
                    NamedData<ItemStack[]> data = tileMap.get(this.coord.hashCode());
                    if (data == null) break;
                    if (data.clazz == null || data.clazz.equals(clazz)) {
                        this.coord.x += 0.5;
                        this.coord.y += 0.5;
                        this.coord.z += 0.5;
                        Renderer.setRenderPos(partialTicks);
                        this.renderHologram(data);
                        break;
                    }
                    tileMap.remove(this.coord.hashCode());
                    break;
                }
                tileMap.remove(this.coord.hashCode());
                break;
            }
            case ENTITY: {
                Entity entity;
                if (!Config.enableEntities || !Helper.weWant(entity = mc.field_71476_x.field_72308_g)) break;
                if (Config.bannedEntities.contains(entity.getClass().getCanonicalName())) {
                    return;
                }
                int id = entity.func_145782_y();
                if (!requestMap.containsKey(id)) {
                    HoloInventory.getSnw().sendToServer((IMessage)new EntityRequestMessage(mc.field_71441_e.field_73011_w.field_76574_g, id));
                    requestMap.put(id, mc.field_71441_e.func_82737_E());
                } else if (mc.field_71441_e.func_82737_E() > requestMap.get(id) + 20L * (long)Config.syncFreq) {
                    requestMap.remove(id);
                }
                Renderer.setRenderPos(partialTicks);
                if (entity instanceof IInventory && entityMap.containsKey(id)) {
                    this.renderHologram(entityMap.get(id));
                }
                if (!(entity instanceof IMerchant) || !merchantMap.containsKey(id)) break;
                this.renderMerchant(merchantMap.get(id));
            }
        }
    }

    private void renderMerchant(NamedData<MerchantRecipeList> namedData) {
        this.coord.y += 2.0;
        if (((MerchantRecipeList)namedData.data).size() == 0) {
            return;
        }
        double distance = this.distance();
        if (distance < 1.0) {
            return;
        }
        GL11.glPushMatrix();
        this.moveAndRotate(-0.25);
        double uiScaleFactor = Config.renderScaling;
        if (uiScaleFactor < 0.1) {
            uiScaleFactor = 0.1;
        }
        GL11.glScaled((double)uiScaleFactor, (double)uiScaleFactor, (double)uiScaleFactor);
        this.timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        this.maxColumns = 3;
        this.maxRows = ((MerchantRecipeList)namedData.data).size();
        this.blockScale = this.getBlockScaleModifier(this.maxColumns) + (float)((double)0.1f * distance);
        this.maxWith = (float)this.maxColumns * this.blockScale * 0.7f * 0.4f;
        this.maxHeight = (float)this.maxRows * this.blockScale * 0.7f * 0.4f;
        this.renderText = true;
        if (Config.colorEnable) {
            this.renderBG();
        }
        if (Config.renderName) {
            this.renderName(namedData.name);
        }
        float stackSpacing = 0.6f;
        for (int row = 0; row < ((MerchantRecipeList)namedData.data).size(); ++row) {
            MerchantRecipe recipe = (MerchantRecipe)((MerchantRecipeList)namedData.data).get(row);
            this.renderItem(recipe.func_77394_a(), 0, row, recipe.func_77394_a().field_77994_a, stackSpacing);
            if (recipe.func_77398_c()) {
                this.renderItem(recipe.func_77396_b(), 1, row, recipe.func_77396_b().field_77994_a, stackSpacing);
            }
            this.renderItem(recipe.func_77397_d(), 2, row, recipe.func_77397_d().field_77994_a, stackSpacing);
        }
        GL11.glPopMatrix();
    }

    private ItemFilter getFilter(String s_filter) {
        this.cachedSearch = s_filter;
        LinkedList<ItemFilter> primary = new LinkedList<ItemFilter>();
        LinkedList secondary = new LinkedList();
        for (SearchField.ISearchProvider p : SearchField.searchProviders) {
            ItemFilter filter = p.getFilter(s_filter);
            if (filter == null) continue;
            (p.isPrimary() ? primary : secondary).add(filter);
        }
        if (!primary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(primary);
        }
        if (!secondary.isEmpty()) {
            return new ItemList.AnyMultiItemFilter(secondary);
        }
        return new ItemList.EverythingItemFilter();
    }

    private List<ItemStack> filterByNEI(ItemStack[] items) {
        try {
            if (Config.hideItemsNotSelected && Loader.isModLoaded((String)"NotEnoughItems") && SearchField.searchInventories()) {
                String searchString = NEIClientConfig.getSearchExpression().toLowerCase();
                if (!this.cachedSearch.equals(searchString) || this.cachedFilter == null) {
                    this.cachedFilter = this.getFilter(searchString);
                }
                return Arrays.stream(items).filter(s -> this.cachedFilter.matches(s)).collect(Collectors.toList());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Arrays.asList(items);
    }

    private void renderHologram(NamedData<ItemStack[]> namedData) {
        if (namedData.data == null || namedData.name == null || ((ItemStack[])namedData.data).length == 0) {
            return;
        }
        double distance = this.distance();
        if (distance < 1.5) {
            return;
        }
        List<ItemStack> list = this.filterByNEI((ItemStack[])namedData.data);
        if (list.isEmpty()) {
            return;
        }
        int wantedSize = list.size();
        switch (Config.mode) {
            case 2: {
                wantedSize = 1;
                break;
            }
            case 3: {
                wantedSize = 3;
                break;
            }
            case 4: {
                wantedSize = 5;
                break;
            }
            case 5: {
                wantedSize = 7;
                break;
            }
            case 6: {
                wantedSize = 9;
            }
        }
        if (Config.mode != 0) {
            list.sort(Comparator.comparingInt(s -> s.field_77994_a).reversed());
            if (list.size() > wantedSize) {
                list = list.subList(0, wantedSize);
            }
        }
        if (Config.cycle != 0) {
            int i = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() / (long)Config.cycle % (long)list.size());
            list = Collections.singletonList(list.get(i));
        }
        this.doRenderHologram(namedData.name, list, distance);
    }

    private void doRenderHologram(String name, List<ItemStack> itemStacks, double distance) {
        GL11.glPushMatrix();
        this.moveAndRotate(-1.0);
        double uiScaleFactor = Config.renderScaling;
        if (uiScaleFactor < 0.1) {
            uiScaleFactor = 0.1;
        }
        GL11.glScaled((double)uiScaleFactor, (double)uiScaleFactor, (double)uiScaleFactor);
        float stackSpacing = 0.6f;
        if (Config.renderText) {
            for (ItemStack stack : itemStacks) {
                if (stack.field_77994_a < 1000 && stackSizeDebugOverride < 1000) continue;
                stackSpacing = 0.8f;
                break;
            }
        }
        this.timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        this.maxColumns = this.getMaxColumns(itemStacks.size());
        this.maxRows = itemStacks.size() % this.maxColumns == 0 ? itemStacks.size() / this.maxColumns - 1 : itemStacks.size() / this.maxColumns;
        this.blockScale = this.getBlockScaleModifier(this.maxColumns) + (float)((double)0.05f * distance);
        this.maxWith = (float)this.maxColumns * this.blockScale * (stackSpacing + 0.1f) * 0.4f;
        this.maxHeight = (float)this.maxRows * this.blockScale * (stackSpacing + 0.1f) * 0.4f;
        this.renderText = Config.renderText;
        if (Config.colorEnable) {
            this.renderBG();
        }
        if (Config.renderName) {
            this.renderName(name);
        }
        int column = 0;
        int row = 0;
        for (ItemStack item : itemStacks) {
            int stackSize = item.field_77994_a;
            if (!Config.renderMultiple) {
                item = item.func_77946_l();
                item.field_77994_a = 1;
            }
            this.renderItem(item, column, row, stackSize, stackSpacing);
            if (++column < this.maxColumns) continue;
            column = 0;
            ++row;
        }
        GL11.glPopMatrix();
    }

    private void moveAndRotate(double depth) {
        GL11.glTranslated((double)(this.coord.x - renderPosX), (double)(this.coord.y - renderPosY), (double)(this.coord.z - renderPosZ));
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)0.5f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)depth);
    }

    private float getBlockScaleModifier(int columns) {
        if (columns > 9) {
            return 0.2f - (float)columns * 0.005f;
        }
        return 0.2f + (float)(9 - columns) * 0.05f;
    }

    private int getMaxColumns(int size) {
        if (size < 9) {
            return size;
        }
        if (size <= 27) {
            return 9;
        }
        if (size <= 54) {
            return 11;
        }
        if (size <= 90) {
            return 14;
        }
        if (size <= 109) {
            return 18;
        }
        return 21;
    }

    private String doStackSizeCrap(int stackSize) {
        if (stackSizeDebugOverride != 0) {
            stackSize = stackSizeDebugOverride;
        }
        String string = Renderer.formatStackSize(stackSize);
        GL11.glTranslatef((float)((float)(-RenderManager.field_78727_a.func_78716_a().func_78256_a(string)) / 2.0f), (float)0.0f, (float)0.0f);
        return string;
    }

    private static String formatStackSize(long i) {
        int level;
        String[] suffixSelected = Config.renderSuffixDarkened ? suffixDarkened : suffixNormal;
        for (level = 0; i > 1000L && level < suffixSelected.length - 1; ++level, i /= 1000L) {
            if (i >= 100000L) {
                continue;
            }
            if (i >= 10000L) {
                return DF_ONE_FRACTION_DIGIT.format((double)i / 1000.0) + suffixSelected[level];
            }
            return DF_TWO_FRACTION_DIGIT.format((double)i / 1000.0) + suffixSelected[level];
        }
        return i + suffixSelected[level];
    }

    private void renderItem(ItemStack itemStack, int column, int row, int stackSize, float stackSpacing) {
        RenderHelper.func_74519_b();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.maxWith - ((float)column + 0.2f) * this.blockScale * stackSpacing), (float)(this.maxHeight - ((float)row + 0.05f) * this.blockScale * stackSpacing), (float)0.0f);
        GL11.glScalef((float)this.blockScale, (float)this.blockScale, (float)this.blockScale);
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glRotatef((float)(Config.rotateItems ? this.timeD : 0.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.customitem.func_92058_a(itemStack);
        ClientHandler.RENDER_ITEM.func_76986_a(this.customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (itemStack.hasEffect(0)) {
            GL11.glDisable((int)2896);
        }
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        if (this.renderText && (itemStack.func_77976_d() != 1 || itemStack.field_77994_a != 1)) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)(this.maxWith - ((float)column + 0.2f) * this.blockScale * stackSpacing), (float)(this.maxHeight - ((float)row + 0.05f) * this.blockScale * stackSpacing), (float)0.0f);
            GL11.glScalef((float)this.blockScale, (float)this.blockScale, (float)this.blockScale);
            GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
            RenderManager.field_78727_a.func_78716_a().func_85187_a(this.doStackSizeCrap(stackSize), 0, 0, -1426063361, true);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    private void renderBG() {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        tess.func_78371_b(7);
        tess.func_78370_a(Config.colorR, Config.colorG, Config.colorB, Config.colorAlpha);
        double d = this.blockScale / 3.0f;
        tess.func_78377_a((double)this.maxWith + d, -d - (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)(-this.maxWith) - d, -d - (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)(-this.maxWith) - d, d + (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)this.maxWith + d, d + (double)this.maxHeight, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private void renderName(String name) {
        FontRenderer fontRenderer = RenderManager.field_78727_a.func_78716_a();
        name = Config.nameOverrides.containsKey(name) ? Config.nameOverrides.get(name) : StatCollector.func_74838_a((String)name);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)0.0, (double)((double)this.maxHeight + (double)this.blockScale / 1.25), (double)0.0);
        GL11.glScaled((double)this.blockScale, (double)this.blockScale, (double)this.blockScale);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
        GL11.glTranslated((double)((float)fontRenderer.func_78256_a(name) / 2.0f), (double)0.0, (double)0.0);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        fontRenderer.func_85187_a(name, 0, 0, -1426063361, true);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private static void setRenderPos(float partialTicks) {
        EntityClientPlayerMP thePlayer = Minecraft.func_71410_x().field_71439_g;
        double lastTickPosX = thePlayer.field_70142_S;
        double posX = thePlayer.field_70165_t;
        renderPosX = lastTickPosX + (posX - lastTickPosX) * (double)partialTicks;
        renderPosY = thePlayer.field_70137_T + (thePlayer.field_70163_u - thePlayer.field_70137_T) * (double)partialTicks;
        renderPosZ = thePlayer.field_70136_U + (thePlayer.field_70161_v - thePlayer.field_70136_U) * (double)partialTicks;
    }

    private double distance() {
        double dx = this.coord.x - renderPosX;
        double dy = this.coord.y - renderPosY;
        double dz = this.coord.z - renderPosZ;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    static {
        INSTANCE = new Renderer();
    }
}

