/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.compat;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dries007.holoInventory.compat.InventoryDecoder;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DecoderRegistry {
    private static final Map<Class, InventoryDecoder> CACHE_MAP = new HashMap<Class, InventoryDecoder>();
    private static final List<InventoryDecoder> REGISTERED_INVENTORY_DECODERS = new ArrayList<InventoryDecoder>();
    private static final InventoryDecoder VANILLA = new InventoryDecoder(IInventory.class){

        @Override
        public NBTTagList toNBT(IInventory te) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack stack = te.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                tag.func_74768_a("Count", stack.field_77994_a);
                list.func_74742_a((NBTBase)tag);
            }
            return list;
        }
    };

    private DecoderRegistry() {
    }

    public static void init() {
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            REGISTERED_INVENTORY_DECODERS.add(new InventoryDecoder(IDrawerGroup.class){

                @Override
                public NBTTagList toNBT(IInventory te) {
                    IDrawerGroup drawerGroup = (IDrawerGroup)te;
                    NBTTagList list = new NBTTagList();
                    for (int i = 0; i < drawerGroup.getDrawerCount(); ++i) {
                        ItemStack stack = drawerGroup.getDrawer(i).getStoredItemCopy();
                        if (stack == null) continue;
                        NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                        tag.func_74768_a("Count", stack.field_77994_a);
                        list.func_74742_a((NBTBase)tag);
                    }
                    return list;
                }
            });
        }
    }

    public static NBTTagList toNBT(IInventory te) {
        Class<?> teClass = te.getClass();
        InventoryDecoder decoder = CACHE_MAP.get(teClass);
        if (decoder == null) {
            for (InventoryDecoder possibleDecoder : REGISTERED_INVENTORY_DECODERS) {
                if (!possibleDecoder.targetClass.isAssignableFrom(teClass)) continue;
                decoder = possibleDecoder;
                break;
            }
            if (decoder == null) {
                decoder = VANILLA;
            }
            CACHE_MAP.put(teClass, decoder);
        }
        return decoder.toNBT(te);
    }
}

