/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.server;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.server.HEQueueChunk;
import com.sinthoras.hydroenergy.server.QueueEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class HEBlockQueue {
    private static HashMap<Long, HEQueueChunk> chunks = new HashMap();
    private static long timestampLastQueueTick = 0L;

    public static void onTick() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - timestampLastQueueTick < (long)HEConfig.delayBetweenSpreadingChunks) {
            return;
        }
        timestampLastQueueTick = currentTime;
        Iterator<Map.Entry<Long, HEQueueChunk>> it = chunks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, HEQueueChunk> entry = it.next();
            HEQueueChunk chunk = entry.getValue();
            if (!chunk.isLoaded()) continue;
            it.remove();
            long key = entry.getKey();
            int chunkX = (int)(key >> 32);
            int chunkZ = (int)key;
            if (!chunk.resolve()) continue;
            World world = chunk.chunk.field_76637_e;
            HEBlockQueue.addToChunk(world, chunkX - 1, chunkZ, chunk.neighborChunkWest);
            HEBlockQueue.addToChunk(world, chunkX, chunkZ - 1, chunk.neighborChunkNorth);
            HEBlockQueue.addToChunk(world, chunkX + 1, chunkZ, chunk.neighborChunkEast);
            HEBlockQueue.addToChunk(world, chunkX, chunkZ + 1, chunk.neighborChunkSouth);
            return;
        }
    }

    private static void addToChunk(World world, int chunkX, int chunkZ, Stack<QueueEntry> stack) {
        if (!stack.isEmpty()) {
            long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ);
            if (chunks.containsKey(key)) {
                HEBlockQueue.chunks.get((Object)Long.valueOf((long)key)).blockStack.addAll(stack);
            } else {
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                chunks.put(key, new HEQueueChunk(chunk, stack));
            }
        }
    }

    public static void enqueueBlock(World world, int blockX, int blockY, int blockZ, int waterId) {
        int chunkZ;
        int chunkX = HEUtil.coordBlockToChunk(blockX);
        long key = HEUtil.chunkCoordsToKey(chunkX, chunkZ = HEUtil.coordBlockToChunk(blockZ));
        if (chunks.containsKey(key)) {
            chunks.get(key).add(blockX, blockY, blockZ, HE.waterBlocks[waterId]);
        } else {
            chunks.put(key, new HEQueueChunk(world.func_72964_e(chunkX, chunkZ), HE.waterBlocks[waterId], blockX, blockY, blockZ));
        }
    }
}

