/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.client.renderer;

import com.google.common.base.Charsets;
import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.client.HEClient;
import com.sinthoras.hydroenergy.config.HEConfig;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class HEProgram {
    private static final ResourceLocation vertexShaderLocation = new ResourceLocation("hydroenergy", "shader/hewater/shader.vsh");
    private static final ResourceLocation geometryShaderLocation = new ResourceLocation("hydroenergy", "shader/hewater/shader.gsh");
    private static final ResourceLocation fragmentShaderLocation = new ResourceLocation("hydroenergy", "shader/hewater/shader.fsh");
    private static int programId;
    private static int viewProjectionId;
    private static int waterLevelsId;
    private static int debugStatesId;
    private static int lightLookupTableId;
    private static int atlasTextureId;
    private static int texCoordStillMinId;
    private static int texCoordStillDeltaId;
    private static int texCoordFlowingMinId;
    private static int texCoordFlowingDeltaId;
    private static int fogDiffId;
    private static int fogEndId;
    private static int fogDensityId;
    private static int fogModeLinearId;
    private static int fogColorId;
    private static int cameraPositionId;
    private static int renderOffsetId;
    private static final FloatBuffer projection;
    private static final FloatBuffer modelview;
    private static final FloatBuffer modelviewProjection;
    private static final FloatBuffer waterLevels;
    private static final FloatBuffer debugStates;
    private static float fogColorRed;
    private static float fogColorGreen;
    private static float fogColorBlue;

    public static void init() {
        if (GLContext.getCapabilities().OpenGL32 && !HEConfig.useLimitedRendering || HEConfig.forceOpenGL) {
            String defines = "#version 330 core\n#define NUM_CONTROLLERS " + HEConfig.maxDams + "\n#define CLIPPING_OFFSET " + HEConfig.clippingOffset + "\n";
            int vertexShader = HEProgram.loadShader(vertexShaderLocation, 35633, defines);
            int geometryShader = HEProgram.loadShader(geometryShaderLocation, 36313, defines);
            int fragmentShader = HEProgram.loadShader(fragmentShaderLocation, 35632, defines);
            programId = GL20.glCreateProgram();
            GL20.glAttachShader((int)programId, (int)vertexShader);
            GL20.glAttachShader((int)programId, (int)geometryShader);
            GL20.glAttachShader((int)programId, (int)fragmentShader);
            GL20.glLinkProgram((int)programId);
            if (GL20.glGetProgrami((int)programId, (int)35714) == 0) {
                String s = StringUtils.trim((String)GL20.glGetProgramInfoLog((int)programId, (int)32768));
                HE.error("Shader program linking failed: " + s);
                programId = -1;
                return;
            }
            viewProjectionId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_viewProjection");
            waterLevelsId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_waterLevels");
            debugStatesId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_debugModes");
            lightLookupTableId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_lightLUT");
            atlasTextureId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_atlasTexture");
            texCoordStillMinId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_texCoordStillMin");
            texCoordStillDeltaId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_texCoordStillDelta");
            texCoordFlowingMinId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_texCoordFlowingMin");
            texCoordFlowingDeltaId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_texCoordFlowingDelta");
            fogDiffId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_fogDiff");
            fogEndId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_fogEnd");
            fogDensityId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_fogDensity");
            fogModeLinearId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_fogModeLinear");
            fogColorId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_fogColor");
            cameraPositionId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_cameraPosition");
            renderOffsetId = GL20.glGetUniformLocation((int)programId, (CharSequence)"g_renderOffset");
            GL20.glUseProgram((int)0);
            HE.info("Render pipeline initialized.");
        } else {
            HE.info("Render pipeline NOT initialized. OpenGL 3.2 is not supported! Fallback to vanilla rendering. Expect visual \"anomalies\"...");
        }
    }

    private static int loadShader(ResourceLocation shaderLocation, int type, String defines) {
        try {
            InputStream shaderStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(shaderLocation).func_110527_b();
            BufferedInputStream bufferedinputstream = new BufferedInputStream(shaderStream);
            byte[] shaderBytes = IOUtils.toByteArray((InputStream)bufferedinputstream);
            byte[] definesBytes = defines.getBytes(Charsets.US_ASCII);
            ByteBuffer bytebuffer = BufferUtils.createByteBuffer((int)(shaderBytes.length + definesBytes.length));
            bytebuffer.put(definesBytes);
            bytebuffer.put(shaderBytes);
            bytebuffer.flip();
            int shaderID = GL20.glCreateShader((int)type);
            GL20.glShaderSource((int)shaderID, (ByteBuffer)bytebuffer);
            GL20.glCompileShader((int)shaderID);
            if (GL20.glGetShaderi((int)shaderID, (int)35713) == 0) {
                String s = StringUtils.trim((String)GL20.glGetShaderInfoLog((int)shaderID, (int)32768));
                HE.error("Couldn't compile shader: " + s);
                return -1;
            }
            GL20.glUseProgram((int)programId);
            return shaderID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void setViewProjection(float cameraX, float cameraY, float cameraZ) {
        projection.clear();
        modelview.clear();
        modelviewProjection.clear();
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelview);
        Matrix4f translation = new Matrix4f().translate(new Vector3f(-cameraX, -cameraY, -cameraZ));
        Matrix4f projectionMatrix = (Matrix4f)new Matrix4f().load(projection.asReadOnlyBuffer());
        Matrix4f modelViewMatrix = (Matrix4f)new Matrix4f().load(modelview.asReadOnlyBuffer());
        Matrix4f result = Matrix4f.mul((Matrix4f)modelViewMatrix, (Matrix4f)translation, null);
        result = Matrix4f.mul((Matrix4f)projectionMatrix, (Matrix4f)result, null);
        result.store(modelviewProjection);
        modelviewProjection.flip();
        GL20.glUniformMatrix4((int)viewProjectionId, (boolean)false, (FloatBuffer)modelviewProjection);
    }

    public static void setCameraPosition(float cameraX, float cameraY, float cameraZ) {
        GL20.glUniform3f((int)cameraPositionId, (float)cameraX, (float)cameraY, (float)cameraZ);
    }

    public static void setWaterLevels() {
        waterLevels.clear();
        waterLevels.put(HEClient.getAllWaterLevelsForRendering());
        waterLevels.flip();
        GL20.glUniform1((int)waterLevelsId, (FloatBuffer)waterLevels);
    }

    public static void setDebugStates() {
        debugStates.clear();
        debugStates.put(HEClient.getDebugStatesAsFactors());
        debugStates.flip();
        GL20.glUniform1((int)debugStatesId, (FloatBuffer)debugStates);
    }

    public static void setWaterUV() {
        IIcon iconStill = FluidRegistry.WATER.getStillIcon();
        float minU = iconStill.func_94209_e();
        float minV = iconStill.func_94206_g();
        GL20.glUniform2f((int)texCoordStillMinId, (float)minU, (float)minV);
        GL20.glUniform2f((int)texCoordStillDeltaId, (float)(iconStill.func_94212_f() - minU), (float)(iconStill.func_94210_h() - minV));
        IIcon iconFlowing = FluidRegistry.WATER.getFlowingIcon();
        minU = iconFlowing.func_94209_e();
        minV = iconFlowing.func_94206_g();
        GL20.glUniform2f((int)texCoordFlowingMinId, (float)minU, (float)minV);
        GL20.glUniform2f((int)texCoordFlowingDeltaId, (float)(iconFlowing.func_94212_f() - minU), (float)(iconFlowing.func_94210_h() - minV));
    }

    public static void setCullFronts() {
        GL11.glCullFace((int)1028);
        GL20.glUniform1f((int)renderOffsetId, (float)0.005f);
    }

    public static void setCullBacks() {
        GL11.glCullFace((int)1029);
        GL20.glUniform1f((int)renderOffsetId, (float)0.0f);
    }

    public static void setFog() {
        float fogStart = GL11.glGetFloat((int)2915);
        float fogEnd = GL11.glGetFloat((int)2916);
        GL20.glUniform1f((int)fogDiffId, (float)(fogEnd - fogStart));
        GL20.glUniform1f((int)fogEndId, (float)fogEnd);
        GL20.glUniform1f((int)fogDensityId, (float)GL11.glGetFloat((int)2914));
        GL20.glUniform1f((int)fogModeLinearId, (float)(GL11.glGetFloat((int)2917) == 9729.0f ? 1.0f : 0.0f));
        GL20.glUniform3f((int)fogColorId, (float)fogColorRed, (float)fogColorGreen, (float)fogColorBlue);
    }

    public static void setFogColor(float red, float green, float blue) {
        fogColorRed = red;
        fogColorGreen = green;
        fogColorBlue = blue;
    }

    public static void bindLightLookupTable() {
        GL13.glActiveTexture((int)33985);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(Minecraft.func_71410_x().field_71460_t.field_110922_T);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL20.glUniform1i((int)lightLookupTableId, (int)1);
        GL13.glActiveTexture((int)33984);
    }

    public static void bindAtlasTexture() {
        GL13.glActiveTexture((int)33986);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL20.glUniform1i((int)atlasTextureId, (int)2);
        GL13.glActiveTexture((int)33984);
    }

    public static void bind() {
        GL20.glUseProgram((int)programId);
    }

    public static void unbind() {
        GL20.glUseProgram((int)0);
    }

    static {
        projection = GLAllocation.func_74529_h((int)16);
        modelview = GLAllocation.func_74529_h((int)16);
        modelviewProjection = GLAllocation.func_74529_h((int)16);
        waterLevels = GLAllocation.func_74529_h((int)HEConfig.maxDams);
        debugStates = GLAllocation.func_74529_h((int)HEConfig.maxDams);
        fogColorRed = 0.0f;
        fogColorGreen = 0.0f;
        fogColorBlue = 0.0f;
    }
}

