/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.server.HEServer;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class HEHydroDamTileEntity
extends TTMultiblockBase
implements IConstructable {
    private static Textures.BlockIcons.CustomIcon Screen;
    private static final int steelTextureIndex = 16;
    private static final int concreteBlockMeta = 8;
    private int waterId = -1;
    private long euStored = 0L;
    private long euCapacity = 0L;
    private long euCapacityGui = 0L;
    private int euPerTickIn = 0;
    private int euPerTickOut = 0;
    private final HEUtil.AveragedRingBuffer euPerTickOutAverage = new HEUtil.AveragedRingBuffer(64);
    private final HEUtil.AveragedRingBuffer euPerTickInAverage = new HEUtil.AveragedRingBuffer(64);
    private static final IStructureDefinition<HEHydroDamTileEntity> multiblockDefinition;
    private static final String[] mouseOverDescription;
    private static final String[] chatDescription;

    public HEHydroDamTileEntity(String name) {
        super(name);
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftMallet = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
    }

    public HEHydroDamTileEntity(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity tileEntity) {
        return new HEHydroDamTileEntity(this.mName);
    }

    protected boolean checkMachine_EM(IGregTechTileEntity gregTechTileEntity, ItemStack itemStack) {
        return this.structureCheck_EM("main", 2, 3, 0);
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM("main", 2, 3, 0, itemStack, hintsOnly);
    }

    public IStructureDefinition<HEHydroDamTileEntity> getStructure_EM() {
        return multiblockDefinition;
    }

    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.mMaxProgresstime = 1;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private float getMaxGuiPressure() {
        return HEConfig.pressureIncreasePerTier * (float)this.getVoltageTier();
    }

    private int getVoltageTier() {
        boolean configCircuitIsPresent = this.mInventory != null && this.mInventory[1] != null && this.mInventory[1].func_77973_b() == GTUtility.getIntegratedCircuit((int)0).func_77973_b();
        return configCircuitIsPresent ? HEUtil.clamp(this.mInventory[1].func_77960_j(), 1, GTValues.V.length - 1) : 1;
    }

    public boolean onRunningTick(ItemStack stack) {
        this.mProgresstime = 0;
        this.euPerTickIn = 0;
        this.euPerTickOut = 0;
        this.euCapacity = HEServer.instance.getEuCapacity(this.waterId);
        this.euStored = HEUtil.clamp(this.euStored, 0L, this.euCapacity);
        this.euCapacityGui = HEServer.instance.getEuCapacityAt(this.waterId, (int)((float)this.getBaseMetaTileEntity().getYCoord() + this.getMaxGuiPressure()));
        int waterLevelOverController = (int)(HEServer.instance.getWaterLevel(this.waterId) - (float)this.getBaseMetaTileEntity().getYCoord());
        this.getStoredFluids().forEach(fluidStack -> {
            if (fluidStack.getFluidID() == HE.pressurizedWater.getID() && HE.pressurizedWater.getPressure((FluidStack)fluidStack) >= (float)waterLevelOverController) {
                long availableEnergy = (long)((float)fluidStack.amount * HEConfig.euPerMilliBucket);
                long storableEnergy = Math.min(this.euCapacity - this.euStored, availableEnergy);
                fluidStack.amount = (int)((long)fluidStack.amount - storableEnergy);
                this.euStored += storableEnergy;
                this.euPerTickIn = (int)((long)this.euPerTickIn + storableEnergy);
            }
        });
        int availableOutput = (int)Math.min((long)HEConfig.damDrainPerSecond, this.euStored);
        int availableOutputAsWater = (int)((float)availableOutput * HEConfig.milliBucketPerEU);
        if (availableOutput > 0) {
            int distributedFluid = this.distributeFluid(new FluidStack((Fluid)HE.pressurizedWater, availableOutputAsWater));
            long distributedEu = (long)((float)distributedFluid * HEConfig.euPerMilliBucket);
            this.euStored -= distributedEu;
            this.euPerTickOut = (int)((long)this.euPerTickOut + distributedEu);
        }
        if (this.getBaseMetaTileEntity().getWorld().func_72896_J()) {
            long rainingEuGeneration = (long)((float)HEServer.instance.getRainedOnBlocks(this.waterId) * HEConfig.waterBonusPerSurfaceBlockPerRainTick);
            long addedEu = Math.min(this.euCapacity - this.euStored, rainingEuGeneration);
            this.euStored += addedEu;
            this.euPerTickIn = (int)((long)this.euPerTickIn + addedEu);
        }
        this.euPerTickInAverage.addValue(this.euPerTickIn);
        this.euPerTickOutAverage.addValue(this.euPerTickOut);
        HEServer.instance.setWaterLevel(this.waterId, this.euStored);
        return true;
    }

    private int distributeFluid(FluidStack fluidStack) {
        int availableFluid = fluidStack.amount;
        for (MTEHatchOutput hatch : (ArrayList)GTUtility.filterValidMTEs((Collection)this.mOutputHatches)) {
            if (!hatch.outputsLiquids() || hatch.isFluidLocked() && hatch.getLockedFluidName() != null && !hatch.getLockedFluidName().equals(fluidStack.getUnlocalizedName())) continue;
            FluidStack currentFluid = hatch.getFillableStack();
            if (currentFluid == null || currentFluid.getFluid().getID() <= 0) {
                currentFluid = new FluidStack((Fluid)HE.pressurizedWater, 0);
            }
            if (currentFluid.getFluid().getID() != HE.pressurizedWater.getID()) continue;
            int availableSpace = hatch.getCapacity() - currentFluid.amount;
            int placedFluid = Math.min(availableSpace, fluidStack.amount);
            fluidStack.amount -= placedFluid;
            currentFluid.amount += placedFluid;
            hatch.setFillableStack(currentFluid);
        }
        return availableFluid - fluidStack.amount;
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer player, float blockX, float blockY, float blockZ, ItemStack tool) {
        if (!player.func_70093_af() && this.getBaseMetaTileEntity().isServerSide()) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)"hydroenergy", (int)0, (World)this.getBaseMetaTileEntity().getWorld(), (int)this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), (int)this.getBaseMetaTileEntity().getZCoord());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister blockIconRegister) {
        Screen = new Textures.BlockIcons.CustomIcon("iconsets/he_dam");
        super.registerIcons(blockIconRegister);
    }

    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean isActive, boolean hasRedstoneSignal) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16), new TTRenderedExtendedFacingTexture((IIconContainer)Screen)};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)16)};
    }

    public boolean doRandomMaintenanceDamage() {
        return true;
    }

    public void onFirstTick_EM(IGregTechTileEntity baseMetaTileEntity) {
        if (this.waterId == -1 && this.getBaseMetaTileEntity().isServerSide()) {
            int offsetZ;
            int offsetX;
            ForgeDirection direction = this.getExtendedFacing().getDirection();
            boolean offsetY = true;
            if (direction == ForgeDirection.WEST) {
                offsetX = 2;
                offsetZ = 0;
            } else if (direction == ForgeDirection.NORTH) {
                offsetX = 0;
                offsetZ = 2;
            } else if (direction == ForgeDirection.EAST) {
                offsetX = -2;
                offsetZ = 0;
            } else {
                offsetX = 0;
                offsetZ = -2;
            }
            this.waterId = HEServer.instance.onPlacecontroller(this.getBaseMetaTileEntity().getOwnerName(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getXCoord() + offsetX, this.getBaseMetaTileEntity().getYCoord() + 1, this.getBaseMetaTileEntity().getZCoord() + offsetZ);
            this.func_70296_d();
        }
        super.onFirstTick_EM(baseMetaTileEntity);
    }

    public void onRemoval() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            HEServer.instance.onBreakController(this.waterId);
        }
        super.onRemoval();
    }

    public void saveNBTData(NBTTagCompound compound) {
        super.saveNBTData(compound);
        compound.func_74768_a("waId", this.waterId);
        compound.func_74772_a("wSto", this.euStored);
        compound.func_74772_a("wCap", this.euCapacity);
    }

    public void loadNBTData(NBTTagCompound compound) {
        super.loadNBTData(compound);
        this.waterId = compound.func_74762_e("waId");
        this.euStored = compound.func_74763_f("wSto");
        this.euCapacity = compound.func_74763_f("wCap");
    }

    public String[] getDescription() {
        return mouseOverDescription;
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return chatDescription;
    }

    public long getEuStored() {
        return this.euStored;
    }

    public long getEuCapacity() {
        return this.euCapacityGui;
    }

    public int getEuPerTickIn() {
        return (int)this.euPerTickInAverage.getAverage();
    }

    public int getEuPerTickOut() {
        return (int)this.euPerTickOutAverage.getAverage();
    }

    public int getWaterId() {
        return this.waterId;
    }

    public boolean isPowerPassButtonEnabled() {
        return false;
    }

    public boolean isSafeVoidButtonEnabled() {
        return false;
    }

    public boolean isAllowedToWorkButtonEnabled() {
        return false;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.waterId, val -> {
            this.waterId = val;
        }))).widget(TextWidget.dynamicString(() -> "Hydro Dam (" + GTValues.VN[this.getVoltageTier()] + ")").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 8))).widget(new TextWidget(GTUtility.trans((String)"142", (String)"Running perfectly.")).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 16))).widget(TextWidget.dynamicString(() -> {
            if (this.getFillMultiplier() > 1.0f) {
                return "Please upgrade circuit config (>" + this.getVoltageTier() + ").";
            }
            return "";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(7, 84))).widget(TextWidget.dynamicString(() -> this.euStored + " EU / " + this.euCapacity + " EU").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(70, 35).attachSyncer((FakeSyncWidget)new FakeSyncWidget.LongSyncer(() -> this.euStored, val -> {
            this.euStored = val;
        }), (IWidgetBuilder)builder, (widget, val) -> {
            if (widget.isClient()) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                widget.setPos(99 - fontRenderer.func_78256_a("/") / 2 - fontRenderer.func_78256_a(this.euStored + " EU "), 35);
            }
        }))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.euCapacity, val -> {
            this.euCapacity = val;
        }))).widget(TextWidget.dynamicString(() -> {
            float fillMultiplier = this.getFillMultiplier();
            if (fillMultiplier > 1.0f) {
                return ">100.00%";
            }
            return String.format("%.2f", Float.valueOf(fillMultiplier * 100.0f)) + "%";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(49, 50).setSize(100, 9))).widget(TextWidget.dynamicString(() -> "IN: " + this.euPerTickIn + " EU/t").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(7, 65))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.euPerTickIn, val -> {
            this.euPerTickIn = val;
        }))).widget(TextWidget.dynamicString(() -> "OUT: " + this.euPerTickOut + " EU/t").setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setTextAlignment(Alignment.CenterRight).setPos(91, 65).setSize(100, 9))).widget((Widget)new FakeSyncWidget.IntegerSyncer(() -> this.euPerTickOut, val -> {
            this.euPerTickOut = val;
        }))).widget(TextWidget.dynamicString(() -> {
            if (this.getFillMultiplier() > 1.0f) {
                return "Please upgrade circuit config (>" + this.getVoltageTier() + ").";
            }
            return "Click me with a screwdriver.";
        }).setSynced(false).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(7, 84));
    }

    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
    }

    private float getFillMultiplier() {
        return (float)this.euCapacity == 0.0f ? 0.0f : (float)this.euStored / (float)this.euCapacity;
    }

    static {
        multiblockDefinition = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"HHHHH", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"HHHHH", "C   C", "C   C", "C   C", "C   C"}, {"HHHHH", "C   C", "C   C", "C   C", "C   C"}, {"HH~HH", "C   C", "C   C", "C   C", "C   C"}, {"HHHHH", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}})).addElement('H', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(TTMultiblockBase::addClassicToMachineList, (int)16, (Block)GregTechAPI.sBlockConcretes, (int)8), StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockConcretes, (int)8)})).addElement('C', StructureUtility.ofBlockAnyMeta((Block)GregTechAPI.sBlockConcretes, (int)8)).build();
        mouseOverDescription = new String[]{"Hydro Dam Controller", "Controller Block for the Hydro Dam", "Input is pressurized water from Hydro Pumps", "Output is pressurized water for Hydro Turbines", "Requires an Input and Output Hatch on the front!", HE.blueprintHintTecTech};
        chatDescription = new String[]{"1 Fluid Input Hatch", "1 Fluid Output Hatch", "Fill the rest with Light Concrete", "No Maintenance Hatch required!"};
    }
}

