/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.blocks;

import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.sinthoras.hydroenergy.config.HEConfig;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_StructureUtility;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public abstract class HETieredTileEntity
extends GT_MetaTileEntity_MultiblockBase_EM
implements IConstructable {
    private int countOfHatches = 0;
    private IStructureDefinition<HETieredTileEntity> multiblockDefinition = null;

    protected HETieredTileEntity(int blockId, String name, String nameRegional) {
        super(blockId, name, nameRegional);
    }

    protected HETieredTileEntity(String name) {
        super(name);
    }

    protected abstract int getTier();

    protected Block getCasingBlock() {
        switch (this.getTier()) {
            default: {
                return GregTech_API.sBlockCasings2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                return GregTech_API.sBlockCasings4;
            }
            case 6: 
            case 7: 
            case 9: 
            case 11: 
        }
        return GregTech_API.sBlockCasings8;
    }

    protected int getCasingMeta() {
        switch (this.getTier()) {
            default: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 9: {
                return 2;
            }
            case 11: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: 
        }
        return 14;
    }

    protected int getCasingTextureId() {
        Block casingBlock = this.getCasingBlock();
        int metaId = this.getCasingMeta();
        if (casingBlock == GregTech_API.sBlockCasings1) {
            return metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings2) {
            return 16 + metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings3) {
            return 32 + metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings4) {
            return 48 + metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings5) {
            return 64 + metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings6) {
            return 80 + metaId;
        }
        if (casingBlock == GregTech_API.sBlockCasings8) {
            return 112 + metaId;
        }
        return 0;
    }

    protected String getCasingName() {
        return GT_LanguageManager.getTranslation((String)(this.getCasingBlock().func_149739_a() + "." + this.getCasingMeta() + ".name"));
    }

    protected long getVoltage() {
        return GT_Values.V[this.getTier()];
    }

    protected float getPressure() {
        return (float)this.getTier() * HEConfig.pressureIncreasePerTier;
    }

    protected float getEfficiencyModifier() {
        return 1.0f - (float)this.getTier() * HEConfig.efficiencyLossPerTier;
    }

    protected String getEfficiencyModifierInPercent() {
        return String.format("%.0f", Float.valueOf(this.getEfficiencyModifier() * 100.0f)) + "%";
    }

    protected int getMilliBucketsPerTick() {
        return (int)((float)this.getVoltage() * HEConfig.milliBucketPerEU);
    }

    protected abstract void onTick();

    public boolean onRunningTick(ItemStack stack) {
        this.mProgresstime = 0;
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.energyFlowOnRunningTick(stack, false)) {
            this.onTick();
        }
        return true;
    }

    protected abstract long getEnergyConsumption();

    public boolean checkRecipe_EM(ItemStack stack) {
        this.mMaxProgresstime = 1;
        this.mEUt = (int)this.getEnergyConsumption();
        this.mEfficiencyIncrease = 10000;
        return true;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity gregTechTileEntity, ItemStack itemStack) {
        this.countOfHatches = 0;
        return this.structureCheck_EM("main", 1, 1, 0) && this.countOfHatches == 4;
    }

    public void construct(ItemStack itemStack, boolean hintsOnly) {
        this.structureBuild_EM("main", 1, 1, 0, itemStack, hintsOnly);
    }

    public IStructureDefinition<HETieredTileEntity> getStructure_EM() {
        if (this.multiblockDefinition == null) {
            Block casingBlock = this.getCasingBlock();
            int casingMeta = this.getCasingMeta();
            this.multiblockDefinition = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(x -> ++x.countOfHatches, (IStructureElement)GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicToMachineList, (int)this.getCasingTextureId(), (Block)casingBlock, (int)casingMeta)), StructureUtility.ofBlock((Block)casingBlock, (int)casingMeta)})).build();
        }
        return this.multiblockDefinition;
    }
}

